/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.definition;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.cdc.common.utils.StringUtils;

public class TransformDef {
    private final String sourceTable;
    private final String projection;
    private final String filter;
    private final String description;
    private final String primaryKeys;
    private final String partitionKeys;
    private final String tableOptions;

    public TransformDef(String sourceTable, String projection, String filter, String primaryKeys, String partitionKeys, String tableOptions, String description) {
        this.sourceTable = sourceTable;
        this.projection = projection;
        this.filter = filter;
        this.primaryKeys = primaryKeys;
        this.partitionKeys = partitionKeys;
        this.tableOptions = tableOptions;
        this.description = description;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public Optional<String> getProjection() {
        return Optional.ofNullable(this.projection);
    }

    public boolean isValidProjection() {
        return !StringUtils.isNullOrWhitespaceOnly((String)this.projection);
    }

    public Optional<String> getFilter() {
        return Optional.ofNullable(this.filter);
    }

    public boolean isValidFilter() {
        return !StringUtils.isNullOrWhitespaceOnly((String)this.filter);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public String getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getTableOptions() {
        return this.tableOptions;
    }

    public String toString() {
        return "TransformDef{sourceTable='" + this.sourceTable + '\'' + ", projection='" + this.projection + '\'' + ", filter='" + this.filter + '\'' + ", description='" + this.description + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformDef that = (TransformDef)o;
        return Objects.equals(this.sourceTable, that.sourceTable) && Objects.equals(this.projection, that.projection) && Objects.equals(this.filter, that.filter) && Objects.equals(this.description, that.description) && Objects.equals(this.primaryKeys, that.primaryKeys) && Objects.equals(this.partitionKeys, that.partitionKeys) && Objects.equals(this.tableOptions, that.tableOptions);
    }

    public int hashCode() {
        return Objects.hash(this.sourceTable, this.projection, this.filter, this.description, this.primaryKeys, this.partitionKeys, this.tableOptions);
    }
}

