/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.composer.definition;

import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.flink.cdc.common.annotation.VisibleForTesting;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.pipeline.PipelineOptions;
import org.apache.flink.cdc.composer.definition.RouteDef;
import org.apache.flink.cdc.composer.definition.SinkDef;
import org.apache.flink.cdc.composer.definition.SourceDef;
import org.apache.flink.cdc.composer.definition.TransformDef;

public class PipelineDef {
    private final SourceDef source;
    private final SinkDef sink;
    private final List<RouteDef> routes;
    private final List<TransformDef> transforms;
    private final Configuration config;

    public PipelineDef(SourceDef source, SinkDef sink, List<RouteDef> routes, List<TransformDef> transforms, Configuration config) {
        this.source = source;
        this.sink = sink;
        this.routes = routes;
        this.transforms = transforms;
        this.config = PipelineDef.evaluatePipelineTimeZone(config);
    }

    public SourceDef getSource() {
        return this.source;
    }

    public SinkDef getSink() {
        return this.sink;
    }

    public List<RouteDef> getRoute() {
        return this.routes;
    }

    public List<TransformDef> getTransforms() {
        return this.transforms;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String toString() {
        return "PipelineDef{source=" + this.source + ", sink=" + this.sink + ", routes=" + this.routes + ", transforms=" + this.transforms + ", config=" + this.config + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineDef that = (PipelineDef)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.sink, that.sink) && Objects.equals(this.routes, that.routes) && Objects.equals(this.transforms, that.transforms) && Objects.equals(this.config, that.config);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.sink, this.routes, this.transforms, this.config);
    }

    @VisibleForTesting
    private static Configuration evaluatePipelineTimeZone(Configuration configuration) {
        ZoneId zoneId;
        String zone = (String)configuration.get(PipelineOptions.PIPELINE_LOCAL_TIME_ZONE);
        if (((String)PipelineOptions.PIPELINE_LOCAL_TIME_ZONE.defaultValue()).equals(zone)) {
            zoneId = ZoneId.systemDefault();
        } else {
            PipelineDef.validateTimeZone(zone);
            zoneId = ZoneId.of(zone);
        }
        configuration.set(PipelineOptions.PIPELINE_LOCAL_TIME_ZONE, (Object)zoneId.toString());
        return configuration;
    }

    private static void validateTimeZone(String zone) {
        boolean isValid;
        try {
            isValid = TimeZone.getTimeZone(zone).toZoneId().equals(ZoneId.of(zone));
        }
        catch (Exception ignore) {
            isValid = false;
        }
        if (!isValid) {
            throw new IllegalArgumentException("Invalid time zone. The valid value should be a Time Zone Database ID such as 'America/Los_Angeles' to include daylight saving time. Fixed offsets are supported using 'GMT-08:00' or 'GMT+08:00'. Or use 'UTC' without time zone and daylight saving time.");
        }
    }
}

