/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli.utils;

import java.io.File;
import org.apache.flink.cdc.cli.utils.ConfigurationUtils;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.shaded.guava31.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkEnvironmentUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkEnvironmentUtils.class);
    private static final String FLINK_CONF_DIR = "conf";
    private static final String LEGACY_FLINK_CONF_FILENAME = "flink-conf.yaml";
    private static final String FLINK_CONF_FILENAME = "config.yaml";

    public static Configuration loadFlinkConfiguration(Path flinkHome) throws Exception {
        Path flinkConfPath = new Path(flinkHome, Joiner.on((String)File.separator).join((Object)FLINK_CONF_DIR, (Object)FLINK_CONF_FILENAME, new Object[0]));
        if (flinkConfPath.getFileSystem().exists(flinkConfPath)) {
            return ConfigurationUtils.loadConfigFile(flinkConfPath);
        }
        return ConfigurationUtils.loadConfigFile(new Path(flinkHome, Joiner.on((String)File.separator).join((Object)FLINK_CONF_DIR, (Object)LEGACY_FLINK_CONF_FILENAME, new Object[0])), true);
    }
}

