/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.cdc.cli.utils.YamlParserUtils;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.core.fs.Path;

public class ConfigurationUtils {
    private static final String KEY_SEPARATOR = ".";

    public static Configuration loadConfigFile(Path configPath) throws Exception {
        return ConfigurationUtils.loadConfigFile(configPath, false);
    }

    public static Configuration loadConfigFile(Path configPath, boolean allowDuplicateKeys) throws Exception {
        Map<String, Object> configMap = YamlParserUtils.loadYamlFile(new File(configPath.toUri().getPath()), allowDuplicateKeys);
        return Configuration.fromMap(ConfigurationUtils.flattenConfigMap(configMap, ""));
    }

    private static Map<String, String> flattenConfigMap(Map<String, Object> config, String keyPrefix) {
        HashMap<String, String> flattenedMap = new HashMap<String, String>();
        config.forEach((key, value) -> {
            String flattenedKey = keyPrefix + key;
            if (value instanceof Map) {
                Map e = (Map)value;
                flattenedMap.putAll(ConfigurationUtils.flattenConfigMap(e, flattenedKey + KEY_SEPARATOR));
            } else if (value instanceof List) {
                flattenedMap.put(flattenedKey, YamlParserUtils.toYAMLString(value));
            } else {
                flattenedMap.put(flattenedKey, value.toString());
            }
        });
        return flattenedMap;
    }

    public static Class<?> getClaimModeClass() {
        try {
            return Class.forName("org.apache.flink.core.execution.RestoreMode");
        }
        catch (ClassNotFoundException ignored) {
            try {
                return Class.forName("org.apache.flink.runtime.jobgraph.RestoreMode");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

