/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.cli.parser;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.cdc.cli.parser.PipelineDefinitionParser;
import org.apache.flink.cdc.common.configuration.Configuration;
import org.apache.flink.cdc.common.utils.Preconditions;
import org.apache.flink.cdc.common.utils.StringUtils;
import org.apache.flink.cdc.composer.definition.PipelineDef;
import org.apache.flink.cdc.composer.definition.RouteDef;
import org.apache.flink.cdc.composer.definition.SinkDef;
import org.apache.flink.cdc.composer.definition.SourceDef;
import org.apache.flink.cdc.composer.definition.TransformDef;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;

public class YamlPipelineDefinitionParser
implements PipelineDefinitionParser {
    private static final String SOURCE_KEY = "source";
    private static final String SINK_KEY = "sink";
    private static final String ROUTE_KEY = "route";
    private static final String TRANSFORM_KEY = "transform";
    private static final String PIPELINE_KEY = "pipeline";
    private static final String TYPE_KEY = "type";
    private static final String NAME_KEY = "name";
    private static final String ROUTE_SOURCE_TABLE_KEY = "source-table";
    private static final String ROUTE_SINK_TABLE_KEY = "sink-table";
    private static final String ROUTE_DESCRIPTION_KEY = "description";
    private static final String TRANSFORM_SOURCE_TABLE_KEY = "source-table";
    private static final String TRANSFORM_PROJECTION_KEY = "projection";
    private static final String TRANSFORM_FILTER_KEY = "filter";
    private static final String TRANSFORM_DESCRIPTION_KEY = "description";
    public static final String TRANSFORM_PRIMARY_KEY_KEY = "primary-keys";
    public static final String TRANSFORM_PARTITION_KEY_KEY = "partition-keys";
    public static final String TRANSFORM_TABLE_OPTION_KEY = "table-options";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    @Override
    public PipelineDef parse(Path pipelineDefPath, Configuration globalPipelineConfig) throws Exception {
        JsonNode root = this.mapper.readTree(pipelineDefPath.toFile());
        SourceDef sourceDef = this.toSourceDef((JsonNode)Preconditions.checkNotNull((Object)root.get(SOURCE_KEY), (String)"Missing required field \"%s\" in pipeline definition", (Object[])new Object[]{SOURCE_KEY}));
        SinkDef sinkDef = this.toSinkDef((JsonNode)Preconditions.checkNotNull((Object)root.get(SINK_KEY), (String)"Missing required field \"%s\" in pipeline definition", (Object[])new Object[]{SINK_KEY}));
        ArrayList transformDefs = new ArrayList();
        Optional.ofNullable(root.get(TRANSFORM_KEY)).ifPresent(node -> node.forEach(transform -> transformDefs.add(this.toTransformDef((JsonNode)transform))));
        ArrayList routeDefs = new ArrayList();
        Optional.ofNullable(root.get(ROUTE_KEY)).ifPresent(node -> node.forEach(route -> routeDefs.add(this.toRouteDef((JsonNode)route))));
        Configuration userPipelineConfig = this.toPipelineConfig(root.get(PIPELINE_KEY));
        Configuration pipelineConfig = new Configuration();
        pipelineConfig.addAll(globalPipelineConfig);
        pipelineConfig.addAll(userPipelineConfig);
        return new PipelineDef(sourceDef, sinkDef, routeDefs, transformDefs, pipelineConfig);
    }

    private SourceDef toSourceDef(JsonNode sourceNode) {
        Map sourceMap = (Map)this.mapper.convertValue((Object)sourceNode, (TypeReference)new TypeReference<Map<String, String>>(){});
        String type = (String)Preconditions.checkNotNull(sourceMap.remove(TYPE_KEY), (String)"Missing required field \"%s\" in source configuration", (Object[])new Object[]{TYPE_KEY});
        String name = (String)sourceMap.remove(NAME_KEY);
        return new SourceDef(type, name, Configuration.fromMap((Map)sourceMap));
    }

    private SinkDef toSinkDef(JsonNode sinkNode) {
        Map sinkMap = (Map)this.mapper.convertValue((Object)sinkNode, (TypeReference)new TypeReference<Map<String, String>>(){});
        String type = (String)Preconditions.checkNotNull(sinkMap.remove(TYPE_KEY), (String)"Missing required field \"%s\" in sink configuration", (Object[])new Object[]{TYPE_KEY});
        String name = (String)sinkMap.remove(NAME_KEY);
        return new SinkDef(type, name, Configuration.fromMap((Map)sinkMap));
    }

    private RouteDef toRouteDef(JsonNode routeNode) {
        String sourceTable = ((JsonNode)Preconditions.checkNotNull((Object)routeNode.get("source-table"), (String)"Missing required field \"%s\" in route configuration", (Object[])new Object[]{"source-table"})).asText();
        String sinkTable = ((JsonNode)Preconditions.checkNotNull((Object)routeNode.get(ROUTE_SINK_TABLE_KEY), (String)"Missing required field \"%s\" in route configuration", (Object[])new Object[]{ROUTE_SINK_TABLE_KEY})).asText();
        String description = Optional.ofNullable(routeNode.get("description")).map(JsonNode::asText).orElse(null);
        return new RouteDef(sourceTable, sinkTable, description);
    }

    private TransformDef toTransformDef(JsonNode transformNode) {
        String sourceTable = ((JsonNode)Preconditions.checkNotNull((Object)transformNode.get("source-table"), (String)"Missing required field \"%s\" in transform configuration", (Object[])new Object[]{"source-table"})).asText();
        String projection = Optional.ofNullable(transformNode.get(TRANSFORM_PROJECTION_KEY)).map(JsonNode::asText).orElse(null);
        if (!StringUtils.isNullOrWhitespaceOnly((String)projection) && projection.contains("\\*")) {
            projection = projection.replace("\\*", "*");
        }
        String filter = Optional.ofNullable(transformNode.get(TRANSFORM_FILTER_KEY)).map(JsonNode::asText).orElse(null);
        String primaryKeys = Optional.ofNullable(transformNode.get(TRANSFORM_PRIMARY_KEY_KEY)).map(JsonNode::asText).orElse(null);
        String partitionKeys = Optional.ofNullable(transformNode.get(TRANSFORM_PARTITION_KEY_KEY)).map(JsonNode::asText).orElse(null);
        String tableOptions = Optional.ofNullable(transformNode.get(TRANSFORM_TABLE_OPTION_KEY)).map(JsonNode::asText).orElse(null);
        String description = Optional.ofNullable(transformNode.get("description")).map(JsonNode::asText).orElse(null);
        return new TransformDef(sourceTable, projection, filter, primaryKeys, partitionKeys, tableOptions, description);
    }

    private Configuration toPipelineConfig(JsonNode pipelineConfigNode) {
        if (pipelineConfigNode == null || pipelineConfigNode.isNull()) {
            return new Configuration();
        }
        Map pipelineConfigMap = (Map)this.mapper.convertValue((Object)pipelineConfigNode, (TypeReference)new TypeReference<Map<String, String>>(){});
        return Configuration.fromMap((Map)pipelineConfigMap);
    }
}

