/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.formats.avro.utils.DataInputDecoder;
import org.apache.flink.formats.avro.utils.DataOutputEncoder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class AvroFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AvroFactory.class);
    private final DataOutputEncoder encoder = new DataOutputEncoder();
    private final DataInputDecoder decoder = new DataInputDecoder();
    private final GenericData avroData;
    private final Schema schema;
    private final DatumWriter<T> writer;
    private final DatumReader<T> reader;

    static <T> AvroFactory<T> create(Class<T> type, @Nullable Schema currentSchema, @Nullable Schema previousSchema) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (SpecificRecord.class.isAssignableFrom(type)) {
            return AvroFactory.fromSpecific(type, cl, Optional.ofNullable(previousSchema));
        }
        if (GenericRecord.class.isAssignableFrom(type)) {
            return AvroFactory.fromGeneric(cl, currentSchema);
        }
        return AvroFactory.fromReflective(type, cl, Optional.ofNullable(previousSchema));
    }

    @Nullable
    static Schema parseSchemaString(@Nullable String schemaString) {
        return schemaString == null ? null : new Schema.Parser().parse(schemaString);
    }

    private static <T> AvroFactory<T> fromSpecific(Class<T> type, ClassLoader cl, Optional<Schema> previousSchema) {
        SpecificData specificData = AvroFactory.getSpecificDataForClass(type, cl);
        Schema newSchema = AvroFactory.extractAvroSpecificSchema(type, specificData);
        return new AvroFactory<T>((GenericData)specificData, newSchema, new SpecificDatumReader(previousSchema.orElse(newSchema), newSchema, specificData), new SpecificDatumWriter(newSchema, specificData));
    }

    private static <T> AvroFactory<T> fromGeneric(ClassLoader cl, Schema schema) {
        Preconditions.checkNotNull((Object)schema, (String)"Unable to create an AvroSerializer with a GenericRecord type without a schema");
        GenericData genericData = new GenericData(cl);
        return new AvroFactory<T>(genericData, schema, new GenericDatumReader(schema, schema, genericData), new GenericDatumWriter(schema, genericData));
    }

    private static <T> AvroFactory<T> fromReflective(Class<T> type, ClassLoader cl, Optional<Schema> previousSchema) {
        ReflectData reflectData = new ReflectData(cl);
        Schema newSchema = reflectData.getSchema(type);
        return new AvroFactory<T>((GenericData)reflectData, newSchema, new ReflectDatumReader(previousSchema.orElse(newSchema), newSchema, reflectData), new ReflectDatumWriter(newSchema, reflectData));
    }

    public static <T> Schema extractAvroSpecificSchema(Class<T> type, SpecificData specificData) {
        Optional<Schema> newSchemaOptional = AvroFactory.tryExtractAvroSchemaViaInstance(type);
        return newSchemaOptional.orElseGet(() -> specificData.getSchema((Type)type));
    }

    public static <T extends SpecificData> SpecificData getSpecificDataForClass(Class<T> type, ClassLoader cl) {
        try {
            Field specificDataField = type.getDeclaredField("MODEL$");
            specificDataField.setAccessible(true);
            return (SpecificData)specificDataField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new FlinkRuntimeException("Could not access the MODEL$ field of avro record", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            return new SpecificData(cl);
        }
    }

    private static Optional<Schema> tryExtractAvroSchemaViaInstance(Class<?> type) {
        try {
            SpecificRecord instance = (SpecificRecord)type.newInstance();
            return Optional.ofNullable(instance.getSchema());
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Could not extract schema from Avro-generated SpecificRecord class {}: {}.", type, (Object)e);
            return Optional.empty();
        }
    }

    private AvroFactory(GenericData avroData, Schema schema, DatumReader<T> reader, DatumWriter<T> writer) {
        this.avroData = (GenericData)Preconditions.checkNotNull((Object)avroData);
        this.schema = (Schema)Preconditions.checkNotNull((Object)schema);
        this.writer = (DatumWriter)Preconditions.checkNotNull(writer);
        this.reader = (DatumReader)Preconditions.checkNotNull(reader);
    }

    DataOutputEncoder getEncoder() {
        return this.encoder;
    }

    DataInputDecoder getDecoder() {
        return this.decoder;
    }

    Schema getSchema() {
        return this.schema;
    }

    DatumWriter<T> getWriter() {
        return this.writer;
    }

    DatumReader<T> getReader() {
        return this.reader;
    }

    GenericData getAvroData() {
        return this.avroData;
    }
}

