/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.registry.confluent.debezium;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.avro.registry.confluent.AvroConfluentFormatOptions;
import org.apache.flink.formats.avro.registry.confluent.RegistryAvroFormatFactory;
import org.apache.flink.formats.avro.registry.confluent.debezium.DebeziumAvroDeserializationSchema;
import org.apache.flink.formats.avro.registry.confluent.debezium.DebeziumAvroSerializationSchema;
import org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.Projection;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.ProjectableDecodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

@Internal
public class DebeziumAvroFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "debezium-avro-confluent";

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String schemaRegistryURL = (String)formatOptions.get(AvroConfluentFormatOptions.URL);
        final String schema = formatOptions.getOptional(AvroConfluentFormatOptions.SCHEMA).orElse(null);
        final Map<String, String> optionalPropertiesMap = RegistryAvroFormatFactory.buildOptionalPropertiesMap(formatOptions);
        return new ProjectableDecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType, int[][] projections) {
                producedDataType = Projection.of((int[][])projections).project(producedDataType);
                RowType rowType = (RowType)producedDataType.getLogicalType();
                TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
                return new DebeziumAvroDeserializationSchema(rowType, (TypeInformation<RowData>)producedTypeInfo, schemaRegistryURL, schema, optionalPropertiesMap);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String schemaRegistryURL = (String)formatOptions.get(AvroConfluentFormatOptions.URL);
        final Optional subject = formatOptions.getOptional(AvroConfluentFormatOptions.SUBJECT);
        final String schema = formatOptions.getOptional(AvroConfluentFormatOptions.SCHEMA).orElse(null);
        final Map<String, String> optionalPropertiesMap = RegistryAvroFormatFactory.buildOptionalPropertiesMap(formatOptions);
        if (!subject.isPresent()) {
            throw new ValidationException(String.format("Option '%s.%s' is required for serialization", IDENTIFIER, AvroConfluentFormatOptions.SUBJECT.key()));
        }
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_BEFORE).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
            }

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType rowType = (RowType)consumedDataType.getLogicalType();
                return new DebeziumAvroSerializationSchema(rowType, schemaRegistryURL, (String)subject.get(), schema, optionalPropertiesMap);
            }
        };
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(AvroConfluentFormatOptions.URL);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(AvroConfluentFormatOptions.SUBJECT);
        options.add(AvroConfluentFormatOptions.PROPERTIES);
        options.add(AvroConfluentFormatOptions.SCHEMA);
        options.add(AvroConfluentFormatOptions.SSL_KEYSTORE_LOCATION);
        options.add(AvroConfluentFormatOptions.SSL_KEYSTORE_PASSWORD);
        options.add(AvroConfluentFormatOptions.SSL_TRUSTSTORE_LOCATION);
        options.add(AvroConfluentFormatOptions.SSL_TRUSTSTORE_PASSWORD);
        options.add(AvroConfluentFormatOptions.BASIC_AUTH_CREDENTIALS_SOURCE);
        options.add(AvroConfluentFormatOptions.BASIC_AUTH_USER_INFO);
        options.add(AvroConfluentFormatOptions.BEARER_AUTH_CREDENTIALS_SOURCE);
        options.add(AvroConfluentFormatOptions.BEARER_AUTH_TOKEN);
        return options;
    }

    static void validateSchemaString(@Nullable String schemaString, RowType rowType) {
        LogicalType convertedDataType;
        if (schemaString != null && !(convertedDataType = AvroSchemaConverter.convertToDataType((String)schemaString).getLogicalType()).equals((Object)rowType)) {
            throw new IllegalArgumentException(String.format("Schema provided for '%s' format must be a nullable record type with fields 'before', 'after', 'op' and schema of fields 'before' and 'after' must match the table schema: %s", IDENTIFIER, schemaString));
        }
    }
}

