/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.URL;
import org.apache.felix.webconsole.internal.servlet.AbstractPluginAdapter;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.osgi.framework.ServiceReference;

public class EnhancedPluginAdapter
extends AbstractPluginAdapter {
    private static final long serialVersionUID = 1L;
    private final AbstractServlet plugin;

    public EnhancedPluginAdapter(AbstractServlet plugin, ServiceReference<Servlet> serviceReference, String label, String title, String[] cssReferences) {
        super(serviceReference.getBundle().getBundleContext(), label, title, cssReferences);
        this.plugin = plugin;
    }

    @Override
    protected URL getResource(String path) {
        return null;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.plugin.init(config);
        }
        catch (ServletException se) {
            this.deactivate();
            throw se;
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CheckHttpServletResponse checkResponse = new CheckHttpServletResponse(resp);
        this.plugin.service((ServletRequest)req, (ServletResponse)checkResponse);
        if (!checkResponse.isDone()) {
            this.doGet(req, resp);
        }
    }

    @Override
    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.plugin.renderContent(req, res);
    }

    public void destroy() {
        try {
            this.plugin.destroy();
            super.destroy();
        }
        finally {
            this.deactivate();
        }
    }

    private static final class CheckHttpServletResponse
    extends HttpServletResponseWrapper {
        private boolean done = false;

        public CheckHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public boolean isDone() {
            return this.done;
        }

        public void reset() {
            this.done = false;
            super.reset();
        }

        public void sendError(int sc) throws IOException {
            this.done = true;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.done = true;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.done = true;
            super.sendRedirect(location);
        }

        public void setStatus(int sc) {
            this.done = true;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.done = true;
            super.setStatus(sc);
        }

        public void setContentType(String type) {
            this.done = true;
            super.setContentType(type);
        }
    }
}

