/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class ConfigurationAdminConfigurationPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Configurations";

    @Override
    public String getTitle() {
        return TITLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printConfiguration(PrintWriter pw) {
        ServiceReference sr = this.getBundleContext().getServiceReference(ConfigurationAdmin.class);
        try {
            ConfigurationAdmin ca;
            ConfigurationAdmin configurationAdmin = ca = sr == null ? null : (ConfigurationAdmin)this.getBundleContext().getService(sr);
            if (ca == null) {
                pw.println("Status: Configuration Admin Service not available");
            } else {
                Configuration[] configs = ca.listConfigurations(null);
                if (configs != null && configs.length > 0) {
                    HashSet<String> factories = new HashSet<String>();
                    TreeMap<String, Configuration> sm = new TreeMap<String, Configuration>();
                    for (int i = 0; i < configs.length; ++i) {
                        sm.put(configs[i].getPid(), configs[i]);
                        String fpid = configs[i].getFactoryPid();
                        if (null == fpid) continue;
                        factories.add(fpid);
                    }
                    if (factories.isEmpty()) {
                        pw.println("Status: " + configs.length + " configurations available");
                    } else {
                        pw.println("Status: " + configs.length + " configurations with " + factories.size() + " different factories available");
                    }
                    pw.println();
                    Iterator mi = sm.values().iterator();
                    while (mi.hasNext()) {
                        this.printConfiguration(pw, (Configuration)mi.next());
                    }
                } else {
                    pw.println("Status: No Configurations available");
                }
            }
        }
        catch (Exception e) {
            pw.println("Status: Configuration Admin Service not accessible");
        }
        finally {
            if (sr != null) {
                this.getBundleContext().ungetService(sr);
            }
        }
    }

    private void printConfiguration(PrintWriter pw, Configuration config) {
        Dictionary props;
        ConfigurationRender.infoLine(pw, "", "PID", config.getPid());
        if (config.getFactoryPid() != null) {
            ConfigurationRender.infoLine(pw, "  ", "Factory PID", config.getFactoryPid());
        }
        if (config.getBundleLocation() != null) {
            ConfigurationRender.infoLine(pw, "  ", "BundleLocation", config.getBundleLocation());
        }
        if ((props = config.getProperties()) != null) {
            TreeSet keys = new TreeSet();
            Enumeration ke = props.keys();
            while (ke.hasMoreElements()) {
                keys.add(ke.nextElement());
            }
            for (String key : keys) {
                if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "service.bundleLocation".equals(key)) continue;
                ConfigurationRender.infoLine(pw, "  ", key, props.get(key));
            }
        }
        pw.println();
    }
}

