/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class BundlesConfigurationPrinter
extends AbstractConfigurationPrinter {
    private ServiceTracker packageAdminTracker;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.packageAdminTracker = new ServiceTracker(bundleContext, (class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = BundlesConfigurationPrinter.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName(), null);
        this.packageAdminTracker.open();
    }

    public void deactivate() {
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        super.deactivate();
    }

    public String getTitle() {
        return "Bundlelist";
    }

    private String getHeaderValue(Bundle b, String name) {
        String val = (String)b.getHeaders().get(name);
        if (val == null) {
            val = "";
        }
        return val;
    }

    private String getState(int state) {
        switch (state) {
            case 32: {
                return "active";
            }
            case 2: {
                return "installed";
            }
            case 4: {
                return "resolved";
            }
            case 8: {
                return "starting";
            }
            case 16: {
                return "stopping";
            }
            case 1: {
                return "uninstalled";
            }
        }
        return String.valueOf(state);
    }

    private final boolean isFragmentBundle(Bundle bundle) {
        return ((PackageAdmin)this.packageAdminTracker.getService()).getBundleType(bundle) == 1;
    }

    public void printConfiguration(PrintWriter pw) {
        Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
        TreeMap<String, String> bundlesMap = new TreeMap<String, String>();
        int active = 0;
        int installed = 0;
        int resolved = 0;
        int fragments = 0;
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            String symbolicName = bundle.getSymbolicName();
            String version = (String)bundle.getHeaders().get("Bundle-Version");
            switch (bundle.getState()) {
                case 32: {
                    ++active;
                    break;
                }
                case 2: {
                    ++installed;
                    break;
                }
                case 4: {
                    if (this.isFragmentBundle(bundle)) {
                        ++fragments;
                        break;
                    }
                    ++resolved;
                }
            }
            String key = symbolicName + ':' + version;
            String value = MessageFormat.format("{0} ({1}) \"{2}\" [{3}, {4}] {5}", symbolicName, version, this.getHeaderValue(bundle, "Bundle-Name"), this.getState(bundle.getState()), String.valueOf(bundle.getBundleId()), this.isFragmentBundle(bundle) ? "(fragment)" : "");
            bundlesMap.put(key, value);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Status: ");
        this.appendBundleInfoCount(buffer, "in total", bundles.length);
        if (active == bundles.length || active + fragments == bundles.length) {
            buffer.append(" - all ");
            this.appendBundleInfoCount(buffer, "active.", bundles.length);
        } else {
            if (active != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active", active);
            }
            if (fragments != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active fragments", fragments);
            }
            if (resolved != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "resolved", resolved);
            }
            if (installed != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "installed", installed);
            }
        }
        pw.println(buffer.toString());
        pw.println();
        Iterator i = bundlesMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            pw.println(entry.getValue());
        }
    }

    private void appendBundleInfoCount(StringBuffer buf, String msg, int count) {
        buf.append(count);
        buf.append(" bundle");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

