/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.core.ServicesUsedInfoProvider;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServicesServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin {
    private static final ServiceReference[] NO_REFS = new ServiceReference[0];
    public static final String LABEL = "services";
    private static final String TITLE = "%services.pluginTitle";
    private static final String[] CSS = null;
    private static final String FILTER_PARAM = "filter";
    private final String TEMPLATE = this.readTemplateFile("/templates/services.html");
    private ServiceRegistration bipReg;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$ServicesServlet;

    static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute((class$org$apache$felix$webconsole$internal$core$ServicesServlet == null ? (class$org$apache$felix$webconsole$internal$core$ServicesServlet = ServicesServlet.class$("org.apache.felix.webconsole.internal.core.ServicesServlet")) : class$org$apache$felix$webconsole$internal$core$ServicesServlet).getName());
    }

    public ServicesServlet() {
        super(LABEL, TITLE, "OSGi", CSS);
    }

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.bipReg = new ServicesUsedInfoProvider(bundleContext.getBundle()).register(bundleContext);
    }

    public void deactivate() {
        if (null != this.bipReg) {
            this.bipReg.unregister();
            this.bipReg = null;
        }
        super.deactivate();
    }

    final ServiceReference getServiceById(String pathInfo) {
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        StringBuffer filter = new StringBuffer();
        filter.append("(").append("service.id").append("=");
        filter.append(pathInfo).append(")");
        String filterStr = filter.toString();
        try {
            ServiceReference[] refs = this.getBundleContext().getAllServiceReferences(null, filterStr);
            if (refs == null || refs.length != 1) {
                return null;
            }
            return refs[0];
        }
        catch (InvalidSyntaxException e) {
            this.log("Unable to search for services using filter " + filterStr, e);
            return null;
        }
    }

    private final ServiceReference[] getServices(String filter) {
        if (filter != null && filter.trim().length() == 0) {
            filter = null;
        }
        try {
            ServiceReference[] refs = this.getBundleContext().getAllServiceReferences(null, filter);
            if (refs != null) {
                return refs;
            }
        }
        catch (InvalidSyntaxException e) {
            this.log("Unable to access service reference list.", e);
        }
        return NO_REFS;
    }

    static final String getStatusLine(ServiceReference[] services) {
        int count = services.length;
        StringBuffer buffer = new StringBuffer();
        buffer.append(count);
        buffer.append(" service");
        if (count != 1) {
            buffer.append('s');
        }
        buffer.append(" in total");
        return buffer.toString();
    }

    static final String propertyAsString(ServiceReference ref, String name) {
        Object value = ref.getProperty(name);
        return WebConsoleUtil.toString(value);
    }

    private void renderJSON(HttpServletResponse response, ServiceReference service, Locale locale) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw, service, locale, null);
    }

    private void serviceDetails(JSONWriter jw, ServiceReference service) throws JSONException {
        String[] keys = service.getPropertyKeys();
        jw.key("props");
        jw.array();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if ("service.pid".equals(key)) {
                WebConsoleUtil.keyVal(jw, "Service PID", service.getProperty(key));
                continue;
            }
            if ("service.description".equals(key)) {
                WebConsoleUtil.keyVal(jw, "Service Description", service.getProperty(key));
                continue;
            }
            if ("service.vendor".equals(key)) {
                WebConsoleUtil.keyVal(jw, "Service Vendor", service.getProperty(key));
                continue;
            }
            if ("objectClass".equals(key) || "service.id".equals(key)) continue;
            WebConsoleUtil.keyVal(jw, key, service.getProperty(key));
        }
        jw.endArray();
    }

    private void usingBundles(JSONWriter jw, ServiceReference service, Locale locale) throws JSONException {
        jw.key("usingBundles");
        jw.array();
        Bundle[] usingBundles = service.getUsingBundles();
        if (usingBundles != null) {
            for (int i = 0; i < usingBundles.length; ++i) {
                jw.object();
                this.bundleInfo(jw, usingBundles[i], locale);
                jw.endObject();
            }
        }
        jw.endArray();
    }

    private void serviceInfo(JSONWriter jw, ServiceReference service, boolean details, Locale locale) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)ServicesServlet.propertyAsString(service, "service.id"));
        jw.key("types");
        jw.value((Object)ServicesServlet.propertyAsString(service, "objectClass"));
        jw.key("pid");
        jw.value((Object)ServicesServlet.propertyAsString(service, "service.pid"));
        this.bundleInfo(jw, service.getBundle(), locale);
        if (details) {
            this.serviceDetails(jw, service);
            this.usingBundles(jw, service, locale);
        }
        jw.endObject();
    }

    private void bundleInfo(JSONWriter jw, Bundle bundle, Locale locale) throws JSONException {
        jw.key("bundleId");
        jw.value(bundle.getBundleId());
        jw.key("bundleName");
        jw.value((Object)Util.getName(bundle, locale));
        jw.key("bundleVersion");
        jw.value((Object)Util.getHeaderValue(bundle, "Bundle-Version"));
        jw.key("bundleSymbolicName");
        jw.value((Object)bundle.getSymbolicName());
    }

    private void writeJSON(Writer pw, ServiceReference service, Locale locale, String filter) throws IOException {
        this.writeJSON(pw, service, false, locale, filter);
    }

    private void writeJSON(Writer pw, ServiceReference service, boolean fullDetails, Locale locale, String filter) throws IOException {
        ServiceReference[] serviceReferenceArray;
        ServiceReference[] allServices = this.getServices(filter);
        String statusLine = ServicesServlet.getStatusLine(allServices);
        if (service != null) {
            ServiceReference[] serviceReferenceArray2 = new ServiceReference[1];
            serviceReferenceArray = serviceReferenceArray2;
            serviceReferenceArray2[0] = service;
        } else {
            serviceReferenceArray = allServices;
        }
        ServiceReference[] services = serviceReferenceArray;
        JSONWriter jw = new JSONWriter(pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("serviceCount");
            jw.value((long)allServices.length);
            jw.key("data");
            jw.array();
            for (int i = 0; i < services.length; ++i) {
                this.serviceInfo(jw, services[i], fullDetails || service != null, locale);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo().indexOf("/res/") == -1) {
            RequestInfo reqInfo = new RequestInfo(request);
            if (reqInfo.service == null && reqInfo.serviceRequested) {
                response.sendError(404);
                return;
            }
            if (reqInfo.extension.equals("json")) {
                this.renderJSON(response, reqInfo.service, request.getLocale());
                return;
            }
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = ServicesServlet.getRequestInfo(request);
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        StringWriter w = new StringWriter();
        String filter = request.getParameter(FILTER_PARAM);
        this.writeJSON(w, reqInfo.service, request.getLocale(), filter);
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("bundlePath", appRoot + "/" + "bundles" + "/");
        vars.put("drawDetails", String.valueOf(reqInfo.serviceRequested));
        vars.put("__data__", w.toString());
        vars.put(FILTER_PARAM, filter == null ? "" : filter);
        response.getWriter().print(this.TEMPLATE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RequestInfo {
        public final String extension;
        public final ServiceReference service;
        public final boolean serviceRequested;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(ServicesServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            String serviceInfo = null;
            if (info.startsWith("/")) {
                serviceInfo = info.substring(1);
            }
            if (serviceInfo == null || serviceInfo.length() == 0) {
                this.service = null;
                this.serviceRequested = false;
            } else {
                this.service = ServicesServlet.this.getServiceById(serviceInfo);
                this.serviceRequested = true;
            }
            request.setAttribute((class$org$apache$felix$webconsole$internal$core$ServicesServlet == null ? (class$org$apache$felix$webconsole$internal$core$ServicesServlet = ServicesServlet.class$("org.apache.felix.webconsole.internal.core.ServicesServlet")) : class$org$apache$felix$webconsole$internal$core$ServicesServlet).getName(), (Object)this);
        }
    }
}

