/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.configuration.ConfigManager;
import org.apache.felix.webconsole.internal.configuration.MetaTypeServiceSupport;
import org.apache.felix.webconsole.internal.configuration.MetaTypeSupport;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.ObjectClassDefinition;

class ConfigAdminSupport {
    private final BundleContext bundleContext;
    private final ConfigurationAdmin service;
    private final ConfigManager configManager;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    ConfigAdminSupport(ConfigManager configManager, BundleContext bundleContext, Object service) {
        this.configManager = configManager;
        this.bundleContext = bundleContext;
        this.service = (ConfigurationAdmin)service;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    private MetaTypeServiceSupport getMetaTypeSupport() {
        Object metaTypeService = this.configManager.getService("org.osgi.service.metatype.MetaTypeService");
        if (metaTypeService != null) {
            return new MetaTypeServiceSupport(this.getBundleContext(), metaTypeService);
        }
        return null;
    }

    final Configuration getConfiguration(String pid) {
        if (pid != null) {
            try {
                String filter = "(service.pid=" + pid + ')';
                Configuration[] configs = this.service.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    final Configuration getConfiguration(String pid, String factoryPid) throws IOException {
        if (factoryPid != null && (pid == null || pid.equals("[Temporary PID replaced by real PID upon save]"))) {
            return this.service.createFactoryConfiguration(factoryPid, null);
        }
        return this.service.getConfiguration(pid, null);
    }

    Configuration getPlaceholderConfiguration(String factoryPid) {
        return new PlaceholderConfiguration(factoryPid);
    }

    String getPlaceholderPid() {
        return "[Temporary PID replaced by real PID upon save]";
    }

    String applyConfiguration(HttpServletRequest request, String pid) throws IOException {
        if (request.getParameter("delete") != null) {
            if (!"[Temporary PID replaced by real PID upon save]".equals(pid)) {
                this.configManager.log("applyConfiguration: Deleting configuration " + pid);
                Configuration config = this.service.getConfiguration(pid, null);
                config.delete();
            }
            return null;
        }
        String factoryPid = request.getParameter("factoryPid");
        Configuration config = null;
        String propertyList = request.getParameter("propertylist");
        if (propertyList != null) {
            MetaTypeServiceSupport mtss;
            config = this.getConfiguration(pid, factoryPid);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            Map adMap = (mtss = this.getMetaTypeSupport()) != null ? mtss.getAttributeDefinitionMap(config, null) : new HashMap();
            StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
            ArrayList<String> propsToKeep = new ArrayList<String>();
            while (propTokens.hasMoreTokens()) {
                String prop;
                String propName = propTokens.nextToken();
                String paramName = "action".equals(propName) || "delete".equals(propName) || "apply".equals(propName) || "propertylist".equals(propName) ? '$' + propName : propName;
                propsToKeep.add(propName);
                PropertyDescriptor ad = (PropertyDescriptor)adMap.get(propName);
                if (ad == null) {
                    Object currentValue = ((Dictionary)props).get(propName);
                    ad = MetaTypeSupport.createAttributeDefinition(propName, currentValue);
                }
                int attributeType = MetaTypeSupport.getAttributeType(ad);
                if (ad == null || ad.getCardinality() == 0 && (attributeType == 1 || attributeType == 12)) {
                    prop = request.getParameter(paramName);
                    if (prop == null || attributeType == 12 && "unmodified".equals(prop)) continue;
                    ((Dictionary)props).put(propName, prop);
                    continue;
                }
                if (ad.getCardinality() == 0) {
                    prop = request.getParameter(paramName);
                    if (prop == null) continue;
                    try {
                        ((Dictionary)props).put(propName, MetaTypeSupport.toType(attributeType, prop));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                Vector<Object> vec = new Vector<Object>();
                String[] properties = request.getParameterValues(paramName);
                if (properties != null) {
                    if (attributeType == 12) {
                        MetaTypeSupport.setPasswordProps(vec, properties, ((Dictionary)props).get(propName));
                    } else {
                        for (int i = 0; i < properties.length; ++i) {
                            try {
                                vec.add(MetaTypeSupport.toType(attributeType, properties[i]));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                    }
                }
                int maxSize = Math.abs(ad.getCardinality());
                if (vec.size() > maxSize && maxSize > 0) {
                    vec.setSize(maxSize);
                }
                if (ad.getCardinality() < 0) {
                    if (vec.isEmpty()) {
                        ((Dictionary)props).remove(propName);
                        continue;
                    }
                    ((Dictionary)props).put(propName, vec);
                    continue;
                }
                ((Dictionary)props).put(propName, MetaTypeSupport.toArray(attributeType, vec));
            }
            Hashtable updateProps = new Hashtable(((Dictionary)props).size());
            Enumeration e = ((Dictionary)props).keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                if (!propsToKeep.contains(key)) continue;
                ((Dictionary)updateProps).put(key, ((Dictionary)props).get(key));
            }
            config.update(updateProps);
        }
        return config != null ? config.getPid() : "";
    }

    void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter((Writer)pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                this.configManager.log("Error reading configuration PID " + pid, e);
            }
        }
    }

    void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws JSONException {
        json.key("pid");
        json.value((Object)pid);
        if (pidFilter != null) {
            json.key("pidFilter");
            json.value((Object)pidFilter);
        }
        Hashtable props = null;
        if (config != null) {
            props = config.getProperties();
        }
        if (props == null) {
            props = new Hashtable();
        }
        boolean doSimpleMerge = true;
        MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
        if (mtss != null) {
            ObjectClassDefinition ocd = null;
            if (config != null) {
                ocd = mtss.getObjectClassDefinition(config, locale);
            }
            if (ocd == null) {
                ocd = mtss.getObjectClassDefinition(pid, locale);
            }
            if (ocd != null) {
                mtss.mergeWithMetaType(props, ocd, json);
                doSimpleMerge = false;
            }
        }
        if (doSimpleMerge) {
            json.key("title").value((Object)pid);
            json.key("description").value((Object)"This form is automatically generated from existing properties because no property descriptors are available for this configuration. This may be cause by the absence of the OSGi Metatype Service or the absence of a MetaType descriptor for this configuration.");
            json.key("properties").object();
            Enumeration pe = ((Dictionary)props).keys();
            while (pe.hasMoreElements()) {
                String id = (String)pe.nextElement();
                if (id.equals("service.pid") || id.equals("service.description") || id.equals("service.id") || id.equals("service.vendor") || id.equals("service.bundleLocation") || id.equals("service.factoryPid")) continue;
                Object value = ((Dictionary)props).get(id);
                PropertyDescriptor ad = MetaTypeServiceSupport.createAttributeDefinition(id, value);
                json.key(id);
                MetaTypeServiceSupport.attributeToJson(json, ad, value);
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws JSONException {
        String location;
        if (config.getFactoryPid() != null) {
            json.key("factoryPid");
            json.value((Object)config.getFactoryPid());
        }
        if (config.getBundleLocation() == null) {
            location = "";
        } else {
            Bundle bundle = MetaTypeServiceSupport.getBundle(this.getBundleContext(), config.getBundleLocation());
            if (bundle == null) {
                location = config.getBundleLocation();
            } else {
                Dictionary headers = bundle.getHeaders(locale);
                String name = (String)headers.get("Bundle-Name");
                location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ')';
                Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
                location = location + ", Version " + v.toString();
            }
        }
        json.key("bundleLocation");
        json.value((Object)location);
        String pid = config.getPid();
        String serviceLocation = "";
        try {
            ServiceReference[] refs = this.getBundleContext().getServiceReferences(null, "(&(objectClass=" + (class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigAdminSupport.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName() + ")(" + "service.pid" + '=' + pid + "))");
            if (refs != null && refs.length > 0) {
                serviceLocation = refs[0].getBundle().getLocation();
            }
        }
        catch (Throwable t) {
            this.configManager.log("Error getting service associated with configuration " + pid, t);
        }
        json.key("bundle_location");
        json.value((Object)config.getBundleLocation());
        json.key("service_location");
        json.value((Object)serviceLocation);
    }

    private final Bundle getBoundBundle(Configuration config) {
        if (null == config) {
            return null;
        }
        String location = config.getBundleLocation();
        if (null == location) {
            return null;
        }
        Bundle[] bundles = this.getBundleContext().getBundles();
        for (int i = 0; bundles != null && i < bundles.length; ++i) {
            if (!bundles[i].getLocation().equals(location)) continue;
            return bundles[i];
        }
        return null;
    }

    final void listConfigurations(JSONObject json, String pidFilter, String locale, Locale loc) {
        try {
            SortedMap optionsPlain = this.getServices((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigAdminSupport.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), pidFilter, locale, true);
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null) {
                this.addMetaTypeNames(optionsPlain, mtss.getPidObjectClasses(locale), pidFilter, "service.pid");
            }
            Configuration[] cfgs = this.service.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid) || !ConfigManager.isAllowedPid(pid)) continue;
                if (mtss != null) {
                    try {
                        ObjectClassDefinition ocd = mtss.getObjectClassDefinition(cfgs[i], locale);
                        if (ocd != null) {
                            optionsPlain.put(pid, ocd.getName());
                            continue;
                        }
                    }
                    catch (IllegalArgumentException t) {
                        // empty catch block
                    }
                }
                optionsPlain.put(pid, pid);
            }
            Iterator ii = optionsPlain.keySet().iterator();
            while (ii.hasNext()) {
                String id = (String)ii.next();
                Object name = optionsPlain.get(id);
                Configuration config = this.getConfiguration(id);
                JSONObject data = new JSONObject().put("id", (Object)id).put("name", name);
                if (null != config) {
                    Bundle bundle;
                    data.put("has_config", true);
                    String fpid = config.getFactoryPid();
                    if (null != fpid) {
                        data.put("fpid", (Object)fpid);
                    }
                    if (null != (bundle = this.getBoundBundle(config))) {
                        data.put("bundle", bundle.getBundleId());
                        data.put("bundle_name", (Object)Util.getName(bundle, loc));
                    }
                }
                json.append("pids", (Object)data);
            }
        }
        catch (Exception e) {
            this.configManager.log("listConfigurations: Unexpected problem encountered", e);
        }
    }

    final void listFactoryConfigurations(JSONObject json, String pidFilter, String locale) {
        try {
            SortedMap optionsFactory = this.getServices((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigAdminSupport.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), pidFilter, locale, true);
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null) {
                this.addMetaTypeNames(optionsFactory, mtss.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            }
            Iterator ii = optionsFactory.keySet().iterator();
            while (ii.hasNext()) {
                String id = (String)ii.next();
                Object name = optionsFactory.get(id);
                json.append("fpids", (Object)new JSONObject().put("id", (Object)id).put("name", name));
            }
        }
        catch (Exception e) {
            this.configManager.log("listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    SortedMap getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            ObjectClassDefinition ocd;
            String pid;
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String) || !ConfigManager.isAllowedPid((String)pidObject)) continue;
            String name = pid = (String)pidObject;
            boolean haveOcd = !ocdRequired;
            MetaTypeServiceSupport mtss = this.getMetaTypeSupport();
            if (mtss != null && (ocd = mtss.getObjectClassDefinition(refs[i].getBundle(), pid, locale)) != null) {
                name = ocd.getName();
                haveOcd = true;
            }
            if (!haveOcd) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map pidMap, Map ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException not_expected) {
                // empty catch block
            }
        }
        Iterator ei = ocdCollection.entrySet().iterator();
        while (ei.hasNext()) {
            Map.Entry ociEntry = ei.next();
            String pid = (String)ociEntry.getKey();
            ObjectClassDefinition ocd = (ObjectClassDefinition)ociEntry.getValue();
            if (filter == null) {
                pidMap.put(pid, ocd.getName());
                continue;
            }
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (!filter.match(props)) continue;
            pidMap.put(pid, ocd.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return "[Temporary PID replaced by real PID upon save]";
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary properties) {
        }

        public void delete() {
        }
    }
}

