/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.framework.util.VersionRange;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.core.BaseUpdateInstallHelper;
import org.apache.felix.webconsole.internal.core.BundleContextUtil;
import org.apache.felix.webconsole.internal.core.InstallHelper;
import org.apache.felix.webconsole.internal.core.UpdateHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class BundlesServlet
extends SimpleWebConsolePlugin
implements OsgiManagerPlugin,
ConfigurationPrinter {
    public static final String NAME = "bundles";
    private static final String TITLE = "%bundles.pluginTitle";
    private static final String[] CSS = new String[]{"/res/ui/bundles.css"};
    private static final String FILTER_PARAM = "filter";
    private static final String FIELD_STARTLEVEL = "bundlestartlevel";
    private static final String FIELD_START = "bundlestart";
    private static final String FIELD_BUNDLEFILE = "bundlefile";
    private static final String FIELD_REFRESH_PACKAGES = "refreshPackages";
    private String[] bootPkgs;
    private boolean[] bootPkgWildcards;
    private ServiceRegistration configurationPrinter;
    private ServiceTracker bundleInfoTracker;
    private final String TEMPLATE_MAIN = this.readTemplateFile("/templates/bundles.html");

    public BundlesServlet() {
        super(NAME, TITLE, "OSGi", CSS);
    }

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.bundleInfoTracker = new ServiceTracker(bundleContext, BundleInfoProvider.class.getName(), null);
        this.bundleInfoTracker.open();
        String bootDelegation = bundleContext.getProperty("org.osgi.framework.bootdelegation");
        bootDelegation = bootDelegation == null ? "java.*" : bootDelegation + ",java.*";
        StringTokenizer st = new StringTokenizer(bootDelegation, " ,");
        this.bootPkgs = new String[st.countTokens()];
        this.bootPkgWildcards = new boolean[this.bootPkgs.length];
        for (int i = 0; i < this.bootPkgs.length; ++i) {
            bootDelegation = st.nextToken();
            if (bootDelegation.endsWith("*")) {
                this.bootPkgWildcards[i] = true;
                bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
            }
            this.bootPkgs[i] = bootDelegation;
        }
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        props.put("felix.webconsole.configprinter.modes", new String[]{"txt", "zip"});
        this.configurationPrinter = bundleContext.registerService(ConfigurationPrinter.SERVICE, (Object)this, props);
    }

    public void deactivate() {
        if (this.configurationPrinter != null) {
            this.configurationPrinter.unregister();
            this.configurationPrinter = null;
        }
        if (this.bundleInfoTracker != null) {
            this.bundleInfoTracker.close();
            this.bundleInfoTracker = null;
        }
        super.deactivate();
    }

    public void printConfiguration(PrintWriter pw) {
        try {
            StringWriter w = new StringWriter();
            this.writeJSON(w, null, null, null, true, Locale.ENGLISH, null, null);
            String jsonString = w.toString();
            JSONObject json = new JSONObject(jsonString);
            pw.println("Status: " + json.get("status"));
            pw.println();
            JSONArray data = json.getJSONArray("data");
            for (int i = 0; i < data.length(); ++i) {
                if (data.isNull(i)) continue;
                JSONObject bundle = data.getJSONObject(i);
                pw.println(MessageFormat.format("Bundle {0} - {1} {2} (state: {3})", bundle.get("id"), bundle.get("name"), bundle.get("version"), bundle.get("state")));
                JSONArray props = bundle.getJSONArray("props");
                for (int pi = 0; pi < props.length(); ++pi) {
                    if (props.isNull(pi)) continue;
                    JSONObject entry = props.getJSONObject(pi);
                    String key = (String)entry.get("key");
                    if ("nfo".equals(key)) {
                        JSONObject infos = (JSONObject)entry.get("value");
                        Iterator infoKeys = infos.keys();
                        while (infoKeys.hasNext()) {
                            String infoKey = (String)infoKeys.next();
                            pw.println("    " + infoKey + ": ");
                            JSONArray infoA = infos.getJSONArray(infoKey);
                            for (int iai = 0; iai < infoA.length(); ++iai) {
                                if (infoA.isNull(iai)) continue;
                                JSONObject info = infoA.getJSONObject(iai);
                                pw.println("        " + info.get("name"));
                            }
                        }
                        continue;
                    }
                    pw.print("    " + key + ": ");
                    Object entryValue = entry.get("value");
                    if (entryValue instanceof JSONArray) {
                        pw.println();
                        JSONArray entryArray = (JSONArray)entryValue;
                        for (int ei = 0; ei < entryArray.length(); ++ei) {
                            if (entryArray.isNull(ei)) continue;
                            pw.println("        " + entryArray.get(ei));
                        }
                        continue;
                    }
                    pw.println(entryValue);
                }
                pw.println();
            }
        }
        catch (Exception e) {
            this.log("Problem rendering Bundle details for configuration status", e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if ("upload".equals(reqInfo.pathInfo)) {
            super.doGet(request, response);
            return;
        }
        if (reqInfo.bundle == null && reqInfo.bundleRequested) {
            response.sendError(404);
            return;
        }
        if (reqInfo.extension.equals("json")) {
            String pluginRoot = (String)request.getAttribute("felix.webconsole.pluginRoot");
            String servicesRoot = this.getServicesRoot(request);
            try {
                this.renderJSON(response, reqInfo.bundle, pluginRoot, servicesRoot, request.getLocale(), request.getParameter(FILTER_PARAM), null);
            }
            catch (InvalidSyntaxException e) {
                response.sendError(500, "Invalid LDAP filter specified");
            }
            return;
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean success = false;
        BundleException bundleException = null;
        String action = WebConsoleUtil.getParameter(req, "action");
        if (FIELD_REFRESH_PACKAGES.equals(action)) {
            BaseUpdateInstallHelper.refreshPackages(this.getPackageAdmin(), this.getBundleContext(), 15000L, null);
            success = true;
        } else {
            if ("install".equals(action)) {
                this.installBundles(req);
                if (req.getRequestURI().endsWith("/install")) {
                    resp.setContentLength(0);
                } else {
                    resp.sendRedirect(req.getRequestURI());
                }
                return;
            }
            RequestInfo reqInfo = new RequestInfo(req);
            if (reqInfo.bundle == null && reqInfo.bundleRequested) {
                resp.sendError(404);
                return;
            }
            Bundle bundle = reqInfo.bundle;
            if (bundle != null) {
                if ("start".equals(action)) {
                    try {
                        bundle.start();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot start", be);
                    }
                } else if ("stop".equals(action)) {
                    try {
                        bundle.stop();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot stop", be);
                    }
                } else if ("refresh".equals(action)) {
                    BaseUpdateInstallHelper.refreshPackages(this.getPackageAdmin(), this.getBundleContext(), 5000L, bundle);
                } else if ("update".equals(action)) {
                    this.update(bundle);
                } else if ("uninstall".equals(action)) {
                    try {
                        bundle.uninstall();
                    }
                    catch (BundleException be) {
                        bundleException = be;
                        this.log("Cannot uninstall", be);
                    }
                }
                resp.setContentType("application/json");
                resp.setCharacterEncoding("UTF-8");
                if (null == this.getBundleContext()) {
                    resp.getWriter().print("false");
                } else {
                    resp.getWriter().print("{\"fragment\":" + this.isFragmentBundle(bundle) + ",\"stateRaw\":" + bundle.getState() + "}");
                }
                return;
            }
        }
        if (success && null != this.getBundleContext()) {
            String pluginRoot = (String)req.getAttribute("felix.webconsole.pluginRoot");
            String servicesRoot = this.getServicesRoot(req);
            try {
                this.renderJSON(resp, null, pluginRoot, servicesRoot, req.getLocale(), req.getParameter(FILTER_PARAM), bundleException);
            }
            catch (InvalidSyntaxException e) {
                resp.sendError(500, "Invalid LDAP filter specified");
            }
        } else {
            super.doPost(req, resp);
        }
    }

    private String getServicesRoot(HttpServletRequest request) {
        return (String)request.getAttribute("felix.webconsole.appRoot") + "/" + "services" + "/";
    }

    Bundle getBundle(String pathInfo) {
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        try {
            long bundleId = Long.parseLong(pathInfo);
            if (bundleId >= 0L) {
                return BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundle(bundleId);
            }
        }
        catch (NumberFormatException nfe) {
            String version;
            String symbolicName;
            int pos = pathInfo.indexOf(58);
            if (pos == -1) {
                symbolicName = pathInfo;
                version = null;
            } else {
                symbolicName = pathInfo.substring(0, pos);
                version = pathInfo.substring(pos + 1);
            }
            Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bundle bundle = bundles[i];
                if (!symbolicName.equals(bundle.getSymbolicName()) || version != null && !version.equals(bundle.getHeaders().get("Bundle-Version"))) continue;
                return bundle;
            }
        }
        return null;
    }

    private void appendBundleInfoCount(StringBuffer buf, String msg, int count) {
        buf.append(count);
        buf.append(" bundle");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestInfo reqInfo = BundlesServlet.getRequestInfo(request);
        int startLevel = this.getStartLevel().getInitialBundleStartLevel();
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)request);
        vars.put("startLevel", String.valueOf(startLevel));
        vars.put("drawDetails", reqInfo.bundleRequested ? Boolean.TRUE : Boolean.FALSE);
        vars.put("currentBundle", reqInfo.bundleRequested && reqInfo.bundle != null ? String.valueOf(reqInfo.bundle.getBundleId()) : "null");
        String pluginRoot = (String)request.getAttribute("felix.webconsole.pluginRoot");
        String servicesRoot = this.getServicesRoot(request);
        StringWriter w = new StringWriter();
        try {
            this.writeJSON(w, reqInfo.bundle, pluginRoot, servicesRoot, request.getLocale(), request.getParameter(FILTER_PARAM), null);
        }
        catch (InvalidSyntaxException e) {
            response.sendError(500, "Invalid LDAP filter specified");
            return;
        }
        vars.put("__bundles__", w.toString());
        response.getWriter().print(this.TEMPLATE_MAIN);
    }

    private void renderJSON(HttpServletResponse response, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw, bundle, pluginRoot, servicesRoot, locale, filter, be);
    }

    private void writeJSON(Writer pw, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        this.writeJSON(pw, bundle, pluginRoot, servicesRoot, false, locale, filter, be);
    }

    private void writeJSON(Writer pw, Bundle bundle, String pluginRoot, String servicesRoot, boolean fullDetails, Locale locale, String filter, BundleException be) throws IOException, InvalidSyntaxException {
        Bundle[] bundles;
        Bundle[] allBundles = this.getBundles();
        Object[] status = this.getStatusLine(allBundles);
        String statusLine = (String)status[5];
        if (bundle != null) {
            bundles = new Bundle[]{bundle};
        } else if (filter != null) {
            Filter f = this.getBundleContext().createFilter(filter);
            ArrayList<Bundle> list = new ArrayList<Bundle>(allBundles.length);
            String localeString = locale.toString();
            int size = allBundles.length;
            for (int i = 0; i < size; ++i) {
                if (!f.match(allBundles[i].getHeaders(localeString))) continue;
                list.add(allBundles[i]);
            }
            bundles = new Bundle[list.size()];
            list.toArray(bundles);
        } else {
            bundles = allBundles;
        }
        Util.sort(bundles, locale);
        JSONWriter jw = new JSONWriter(pw);
        try {
            int i;
            jw.object();
            if (null != be) {
                StringWriter s = new StringWriter();
                Throwable t = be.getNestedException() != null ? be.getNestedException() : be;
                t.printStackTrace(new PrintWriter(s));
                jw.key("error");
                jw.value((Object)s.toString());
            }
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("s");
            jw.array();
            for (i = 0; i < 5; ++i) {
                jw.value(status[i]);
            }
            jw.endArray();
            jw.key("data");
            jw.array();
            for (i = 0; i < bundles.length; ++i) {
                this.bundleInfo(jw, bundles[i], fullDetails || bundle != null, pluginRoot, servicesRoot, locale);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    private Object[] getStatusLine(Bundle[] bundles) {
        Object[] ret = new Object[6];
        int active = 0;
        int installed = 0;
        int resolved = 0;
        int fragments = 0;
        block5: for (int i = 0; i < bundles.length; ++i) {
            switch (bundles[i].getState()) {
                case 32: {
                    ++active;
                    continue block5;
                }
                case 2: {
                    ++installed;
                    continue block5;
                }
                case 4: {
                    if (this.isFragmentBundle(bundles[i])) {
                        ++fragments;
                        continue block5;
                    }
                    ++resolved;
                }
            }
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Bundle information: ");
        this.appendBundleInfoCount(buffer, "in total", bundles.length);
        if (active == bundles.length || active + fragments == bundles.length) {
            buffer.append(" - all ");
            this.appendBundleInfoCount(buffer, "active.", bundles.length);
        } else {
            if (active != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active", active);
            }
            if (fragments != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "active fragments", fragments);
            }
            if (resolved != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "resolved", resolved);
            }
            if (installed != 0) {
                buffer.append(", ");
                this.appendBundleInfoCount(buffer, "installed", installed);
            }
            buffer.append('.');
        }
        ret[0] = new Integer(bundles.length);
        ret[1] = new Integer(active);
        ret[2] = new Integer(fragments);
        ret[3] = new Integer(resolved);
        ret[4] = new Integer(installed);
        ret[5] = buffer.toString();
        return ret;
    }

    private void bundleInfo(JSONWriter jw, Bundle bundle, boolean details, String pluginRoot, String servicesRoot, Locale locale) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value(bundle.getBundleId());
        jw.key("name");
        jw.value((Object)Util.getName(bundle, locale));
        jw.key("fragment");
        jw.value(this.isFragmentBundle(bundle));
        jw.key("stateRaw");
        jw.value((long)bundle.getState());
        jw.key("state");
        jw.value((Object)this.toStateString(bundle));
        jw.key("version");
        jw.value((Object)Util.getHeaderValue(bundle, "Bundle-Version"));
        jw.key("symbolicName");
        jw.value((Object)bundle.getSymbolicName());
        jw.key("category");
        jw.value((Object)Util.getHeaderValue(bundle, "Bundle-Category"));
        if (details) {
            this.bundleDetails(jw, bundle, pluginRoot, servicesRoot, locale);
        }
        jw.endObject();
    }

    private final Bundle[] getBundles() {
        return BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
    }

    private String toStateString(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return "Installed";
            }
            case 4: {
                if (this.isFragmentBundle(bundle)) {
                    return "Fragment";
                }
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown: " + bundle.getState();
    }

    private final boolean isFragmentBundle(Bundle bundle) {
        if (bundle.getState() == 1) {
            return bundle.getHeaders().get("Fragment-Host") != null;
        }
        return this.getPackageAdmin().getBundleType(bundle) == 1;
    }

    private final void bundleDetails(JSONWriter jw, Bundle bundle, String pluginRoot, String servicesRoot, Locale locale) throws JSONException {
        Dictionary headers = bundle.getHeaders(locale == null ? null : locale.toString());
        jw.key("props");
        jw.array();
        Util.keyVal(jw, "Symbolic Name", bundle.getSymbolicName());
        Util.keyVal(jw, "Version", headers.get("Bundle-Version"));
        Util.keyVal(jw, "Bundle Location", bundle.getLocation());
        Util.keyVal(jw, "Last Modification", new Date(bundle.getLastModified()));
        String docUrl = (String)headers.get("Bundle-DocURL");
        if (docUrl != null) {
            Util.keyVal(jw, "Bundle Documentation", docUrl);
        }
        Util.keyVal(jw, "Vendor", headers.get("Bundle-Vendor"));
        Util.keyVal(jw, "Copyright", headers.get("Bundle-Copyright"));
        Util.keyVal(jw, "Description", headers.get("Bundle-Description"));
        Util.keyVal(jw, "Start Level", this.getStartLevel(bundle));
        Util.keyVal(jw, "Bundle Classpath", headers.get("Bundle-ClassPath"));
        this.listFragmentInfo(jw, bundle, pluginRoot);
        if (bundle.getState() == 2) {
            this.listImportExportsUnresolved(jw, bundle, pluginRoot);
        } else {
            this.listImportExport(jw, bundle, pluginRoot);
        }
        if (bundle.getState() != 1) {
            this.listServices(jw, bundle, servicesRoot);
        }
        this.listHeaders(jw, bundle);
        String appRoot = pluginRoot == null ? null : pluginRoot.substring(0, pluginRoot.lastIndexOf("/"));
        this.bundleInfoDetails(jw, bundle, appRoot, locale);
        jw.endArray();
    }

    private final void bundleInfoDetails(JSONWriter jw, Bundle bundle, String appRoot, Locale locale) throws JSONException {
        jw.object();
        jw.key("key");
        jw.value((Object)"nfo");
        jw.key("value");
        jw.object();
        Object[] bundleInfoProviders = this.bundleInfoTracker.getServices();
        for (int i = 0; bundleInfoProviders != null && i < bundleInfoProviders.length; ++i) {
            BundleInfoProvider infoProvider = (BundleInfoProvider)bundleInfoProviders[i];
            BundleInfo[] infos = infoProvider.getBundleInfo(bundle, appRoot, locale);
            if (null == infos || infos.length <= 0) continue;
            jw.key(infoProvider.getName(locale));
            jw.array();
            for (int j = 0; j < infos.length; ++j) {
                BundlesServlet.bundleInfo(jw, infos[j]);
            }
            jw.endArray();
        }
        jw.endObject();
        jw.endObject();
    }

    private static final void bundleInfo(JSONWriter jw, BundleInfo info) throws JSONException {
        jw.object();
        jw.key("name");
        jw.value((Object)info.getName());
        jw.key("description");
        jw.value((Object)info.getDescription());
        jw.key("type");
        jw.value((Object)info.getType().getName());
        jw.key("value");
        jw.value(info.getValue());
        jw.endObject();
    }

    private final Integer getStartLevel(Bundle bundle) {
        StartLevel sl;
        if (bundle.getState() != 1 && (sl = this.getStartLevel()) != null) {
            return new Integer(sl.getBundleStartLevel(bundle));
        }
        return null;
    }

    private void listImportExport(JSONWriter jw, Bundle bundle, String pluginRoot) throws JSONException {
        JSONArray val;
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return;
        }
        TreeMap<String, Bundle> usingBundles = new TreeMap<String, Bundle>();
        ExportedPackage[] exports = packageAdmin.getExportedPackages(bundle);
        if (exports != null && exports.length > 0) {
            Arrays.sort(exports, new Comparator(){

                public int compare(ExportedPackage p1, ExportedPackage p2) {
                    return p1.getName().compareTo(p2.getName());
                }

                public int compare(Object o1, Object o2) {
                    return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                }
            });
            val = new JSONArray();
            for (int j = 0; j < exports.length; ++j) {
                ExportedPackage export = exports[j];
                this.collectExport(val, export.getName(), export.getVersion());
                Bundle[] ubList = export.getImportingBundles();
                if (ubList == null) continue;
                for (int i = 0; i < ubList.length; ++i) {
                    Bundle ub = ubList[i];
                    String name = ub.getSymbolicName();
                    if (name == null) {
                        name = ub.getLocation();
                    }
                    usingBundles.put(name, ub);
                }
            }
            Util.keyVal(jw, "Exported Packages", val);
        } else {
            Util.keyVal(jw, "Exported Packages", "---");
        }
        exports = packageAdmin.getExportedPackages((Bundle)null);
        if (exports != null && exports.length > 0) {
            ArrayList<ExportedPackage> imports = new ArrayList<ExportedPackage>();
            block2: for (int i = 0; i < exports.length; ++i) {
                ExportedPackage ep = exports[i];
                Bundle[] importers = ep.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    if (importers[j].getBundleId() != bundle.getBundleId()) continue;
                    imports.add(ep);
                    continue block2;
                }
            }
            JSONArray val2 = new JSONArray();
            if (imports.size() > 0) {
                ExportedPackage[] packages = imports.toArray(new ExportedPackage[imports.size()]);
                Arrays.sort(packages, new Comparator(){

                    public int compare(ExportedPackage p1, ExportedPackage p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                    }
                });
                for (int i = 0; i < packages.length; ++i) {
                    ExportedPackage ep = packages[i];
                    this.collectImport(val2, ep.getName(), ep.getVersion(), false, ep, pluginRoot);
                }
            } else {
                val2.put((Object)"None");
            }
            Util.keyVal(jw, "Imported Packages", val2);
        }
        if (!usingBundles.isEmpty()) {
            val = new JSONArray();
            Iterator ui = usingBundles.values().iterator();
            while (ui.hasNext()) {
                Bundle usingBundle = (Bundle)ui.next();
                val.put((Object)this.getBundleDescriptor(usingBundle, pluginRoot));
            }
            Util.keyVal(jw, "Importing Bundles", val);
        }
    }

    private void listImportExportsUnresolved(JSONWriter jw, Bundle bundle, String pluginRoot) throws JSONException {
        int i;
        Clause[] pkgs;
        Dictionary dict = bundle.getHeaders();
        String target = (String)dict.get("Export-Package");
        if (target != null) {
            pkgs = Parser.parseHeader(target);
            if (pkgs != null && pkgs.length > 0) {
                Arrays.sort(pkgs, new Comparator(){

                    public int compare(Clause p1, Clause p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((Clause)o1, (Clause)o2);
                    }
                });
                JSONArray val = new JSONArray();
                for (i = 0; i < pkgs.length; ++i) {
                    Clause export = new Clause(pkgs[i].getName(), pkgs[i].getDirectives(), pkgs[i].getAttributes());
                    this.collectExport(val, export.getName(), export.getAttribute("version"));
                }
                Util.keyVal(jw, "Exported Packages", val);
            } else {
                Util.keyVal(jw, "Exported Packages", "---");
            }
        }
        if ((target = (String)dict.get("Import-Package")) != null && (pkgs = Parser.parseHeader(target)) != null && pkgs.length > 0) {
            ExportedPackage[] exports;
            TreeMap<String, Clause> imports = new TreeMap<String, Clause>();
            for (i = 0; i < pkgs.length; ++i) {
                Clause pkg = pkgs[i];
                imports.put(pkg.getName(), new Clause(pkg.getName(), pkg.getDirectives(), pkg.getAttributes()));
            }
            HashMap<String, ExportedPackage> candidates = new HashMap<String, ExportedPackage>();
            PackageAdmin packageAdmin = this.getPackageAdmin();
            if (packageAdmin != null && (exports = packageAdmin.getExportedPackages((Bundle)null)) != null && exports.length > 0) {
                for (int i2 = 0; i2 < exports.length; ++i2) {
                    ExportedPackage ep = exports[i2];
                    Clause imp = (Clause)imports.get(ep.getName());
                    if (imp == null || !this.isSatisfied(imp, ep)) continue;
                    candidates.put(ep.getName(), ep);
                }
            }
            JSONArray val = new JSONArray();
            if (imports.size() > 0) {
                Iterator ii = imports.values().iterator();
                while (ii.hasNext()) {
                    String path;
                    Clause r4Import = (Clause)ii.next();
                    ExportedPackage ep = (ExportedPackage)candidates.get(r4Import.getName());
                    if (ep == null && bundle.getEntry(path = r4Import.getName().replace('.', '/')) != null) continue;
                    this.collectImport(val, r4Import.getName(), r4Import.getAttribute("version"), "optional".equals(r4Import.getDirective("resolution")), ep, pluginRoot);
                }
            } else {
                val.put((Object)"---");
            }
            Util.keyVal(jw, "Imported Packages", val);
        }
    }

    private String getServiceID(ServiceReference ref, String servicesRoot) {
        String id = ref.getProperty("service.id").toString();
        StringBuffer val = new StringBuffer();
        if (servicesRoot != null) {
            val.append("<a href='").append(servicesRoot).append(id).append("'>");
            val.append(id);
            val.append("</a>");
            return val.toString();
        }
        return id;
    }

    private void listServices(JSONWriter jw, Bundle bundle, String servicesRoot) throws JSONException {
        ServiceReference[] refs = bundle.getRegisteredServices();
        if (refs == null || refs.length == 0) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            String key = "Service ID " + this.getServiceID(refs[i], servicesRoot);
            JSONArray val = new JSONArray();
            this.appendProperty(val, refs[i], "objectClass", "Types");
            this.appendProperty(val, refs[i], "service.pid", "Service PID");
            this.appendProperty(val, refs[i], "org.apache.felix.karaf.features.configKey", "Feature PID");
            this.appendProperty(val, refs[i], "service.factoryPid", "Factory PID");
            this.appendProperty(val, refs[i], "component.name", "Component Name");
            this.appendProperty(val, refs[i], "component.id", "Component ID");
            this.appendProperty(val, refs[i], "component.factory", "Component Factory");
            this.appendProperty(val, refs[i], "service.description", "Description");
            this.appendProperty(val, refs[i], "service.vendor", "Vendor");
            Util.keyVal(jw, key, val);
        }
    }

    private void listHeaders(JSONWriter jw, Bundle bundle) throws JSONException {
        JSONArray val = new JSONArray();
        Dictionary headers = bundle.getHeaders("");
        Enumeration he = headers.keys();
        while (he.hasMoreElements()) {
            Object header = he.nextElement();
            String value = String.valueOf(headers.get(header));
            value = BundlesServlet.enableLineWrapping(value);
            val.put((Object)(header + ": " + value));
        }
        Util.keyVal(jw, "Manifest Headers", val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String enableLineWrapping(String value) {
        StringBuffer sb;
        StringBuffer stringBuffer = sb = new StringBuffer(value.length() * 2 / 3);
        synchronized (stringBuffer) {
            for (int i = 0; i < value.length(); ++i) {
                char ch = value.charAt(i);
                sb.append(ch);
                if (ch != ';' && ch != ',') continue;
                sb.append(' ');
            }
            return sb.toString();
        }
    }

    private void listFragmentInfo(JSONWriter jw, Bundle bundle, String pluginRoot) throws JSONException {
        if (this.isFragmentBundle(bundle)) {
            Bundle[] hostBundles = this.getPackageAdmin().getHosts(bundle);
            if (hostBundles != null) {
                JSONArray val = new JSONArray();
                for (int i = 0; i < hostBundles.length; ++i) {
                    val.put((Object)this.getBundleDescriptor(hostBundles[i], pluginRoot));
                }
                Util.keyVal(jw, "Host Bundles", val);
            }
        } else {
            Bundle[] fragmentBundles = this.getPackageAdmin().getFragments(bundle);
            if (fragmentBundles != null) {
                JSONArray val = new JSONArray();
                for (int i = 0; i < fragmentBundles.length; ++i) {
                    val.put((Object)this.getBundleDescriptor(fragmentBundles[i], pluginRoot));
                }
                Util.keyVal(jw, "Fragments Attached", val);
            }
        }
    }

    private void appendProperty(JSONArray array, ServiceReference ref, String name, String label) {
        StringBuffer dest = new StringBuffer();
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            dest.append(label).append(": ");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            array.put((Object)dest.toString());
        } else if (value != null) {
            dest.append(label).append(": ").append(value);
            array.put((Object)dest.toString());
        }
    }

    private void collectExport(JSONArray array, String name, Version version) {
        this.collectExport(array, name, version == null ? null : version.toString());
    }

    private void collectExport(JSONArray array, String name, String version) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel) {
            val.append("!! ");
        }
        val.append(name);
        if (version != null) {
            val.append(",version=").append(version);
        }
        if (bootDel) {
            val.append(" -- Overwritten by Boot Delegation");
        }
        array.put((Object)val.toString());
    }

    private void collectImport(JSONArray array, String name, Version version, boolean optional, ExportedPackage export, String pluginRoot) {
        this.collectImport(array, name, version == null ? null : version.toString(), optional, export, pluginRoot);
    }

    private void collectImport(JSONArray array, String name, String version, boolean optional, ExportedPackage export, String pluginRoot) {
        StringBuffer val = new StringBuffer();
        boolean bootDel = this.isBootDelegated(name);
        String marker = null;
        val.append(name);
        if (version != null) {
            val.append(",version=").append(version);
        }
        if (export != null) {
            val.append(" from ");
            val.append(this.getBundleDescriptor(export.getExportingBundle(), pluginRoot));
            if (bootDel) {
                val.append(" -- Overwritten by Boot Delegation");
                marker = "INFO";
            }
        } else {
            val.append(" -- Cannot be resolved");
            marker = "ERROR";
            if (optional) {
                val.append(" but is not required");
            }
            if (bootDel) {
                val.append(" and overwritten by Boot Delegation");
            }
        }
        if (marker != null) {
            val.insert(0, ": ");
            val.insert(0, marker);
        }
        array.put((Object)val);
    }

    private boolean isBootDelegated(String pkgName) {
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.bootPkgs.length; ++i) {
                if ((!this.bootPkgWildcards[i] || !pkgName.startsWith(this.bootPkgs[i]) && !this.bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.bootPkgWildcards[i] || !this.bootPkgs[i].equals(pkgName))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSatisfied(Clause imported, ExportedPackage exported) {
        if (imported.getName().equals(exported.getName())) {
            String versionAttr = imported.getAttribute("version");
            if (versionAttr == null) {
                return true;
            }
            VersionRange required = VersionRange.parse(versionAttr);
            return required.isInRange(exported.getVersion());
        }
        return false;
    }

    private String getBundleDescriptor(Bundle bundle, String pluginRoot) {
        StringBuffer val = new StringBuffer();
        if (pluginRoot != null) {
            val.append("<a href='").append(pluginRoot).append('/').append(bundle.getBundleId()).append("'>");
        }
        if (bundle.getSymbolicName() != null) {
            val.append(bundle.getSymbolicName());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else if (bundle.getLocation() != null) {
            val.append(bundle.getLocation());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else {
            val.append(bundle.getBundleId());
        }
        if (pluginRoot != null) {
            val.append("</a>");
        }
        return val.toString();
    }

    private void update(Bundle bundle) {
        UpdateHelper t = new UpdateHelper(this, bundle, false);
        t.start();
    }

    static final RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute(BundlesServlet.class.getName());
    }

    private final PackageAdmin getPackageAdmin() {
        return (PackageAdmin)this.getService(PackageAdmin.class.getName());
    }

    private final StartLevel getStartLevel() {
        return (StartLevel)this.getService(StartLevel.class.getName());
    }

    private void installBundles(HttpServletRequest request) throws IOException {
        Map params = (Map)request.getAttribute("org.apache.felix.webconsole.fileupload");
        if (params == null) {
            return;
        }
        FileItem startItem = this.getParameter(params, FIELD_START);
        FileItem startLevelItem = this.getParameter(params, FIELD_STARTLEVEL);
        FileItem[] bundleItems = this.getFileItems(params, FIELD_BUNDLEFILE);
        FileItem refreshPackagesItem = this.getParameter(params, FIELD_REFRESH_PACKAGES);
        if (bundleItems.length == 0) {
            return;
        }
        int startLevel = -1;
        String bundleLocation = "inputstream:";
        if (startLevelItem != null) {
            try {
                startLevel = Integer.parseInt(startLevelItem.getString());
            }
            catch (NumberFormatException nfe) {
                this.log(3, "Cannot parse start level parameter " + startLevelItem + " to a number, not setting start level");
            }
        }
        for (int i = 0; i < bundleItems.length; ++i) {
            File tmpFile;
            FileItem bundleItem;
            block8: {
                bundleItem = bundleItems[i];
                tmpFile = null;
                try {
                    tmpFile = File.createTempFile("install", ".tmp");
                    bundleItem.write(tmpFile);
                }
                catch (Exception e) {
                    this.log(1, "Problem accessing uploaded bundle file: " + bundleItem.getName(), e);
                    if (tmpFile == null) break block8;
                    tmpFile.delete();
                    tmpFile = null;
                }
            }
            if (tmpFile == null) continue;
            boolean start = startItem != null;
            boolean refreshPackages = refreshPackagesItem != null;
            bundleLocation = "inputstream:" + bundleItem.getName();
            this.installBundle(bundleLocation, tmpFile, startLevel, start, refreshPackages);
        }
    }

    private FileItem getParameter(Map params, String name) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].isFormField()) continue;
                return items[i];
            }
        }
        return null;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    private void installBundle(String location, File bundleFile, int startLevel, boolean start, boolean refreshPackages) throws IOException {
        if (bundleFile != null) {
            String symbolicName = this.getSymbolicName(bundleFile);
            if (symbolicName == null) {
                bundleFile.delete();
                throw new IOException("Bundle-SymbolicName header missing, cannot install bundle");
            }
            Bundle updateBundle = null;
            if ("system.bundle".equals(symbolicName)) {
                updateBundle = this.getBundleContext().getBundle(0L);
            } else {
                Bundle[] bundles = BundleContextUtil.getWorkingBundleContext(this.getBundleContext()).getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if ((bundles[i].getLocation() == null || !bundles[i].getLocation().equals(location)) && (bundles[i].getSymbolicName() == null || !bundles[i].getSymbolicName().equals(symbolicName))) continue;
                    updateBundle = bundles[i];
                    break;
                }
            }
            if (updateBundle != null) {
                this.updateBackground(updateBundle, bundleFile, refreshPackages);
            } else {
                this.installBackground(bundleFile, location, startLevel, start, refreshPackages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSymbolicName(File bundleFile) {
        JarFile jar = null;
        try {
            jar = new JarFile(bundleFile);
            Manifest m = jar.getManifest();
            if (m != null) {
                int paramPos;
                String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
                if (sn != null && (paramPos = sn.indexOf(59)) != -1) {
                    sn = sn.substring(0, paramPos);
                }
                String string = sn;
                return string;
            }
        }
        catch (IOException ioe) {
            this.log(2, "Cannot extract symbolic name of bundle file " + bundleFile, ioe);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private void installBackground(File bundleFile, String location, int startlevel, boolean doStart, boolean refreshPackages) {
        InstallHelper t = new InstallHelper(this, this.getBundleContext(), bundleFile, location, startlevel, doStart, refreshPackages);
        t.start();
    }

    private void updateBackground(Bundle bundle, File bundleFile, boolean refreshPackages) {
        UpdateHelper t = new UpdateHelper((SimpleWebConsolePlugin)this, bundle, bundleFile, refreshPackages);
        t.start();
    }

    private final class RequestInfo {
        public final String extension;
        public final Bundle bundle;
        public final boolean bundleRequested;
        public final String pathInfo;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(BundlesServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            String bundleInfo = null;
            if (info.startsWith("/")) {
                bundleInfo = info.substring(1);
            }
            if (bundleInfo == null || bundleInfo.length() == 0) {
                this.bundle = null;
                this.bundleRequested = false;
                this.pathInfo = null;
            } else {
                this.bundle = BundlesServlet.this.getBundle(bundleInfo);
                this.bundleRequested = true;
                this.pathInfo = bundleInfo;
            }
            request.setAttribute((class$org$apache$felix$webconsole$internal$core$BundlesServlet == null ? (class$org$apache$felix$webconsole$internal$core$BundlesServlet = BundlesServlet.class$("org.apache.felix.webconsole.internal.core.BundlesServlet")) : class$org$apache$felix$webconsole$internal$core$BundlesServlet).getName(), (Object)this);
        }
    }
}

