/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.packageadmin.PackageAdmin;

abstract class BaseUpdateInstallHelper
implements Runnable {
    private final SimpleWebConsolePlugin plugin;
    private final File bundleFile;
    private final boolean refreshPackages;
    private Thread updateThread;

    BaseUpdateInstallHelper(SimpleWebConsolePlugin plugin, String name, File bundleFile, boolean refreshPackages) {
        this.plugin = plugin;
        this.bundleFile = bundleFile;
        this.refreshPackages = refreshPackages;
        this.updateThread = new Thread((Runnable)this, name);
        this.updateThread.setDaemon(true);
    }

    protected File getBundleFile() {
        return this.bundleFile;
    }

    protected abstract Bundle doRun(InputStream var1) throws BundleException;

    protected final Object getService(String serviceName) {
        return this.plugin.getService(serviceName);
    }

    protected final SimpleWebConsolePlugin getLog() {
        return this.plugin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle doRun() throws Exception {
        Bundle bundle;
        FileInputStream bundleStream = null;
        try {
            bundleStream = new FileInputStream(this.bundleFile);
            bundle = this.doRun(bundleStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bundleStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bundleStream);
        return bundle;
    }

    final void start() {
        if (this.updateThread != null) {
            this.updateThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            PackageAdmin pa = this.refreshPackages ? (PackageAdmin)this.getService(PackageAdmin.class.getName()) : null;
            Bundle bundle = this.doRun();
            if (pa != null && bundle != null) {
                BaseUpdateInstallHelper.refreshPackages(pa, this.plugin.getBundle().getBundleContext(), 5000L, bundle);
            }
        }
        catch (Exception e) {
            try {
                this.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, e);
            }
            catch (Exception secondary) {
                System.err.println("Cannot install or update bundle from " + this.bundleFile);
                e.printStackTrace(System.err);
            }
        }
        finally {
            if (this.bundleFile != null) {
                this.bundleFile.delete();
            }
            this.updateThread = null;
        }
    }

    static boolean refreshPackages(PackageAdmin packageAdmin, BundleContext bundleContext, long maxWait, Bundle bundle) {
        return new RefreshPackageTask().refreshPackages(packageAdmin, bundleContext, maxWait, bundle);
    }

    static class RefreshPackageTask
    implements FrameworkListener {
        private volatile boolean refreshed = false;
        private final Object lock = new Object();

        RefreshPackageTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        boolean refreshPackages(PackageAdmin packageAdmin, BundleContext bundleContext, long maxWait, Bundle bundle) {
            if (null == packageAdmin) {
                return false;
            }
            if (null == bundleContext) {
                return false;
            }
            bundleContext.addFrameworkListener((FrameworkListener)this);
            if (null == bundle) {
                packageAdmin.refreshPackages(null);
            } else {
                packageAdmin.refreshPackages(new Bundle[]{bundle});
            }
            try {
                long start = System.currentTimeMillis();
                long delay = maxWait;
                while (!this.refreshed) {
                    if (delay <= 0L) return this.refreshed;
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.refreshed) {
                            this.lock.wait(delay);
                            delay = maxWait - (System.currentTimeMillis() - start);
                        }
                    }
                }
                return this.refreshed;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return this.refreshed;
            }
            finally {
                bundleContext.removeFrameworkListener((FrameworkListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void frameworkEvent(FrameworkEvent e) {
            if (e.getType() == 4) {
                Object object = this.lock;
                synchronized (object) {
                    this.refreshed = true;
                    this.lock.notifyAll();
                }
            }
        }
    }
}

