/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.configuration;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.apache.felix.webconsole.internal.configuration.PropertyDescriptor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

class MetaTypeSupport {
    static final int ATTRIBUTE_TYPE_PASSWORD = 12;
    static final String PASSWORD_PLACEHOLDER_VALUE = "unmodified";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;

    MetaTypeSupport() {
    }

    static Bundle getBundle(BundleContext bundleContext, String bundleLocation) {
        if (bundleLocation == null) {
            return null;
        }
        Bundle[] bundles = bundleContext.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if (!bundleLocation.equals(bundles[i].getLocation())) continue;
            return bundles[i];
        }
        return null;
    }

    static void attributeToJson(JSONWriter json, PropertyDescriptor ad, Object propValue) throws JSONException {
        boolean isPassword;
        json.object();
        Object value = propValue != null ? propValue : (ad.getDefaultValue() != null ? ad.getDefaultValue() : (ad.getCardinality() == 0 ? "" : new String[]{}));
        json.key("name");
        json.value((Object)ad.getName());
        int propertyType = MetaTypeSupport.getAttributeType(ad);
        json.key("type");
        if (ad.getOptionLabels() != null && ad.getOptionLabels().length > 0) {
            json.object();
            json.key("labels");
            json.value(Arrays.asList(ad.getOptionLabels()));
            json.key("values");
            json.value(Arrays.asList(ad.getOptionValues()));
            json.endObject();
        } else {
            json.value((long)propertyType);
        }
        boolean bl = isPassword = propertyType == 12;
        if (ad.getCardinality() == 0) {
            if (isPassword) {
                value = PASSWORD_PLACEHOLDER_VALUE;
            } else if (value instanceof Vector) {
                value = ((Vector)value).get(0);
            } else if (value.getClass().isArray()) {
                value = Array.get(value, 0);
            }
            json.key("value");
            json.value(value);
        } else {
            value = new JSONArray((Collection)MetaTypeSupport.toList(value));
            if (isPassword) {
                JSONArray tmp = value;
                for (int tmpI = 0; tmpI < tmp.length(); ++tmpI) {
                    tmp.put(tmpI, (Object)PASSWORD_PLACEHOLDER_VALUE);
                }
            }
            json.key("values");
            json.value(value);
        }
        if (ad.getDescription() != null) {
            json.key("description");
            json.value((Object)(ad.getDescription() + " (" + ad.getID() + ")"));
        }
        json.endObject();
    }

    private static boolean isPasswordProperty(String name) {
        return name == null ? false : name.toLowerCase().indexOf("password") != -1;
    }

    private static List toList(Object value) {
        if (value instanceof Vector) {
            return (Vector)value;
        }
        if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                int len = Array.getLength(value);
                Object[] tmp = new Object[len];
                for (int j = 0; j < len; ++j) {
                    tmp[j] = Array.get(value, j);
                }
                value = tmp;
            }
            return Arrays.asList((Object[])value);
        }
        return Collections.singletonList(value);
    }

    static PropertyDescriptor createAttributeDefinition(String id, Object value) {
        Class type;
        int attrCardinality;
        if (value == null) {
            attrCardinality = 0;
            type = class$java$lang$String == null ? (class$java$lang$String = MetaTypeSupport.class$("java.lang.String")) : class$java$lang$String;
        } else if (value instanceof Collection) {
            attrCardinality = Integer.MIN_VALUE;
            Collection coll = (Collection)value;
            type = coll.isEmpty() ? (class$java$lang$String == null ? (class$java$lang$String = MetaTypeSupport.class$("java.lang.String")) : class$java$lang$String) : coll.iterator().next().getClass();
        } else if (value.getClass().isArray()) {
            attrCardinality = Integer.MAX_VALUE;
            type = value.getClass().getComponentType();
        } else {
            attrCardinality = 0;
            type = value.getClass();
        }
        int attrType = type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MetaTypeSupport.class$("java.lang.Boolean")) : class$java$lang$Boolean) || type == Boolean.TYPE ? 11 : (type == (class$java$lang$Byte == null ? (class$java$lang$Byte = MetaTypeSupport.class$("java.lang.Byte")) : class$java$lang$Byte) || type == Byte.TYPE ? 6 : (type == (class$java$lang$Character == null ? (class$java$lang$Character = MetaTypeSupport.class$("java.lang.Character")) : class$java$lang$Character) || type == Character.TYPE ? 5 : (type == (class$java$lang$Double == null ? (class$java$lang$Double = MetaTypeSupport.class$("java.lang.Double")) : class$java$lang$Double) || type == Double.TYPE ? 7 : (type == (class$java$lang$Float == null ? (class$java$lang$Float = MetaTypeSupport.class$("java.lang.Float")) : class$java$lang$Float) || type == Float.TYPE ? 8 : (type == (class$java$lang$Long == null ? (class$java$lang$Long = MetaTypeSupport.class$("java.lang.Long")) : class$java$lang$Long) || type == Long.TYPE ? 2 : (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = MetaTypeSupport.class$("java.lang.Integer")) : class$java$lang$Integer) || type == Integer.TYPE ? 3 : (type == (class$java$lang$Short == null ? (class$java$lang$Short = MetaTypeSupport.class$("java.lang.Short")) : class$java$lang$Short) || type == Short.TYPE ? 4 : 1)))))));
        return new PropertyDescriptor(id, attrType, attrCardinality);
    }

    static int getAttributeType(PropertyDescriptor ad) {
        if (ad.getType() == 1 && MetaTypeSupport.isPasswordProperty(ad.getID())) {
            return 12;
        }
        return ad.getType();
    }

    static final Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return new Character(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    static void setPasswordProps(Vector vec, String[] properties, Object props) {
        List propList = props == null ? new ArrayList() : MetaTypeSupport.toList(props);
        for (int i = 0; i < properties.length; ++i) {
            if (PASSWORD_PLACEHOLDER_VALUE.equals(properties[i])) {
                if (i >= propList.size() || propList.get(i) == null) continue;
                vec.add(propList.get(i));
                continue;
            }
            vec.add(properties[i]);
        }
    }

    static final Object toArray(int type, Vector values) {
        Object[] array;
        int size = values.size();
        if (type == 1 || type == 12) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
                break;
            }
            case 6: {
                array = new byte[size];
                break;
            }
            case 5: {
                array = new char[size];
                break;
            }
            case 7: {
                array = new double[size];
                break;
            }
            case 8: {
                array = new float[size];
                break;
            }
            case 2: {
                array = new long[size];
                break;
            }
            case 3: {
                array = new int[size];
                break;
            }
            case 4: {
                array = new short[size];
                break;
            }
            default: {
                array = new String[size];
            }
        }
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

