/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.osgi.framework.ServiceReference;

public class WebConsolePluginAdapter
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final String title;
    private final Servlet plugin;
    private final String[] cssReferences;

    public WebConsolePluginAdapter(String label, String title, Servlet plugin, ServiceReference serviceReference) {
        this.label = label;
        this.title = title;
        this.plugin = plugin;
        this.cssReferences = this.toStringArray(serviceReference.getProperty("felix.webconsole.css"));
        this.activate(serviceReference.getBundle().getBundleContext());
    }

    public String getLabel() {
        return this.label;
    }

    public String getTitle() {
        return this.title;
    }

    protected String[] getCssReferences() {
        return this.cssReferences;
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.plugin.service((ServletRequest)req, (ServletResponse)res);
    }

    protected Object getResourceProvider() {
        return this.plugin;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            this.plugin.init(config);
        }
        catch (ServletException se) {
            this.deactivate();
            throw se;
        }
    }

    protected boolean isHtmlRequest(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return requestUri.endsWith(".html") || requestUri.lastIndexOf(46) < 0;
    }

    public void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        if (req instanceof HttpServletRequest && ((HttpServletRequest)req).getMethod().equals("GET")) {
            super.service(req, resp);
        } else {
            this.plugin.service(req, resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.plugin.destroy();
            super.destroy();
        }
        finally {
            this.deactivate();
        }
    }

    private String[] toStringArray(Object value) {
        Collection<Object> cssListColl;
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value != null && (cssListColl = value.getClass().isArray() ? Arrays.asList((Object[])value) : (value instanceof Collection ? (Collection)value : null)) != null && !cssListColl.isEmpty()) {
            String[] entries = new String[cssListColl.size()];
            int i = 0;
            Iterator<Object> cli = cssListColl.iterator();
            while (cli.hasNext()) {
                entries[i] = String.valueOf(cli.next());
                ++i;
            }
            return entries;
        }
        return null;
    }
}

