/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.felix.webconsole.internal.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

abstract class BaseUpdateInstallHelper
extends Thread {
    private final File bundleFile;
    private final boolean refreshPackages;
    static /* synthetic */ Class class$org$osgi$service$packageadmin$PackageAdmin;

    BaseUpdateInstallHelper(String name, File bundleFile, boolean refreshPackages) {
        super(name);
        this.setDaemon(true);
        this.bundleFile = bundleFile;
        this.refreshPackages = refreshPackages;
    }

    protected File getBundleFile() {
        return this.bundleFile;
    }

    protected abstract Bundle doRun(InputStream var1) throws BundleException;

    protected abstract Logger getLog();

    protected abstract Object getService(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bundle doRun() throws BundleException, IOException {
        FileInputStream bundleStream = null;
        try {
            bundleStream = new FileInputStream(this.bundleFile);
            Bundle bundle = this.doRun(bundleStream);
            return bundle;
        }
        finally {
            if (bundleStream != null) {
                try {
                    ((InputStream)bundleStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.sleepSilently(500L);
        try {
            PackageAdmin pa = this.refreshPackages ? (PackageAdmin)this.getService((class$org$osgi$service$packageadmin$PackageAdmin == null ? (class$org$osgi$service$packageadmin$PackageAdmin = BaseUpdateInstallHelper.class$("org.osgi.service.packageadmin.PackageAdmin")) : class$org$osgi$service$packageadmin$PackageAdmin).getName()) : null;
            Bundle bundle = this.doRun();
            if (pa != null && bundle != null) {
                this.sleepSilently(2000L);
                pa.refreshPackages(new Bundle[]{bundle});
            }
        }
        catch (IOException ioe) {
            this.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, ioe);
        }
        catch (BundleException be) {
            this.getLog().log(1, "Cannot install or update bundle from " + this.bundleFile, be);
        }
        finally {
            if (this.bundleFile != null) {
                this.bundleFile.delete();
            }
        }
    }

    protected void sleepSilently(long msecs) {
        try {
            BaseUpdateInstallHelper.sleep(msecs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

