/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServicesServlet
extends BaseWebConsolePlugin
implements ConfigurationPrinter {
    private ServiceRegistration configurationPrinter;
    public static final String LABEL = "services";
    public static final String TITLE = "Services";
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$core$ServicesServlet;

    public static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute((class$org$apache$felix$webconsole$internal$core$ServicesServlet == null ? (class$org$apache$felix$webconsole$internal$core$ServicesServlet = ServicesServlet.class$("org.apache.felix.webconsole.internal.core.ServicesServlet")) : class$org$apache$felix$webconsole$internal$core$ServicesServlet).getName());
    }

    public void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
        this.configurationPrinter = bundleContext.registerService(ConfigurationPrinter.SERVICE, (Object)this, null);
    }

    public void deactivate() {
        if (this.configurationPrinter != null) {
            this.configurationPrinter.unregister();
            this.configurationPrinter = null;
        }
        super.deactivate();
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    public void printConfiguration(PrintWriter pw) {
        try {
            StringWriter w = new StringWriter();
            this.writeJSON(w, null, true);
            String jsonString = w.toString();
            JSONObject json = new JSONObject(jsonString);
            pw.println("Status: " + json.get("status"));
            pw.println();
            JSONArray data = json.getJSONArray("data");
            for (int i = 0; i < data.length(); ++i) {
                if (data.isNull(i)) continue;
                JSONObject service = data.getJSONObject(i);
                pw.println(MessageFormat.format("Service {0} - {1} (pid: {2})", service.get("id"), service.get("types"), service.get("pid")));
                pw.println(MessageFormat.format("  from Bundle {0} - {1} ({2}), version {3}", service.get("bundleId"), service.get("bundleName"), service.get("bundleSymbolicName"), service.get("bundleVersion")));
                JSONArray props = service.getJSONArray("props");
                for (int pi = 0; pi < props.length(); ++pi) {
                    if (props.isNull(pi)) continue;
                    JSONObject entry = props.getJSONObject(pi);
                    pw.print("    " + entry.get("key") + ": ");
                    Object entryValue = entry.get("value");
                    if (entryValue instanceof JSONArray) {
                        pw.println();
                        JSONArray entryArray = (JSONArray)entryValue;
                        for (int ei = 0; ei < entryArray.length(); ++ei) {
                            if (entryArray.isNull(ei)) continue;
                            pw.println("        " + entryArray.get(ei));
                        }
                        continue;
                    }
                    pw.println(entryValue);
                }
                JSONArray usingBundles = service.getJSONArray("usingBundles");
                for (int ui = 0; ui < usingBundles.length(); ++ui) {
                    if (usingBundles.isNull(ui)) continue;
                    JSONObject bundle = usingBundles.getJSONObject(ui);
                    pw.println(MessageFormat.format("  Using Bundle {0} - {1} ({2}), version {3}", bundle.get("bundleId"), bundle.get("bundleName"), bundle.get("bundleSymbolicName"), bundle.get("bundleVersion")));
                }
                pw.println();
            }
        }
        catch (Exception e) {
            this.getLog().log(1, "Problem rendering Bundle details for configuration status", e);
        }
    }

    private void appendServiceInfoCount(StringBuffer buf, String msg, int count) {
        buf.append(count);
        buf.append(" service");
        if (count != 1) {
            buf.append('s');
        }
        buf.append(' ');
        buf.append(msg);
    }

    private ServiceReference getServiceById(String pathInfo) {
        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
        StringBuffer filter = new StringBuffer();
        filter.append("(").append("service.id").append("=");
        filter.append(pathInfo).append(")");
        String filterStr = filter.toString();
        try {
            ServiceReference[] refs = this.getBundleContext().getServiceReferences(null, filterStr);
            if (refs == null || refs.length != 1) {
                return null;
            }
            return refs[0];
        }
        catch (InvalidSyntaxException e) {
            this.getLog().log(2, "Unable to search for services using filter " + filterStr, e);
            return null;
        }
    }

    private ServiceReference[] getServices() {
        try {
            return this.getBundleContext().getServiceReferences(null, null);
        }
        catch (InvalidSyntaxException e) {
            this.getLog().log(2, "Unable to access service reference list.", e);
            return new ServiceReference[0];
        }
    }

    private String getStatusLine(ServiceReference[] services) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Services information: ");
        this.appendServiceInfoCount(buffer, "in total", services.length);
        return buffer.toString();
    }

    private void keyVal(JSONWriter jw, String key, Object value) throws JSONException {
        if (key != null && value != null) {
            jw.object();
            jw.key("key");
            jw.value((Object)key);
            jw.key("value");
            jw.value(value);
            jw.endObject();
        }
    }

    private String propertyAsString(ServiceReference ref, String name) {
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            StringBuffer dest = new StringBuffer();
            Object[] values = (Object[])value;
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            return dest.toString();
        }
        if (value != null) {
            return value.toString();
        }
        return "n/a";
    }

    private void renderJSON(HttpServletResponse response, ServiceReference service) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter pw = response.getWriter();
        this.writeJSON(pw, service);
    }

    private void serviceDetails(JSONWriter jw, ServiceReference service) throws JSONException {
        String[] keys = service.getPropertyKeys();
        jw.key("props");
        jw.array();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if ("service.pid".equals(key)) {
                this.keyVal(jw, "Service PID", service.getProperty(key));
                continue;
            }
            if ("service.description".equals(key)) {
                this.keyVal(jw, "Service Description", service.getProperty(key));
                continue;
            }
            if ("service.vendor".equals(key)) {
                this.keyVal(jw, "Service Vendor", service.getProperty(key));
                continue;
            }
            if ("objectClass".equals(key) || "service.id".equals(key)) continue;
            this.keyVal(jw, key, service.getProperty(key));
        }
        jw.endArray();
    }

    private void usingBundles(JSONWriter jw, ServiceReference service) throws JSONException {
        jw.key("usingBundles");
        jw.array();
        Bundle[] usingBundles = service.getUsingBundles();
        if (usingBundles != null) {
            for (int i = 0; i < usingBundles.length; ++i) {
                jw.object();
                this.bundleInfo(jw, usingBundles[i]);
                jw.endObject();
            }
        }
        jw.endArray();
    }

    private void serviceInfo(JSONWriter jw, ServiceReference service, boolean details) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value((Object)this.propertyAsString(service, "service.id"));
        jw.key("types");
        jw.value((Object)this.propertyAsString(service, "objectClass"));
        jw.key("pid");
        jw.value((Object)this.propertyAsString(service, "service.pid"));
        this.bundleInfo(jw, service.getBundle());
        if (details) {
            this.serviceDetails(jw, service);
            this.usingBundles(jw, service);
        }
        jw.endObject();
    }

    private void bundleInfo(JSONWriter jw, Bundle bundle) throws JSONException {
        jw.key("bundleId");
        jw.value(bundle.getBundleId());
        jw.key("bundleName");
        jw.value((Object)Util.getName(bundle));
        jw.key("bundleVersion");
        jw.value((Object)Util.getHeaderValue(bundle, "Bundle-Version"));
        jw.key("bundleSymbolicName");
        jw.value((Object)Util.getHeaderValue(bundle, "Bundle-SymbolicName"));
    }

    private void writeJSON(PrintWriter pw, ServiceReference service) throws IOException {
        this.writeJSON(pw, service, false);
    }

    private void writeJSON(Writer pw, ServiceReference service, boolean fullDetails) throws IOException {
        ServiceReference[] serviceReferenceArray;
        ServiceReference[] allServices = this.getServices();
        String statusLine = this.getStatusLine(allServices);
        if (service != null) {
            ServiceReference[] serviceReferenceArray2 = new ServiceReference[1];
            serviceReferenceArray = serviceReferenceArray2;
            serviceReferenceArray2[0] = service;
        } else {
            serviceReferenceArray = allServices;
        }
        ServiceReference[] services = serviceReferenceArray;
        JSONWriter jw = new JSONWriter(pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("data");
            jw.array();
            for (int i = 0; i < services.length; ++i) {
                this.serviceInfo(jw, services[i], fullDetails || service != null);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = new RequestInfo(request);
        if (reqInfo.service == null && reqInfo.serviceRequested) {
            response.sendError(404);
            return;
        }
        if (reqInfo.extension.equals("json")) {
            this.renderJSON(response, reqInfo.service);
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestInfo reqInfo = ServicesServlet.getRequestInfo(request);
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Util.startScript(pw);
        pw.println("var imgRoot = '" + appRoot + "/res/imgs';");
        pw.println("var bundlePath = '" + appRoot + "/" + "bundles" + "/" + "';");
        pw.println("var drawDetails = " + reqInfo.serviceRequested + ";");
        Util.endScript(pw);
        Util.script(pw, appRoot, "services.js");
        pw.println("<div id='plugin_content'/>");
        Util.startScript(pw);
        pw.print("renderServices(");
        this.writeJSON(pw, reqInfo.service);
        pw.println(");");
        Util.endScript(pw);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class RequestInfo {
        public final String extension;
        public final ServiceReference service;
        public final boolean serviceRequested;
        public final String pathInfo;

        protected RequestInfo(HttpServletRequest request) {
            String info = request.getPathInfo();
            info = info.substring(ServicesServlet.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            String serviceInfo = null;
            if (info.startsWith("/")) {
                serviceInfo = info.substring(1);
            }
            if (serviceInfo == null || serviceInfo.length() == 0) {
                this.service = null;
                this.serviceRequested = false;
                this.pathInfo = null;
            } else {
                this.service = ServicesServlet.this.getServiceById(serviceInfo);
                this.serviceRequested = true;
                this.pathInfo = serviceInfo;
            }
            request.setAttribute((class$org$apache$felix$webconsole$internal$core$ServicesServlet == null ? (class$org$apache$felix$webconsole$internal$core$ServicesServlet = ServicesServlet.class$("org.apache.felix.webconsole.internal.core.ServicesServlet")) : class$org$apache$felix$webconsole$internal$core$ServicesServlet).getName(), (Object)this);
        }
    }
}

