/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.compendium.ConfigManagerBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class ConfigManager
extends ConfigManagerBase {
    private static final String PID_FILTER = "pidFilter";
    public static final String NAME = "configMgr";
    public static final String LABEL = "Configuration";
    public static final String PID = "pid";
    public static final String factoryPID = "factoryPid";
    private static final String PLACEHOLDER_PID = "[Temporary PID replaced by real PID upon save]";
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedService;
    static /* synthetic */ Class class$org$osgi$service$cm$ManagedServiceFactory;

    public String getTitle() {
        return LABEL;
    }

    public String getLabel() {
        return NAME;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pid = request.getParameter(PID);
        if (pid == null) {
            String info = request.getPathInfo();
            pid = info.substring(info.lastIndexOf(47) + 1);
        }
        String pidFilter = request.getParameter(PID_FILTER);
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (pid == null || ca == null) {
            return;
        }
        PlaceholderConfiguration config = null;
        if (request.getParameter("create") != null) {
            config = new PlaceholderConfiguration(pid);
            pid = config.getPid();
        } else if (request.getParameter("apply") != null) {
            String redirect = this.applyConfiguration(request, ca, pid);
            if (redirect != null) {
                if (pidFilter != null) {
                    redirect = redirect + "?pidFilter=" + pidFilter;
                }
                this.sendRedirect(request, response, redirect);
            }
            return;
        }
        if (config == null) {
            config = this.getConfiguration(ca, pid);
        }
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        this.printConfigurationJson(response.getWriter(), pid, config, pidFilter, locale);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            String pid = info.substring(info.lastIndexOf(47) + 1, info.length() - 5);
            String pidFilter = request.getParameter(PID_FILTER);
            if (pidFilter == null) {
                pidFilter = pid;
            }
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
            ConfigurationAdmin ca = this.getConfigurationAdmin();
            Locale loc = this.getLocale(request);
            String locale = loc != null ? loc.toString() : null;
            PrintWriter pw = response.getWriter();
            try {
                pw.write("[");
                SortedMap services = this.getServices(pid, pidFilter, locale, false);
                Iterator i = services.keySet().iterator();
                boolean printColon = false;
                while (i.hasNext()) {
                    String servicePid = i.next().toString();
                    Configuration config = this.getConfiguration(ca, servicePid);
                    if (config == null) continue;
                    if (printColon) {
                        pw.print(',');
                    }
                    this.printConfigurationJson(pw, servicePid, config, pidFilter, locale);
                    printColon = true;
                }
                pw.write("]");
            }
            catch (InvalidSyntaxException e) {
                // empty catch block
            }
            return;
        }
        super.doGet(request, response);
    }

    public void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Configuration config;
        String pid = request.getPathInfo().substring(this.getLabel().length() + 1);
        pid = pid.length() == 0 ? null : pid.substring(pid.lastIndexOf(47) + 1);
        String pidFilter = request.getParameter(PID_FILTER);
        if (pidFilter == null) {
            pidFilter = pid;
        }
        if (pidFilter != null) {
            try {
                this.getBundleContext().createFilter(pidFilter);
                if (pid == pidFilter) {
                    pid = null;
                }
            }
            catch (InvalidSyntaxException ise) {
                pidFilter = null;
            }
        }
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        Locale loc = this.getLocale(request);
        String locale = loc != null ? loc.toString() : null;
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        pw.println("<script src='" + appRoot + "/res/ui/configmanager.js' language='JavaScript'></script>");
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        if (ca == null) {
            pw.println("<tr class='content' id='configField'>");
            pw.println("<td class='content'>&nbsp;</th>");
            pw.println("<td class='content'>");
            pw.print("Configuration Admin Service not available");
            pw.println("</td>");
            pw.println("</tr>");
        } else {
            pw.println("<tr class='content' id='configField'>");
            pw.println("<td class='content'>Configurations</th>");
            pw.println("<td class='content'>");
            this.listConfigurations(pw, ca, pidFilter, locale);
            pw.println("</td>");
            pw.println("</tr>");
            pw.println("<tr class='content' id='factoryField'>");
            pw.println("<td class='content'>Factory Configurations</th>");
            pw.println("<td class='content'>");
            this.listFactoryConfigurations(pw, ca, pidFilter, locale);
            pw.println("</td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
        if (request.getParameter("create") != null && pid != null) {
            config = new PlaceholderConfiguration(pid);
            pid = config.getPid();
        } else {
            config = this.getConfiguration(ca, pid);
        }
        if (pid != null) {
            Util.startScript(pw);
            pw.println("var configuration=");
            this.printConfigurationJson(pw, pid, config, pidFilter, locale);
            pw.println(";");
            pw.println("displayConfigForm(configuration);");
            Util.endScript(pw);
        }
    }

    private Configuration getConfiguration(ConfigurationAdmin ca, String pid) {
        if (ca != null && pid != null) {
            try {
                String filter = "(service.pid=" + pid + ")";
                Configuration[] configs = ca.listConfigurations(filter);
                if (configs != null && configs.length > 0) {
                    return configs[0];
                }
            }
            catch (InvalidSyntaxException ise) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void listConfigurations(PrintWriter pw, ConfigurationAdmin ca, String pidFilter, String locale) {
        try {
            SortedMap optionsPlain = this.getServices((class$org$osgi$service$cm$ManagedService == null ? (class$org$osgi$service$cm$ManagedService = ConfigManager.class$("org.osgi.service.cm.ManagedService")) : class$org$osgi$service$cm$ManagedService).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsPlain, this.getPidObjectClasses(locale), pidFilter, "service.pid");
            Configuration[] cfgs = ca.listConfigurations(pidFilter);
            for (int i = 0; cfgs != null && i < cfgs.length; ++i) {
                String name;
                String pid = cfgs[i].getPid();
                if (optionsPlain.containsKey(pid)) continue;
                ObjectClassDefinition ocd = this.getObjectClassDefinition(cfgs[i], locale);
                if (ocd != null) {
                    name = ocd.getName() + " (";
                    name = name + pid + ")";
                } else {
                    name = pid;
                }
                if (ocd == null) continue;
                optionsPlain.put(pid, name);
            }
            this.printOptionsForm(pw, optionsPlain, "configSelection_pid", "configure", "Configure");
        }
        catch (Exception e) {
            this.getLog().log(1, "listConfigurations: Unexpected problem encountered", e);
        }
    }

    private void listFactoryConfigurations(PrintWriter pw, ConfigurationAdmin ca, String pidFilter, String locale) {
        try {
            SortedMap optionsFactory = this.getServices((class$org$osgi$service$cm$ManagedServiceFactory == null ? (class$org$osgi$service$cm$ManagedServiceFactory = ConfigManager.class$("org.osgi.service.cm.ManagedServiceFactory")) : class$org$osgi$service$cm$ManagedServiceFactory).getName(), pidFilter, locale, true);
            this.addMetaTypeNames(optionsFactory, this.getFactoryPidObjectClasses(locale), pidFilter, "service.factoryPid");
            this.printOptionsForm(pw, optionsFactory, "configSelection_factory", "create", "Create");
        }
        catch (Exception e) {
            this.getLog().log(1, "listFactoryConfigurations: Unexpected problem encountered", e);
        }
    }

    private SortedMap getServices(String serviceClass, String serviceFilter, String locale, boolean ocdRequired) throws InvalidSyntaxException {
        TreeMap<String, String> optionsFactory = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        ServiceReference[] refs = this.getBundleContext().getServiceReferences(serviceClass, serviceFilter);
        for (int i = 0; refs != null && i < refs.length; ++i) {
            String name;
            Object pidObject = refs[i].getProperty("service.pid");
            if (!(pidObject instanceof String)) continue;
            String pid = (String)pidObject;
            ObjectClassDefinition ocd = this.getObjectClassDefinition(refs[i].getBundle(), pid, locale);
            if (ocd != null) {
                name = ocd.getName() + " (";
                name = name + pid + ")";
            } else {
                name = pid;
            }
            if (ocdRequired && ocd == null) continue;
            optionsFactory.put(pid, name);
        }
        return optionsFactory;
    }

    private void addMetaTypeNames(Map pidMap, Collection ocdCollection, String filterSpec, String type) {
        Filter filter = null;
        if (filterSpec != null) {
            try {
                filter = this.getBundleContext().createFilter(filterSpec);
            }
            catch (InvalidSyntaxException not_expected) {
                // empty catch block
            }
        }
        Iterator oci = ocdCollection.iterator();
        while (oci.hasNext()) {
            ObjectClassDefinition ocd = (ObjectClassDefinition)oci.next();
            String pid = ocd.getID();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put(type, pid);
            if (filter != null && !filter.match(props)) continue;
            String name = ocd.getName() + " (" + pid + ")";
            pidMap.put(pid, name);
        }
    }

    private void printOptionsForm(PrintWriter pw, SortedMap options, String formId, String submitMethod, String submitLabel) {
        Object entry;
        TreeSet<String> set = new TreeSet<String>();
        Iterator ei = options.entrySet().iterator();
        while (ei.hasNext()) {
            entry = ei.next();
            set.add(entry.getValue().toString() + '\uffff' + entry.getKey().toString());
        }
        pw.println("<select class='select' name='pid' id='" + formId + "' onChange='" + submitMethod + "();'>");
        ei = set.iterator();
        while (ei.hasNext()) {
            entry = (String)((Object)ei.next());
            int sep = ((String)entry).indexOf(65535);
            String value = ((String)entry).substring(0, sep);
            String key = ((String)entry).substring(sep + 1);
            pw.print("<option value='" + key + "'>");
            pw.print(value);
            pw.println("</option>");
        }
        pw.println("</select>");
        pw.println("&nbsp;&nbsp;");
        pw.println("<input class='submit' type='button' value='" + submitLabel + "' onClick='" + submitMethod + "();' />");
    }

    private void printConfigurationJson(PrintWriter pw, String pid, Configuration config, String pidFilter, String locale) {
        JSONWriter result = new JSONWriter((Writer)pw);
        if (pid != null) {
            try {
                result.object();
                this.configForm(result, pid, config, pidFilter, locale);
                result.endObject();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void configForm(JSONWriter json, String pid, Configuration config, String pidFilter, String locale) throws JSONException {
        ObjectClassDefinition ocd;
        json.key(PID);
        json.value((Object)pid);
        if (pidFilter != null) {
            json.key(PID_FILTER);
            json.value((Object)pidFilter);
        }
        Dictionary props = null;
        if (config != null) {
            props = config.getProperties();
            ocd = this.getObjectClassDefinition(config, locale);
        } else {
            ocd = this.getObjectClassDefinition(pid, locale);
        }
        props = this.mergeWithMetaType(props, ocd, json);
        if (props != null) {
            json.key("title");
            json.value((Object)pid);
            json.key("description");
            json.value((Object)"Please enter configuration properties for this configuration in the field below. This configuration has no associated description");
            json.key("propertylist");
            json.value((Object)"properties");
            json.key("properties");
            json.object();
            Enumeration pe = props.keys();
            while (pe.hasMoreElements()) {
                Object key = pe.nextElement();
                if (key.equals("service.pid") || key.equals("service.description") || key.equals("service.id") || key.equals("service.ranking") || key.equals("service.vendor") || key.equals("service.bundleLocation") || key.equals("service.factoryPid")) continue;
                json.key(String.valueOf(key));
                json.value(props.get(key));
            }
            json.endObject();
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    private Dictionary mergeWithMetaType(Dictionary props, ObjectClassDefinition ocd, JSONWriter json) throws JSONException {
        if (props == null) {
            props = new Hashtable();
        }
        if (ocd != null) {
            AttributeDefinition[] ad;
            json.key("title");
            json.value((Object)ocd.getName());
            if (ocd.getDescription() != null) {
                json.key("description");
                json.value((Object)ocd.getDescription());
            }
            if ((ad = ocd.getAttributeDefinitions(-1)) != null) {
                JSONArray propertyList = new JSONArray();
                for (int i = 0; i < ad.length; ++i) {
                    json.key(ad[i].getID());
                    json.object();
                    Object value = ((Dictionary)props).get(ad[i].getID());
                    if (value == null && (value = ad[i].getDefaultValue()) == null) {
                        value = ad[i].getCardinality() == 0 ? "" : new String[]{};
                    }
                    json.key("name");
                    json.value((Object)ad[i].getName());
                    json.key("type");
                    if (ad[i].getOptionLabels() != null && ad[i].getOptionLabels().length > 0) {
                        json.object();
                        json.key("labels");
                        json.value(Arrays.asList(ad[i].getOptionLabels()));
                        json.key("values");
                        json.value(Arrays.asList(ad[i].getOptionValues()));
                        json.endObject();
                    } else {
                        json.value((long)ad[i].getType());
                    }
                    if (ad[i].getCardinality() == 0) {
                        if (value instanceof Vector) {
                            value = ((Vector)value).get(0);
                        } else if (value.getClass().isArray()) {
                            value = Array.get(value, 0);
                        }
                        json.key("value");
                        json.value(value);
                    } else {
                        if (value instanceof Vector) {
                            value = new JSONArray((Collection)((Vector)value));
                        } else if (value.getClass().isArray()) {
                            value = new JSONArray(Arrays.asList((Object[])value));
                        } else {
                            JSONArray tmp = new JSONArray();
                            tmp.put(value);
                            value = tmp;
                        }
                        json.key("values");
                        json.value(value);
                    }
                    if (ad[i].getDescription() != null) {
                        json.key("description");
                        json.value((Object)ad[i].getDescription());
                    }
                    json.endObject();
                    propertyList.put((Object)ad[i].getID());
                }
                json.key("propertylist");
                json.value((Object)propertyList);
            }
            props = null;
        }
        return props;
    }

    private void addConfigurationInfo(Configuration config, JSONWriter json, String locale) throws JSONException {
        String location;
        if (config.getFactoryPid() != null) {
            json.key(factoryPID);
            json.value((Object)config.getFactoryPid());
        }
        if (config.getBundleLocation() == null) {
            location = "None";
        } else {
            Bundle bundle = this.getBundle(config.getBundleLocation());
            Dictionary headers = bundle.getHeaders(locale);
            String name = (String)headers.get("Bundle-Name");
            location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ")";
            Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
            location = location + ", Version " + v.toString();
        }
        json.key("bundleLocation");
        json.value((Object)location);
    }

    private String applyConfiguration(HttpServletRequest request, ConfigurationAdmin ca, String pid) throws IOException {
        if (request.getParameter("delete") != null) {
            if (!PLACEHOLDER_PID.equals(pid)) {
                this.getLog().log(3, "applyConfiguration: Deleting configuration " + pid);
                Configuration config = ca.getConfiguration(pid, null);
                config.delete();
            }
            return request.getHeader("Referer");
        }
        String factoryPid = request.getParameter(factoryPID);
        Configuration config = null;
        String propertyList = request.getParameter("propertylist");
        if (propertyList == null) {
            String propertiesString = request.getParameter("properties");
            if (propertiesString != null) {
                byte[] propBytes = propertiesString.getBytes("ISO-8859-1");
                ByteArrayInputStream bin = new ByteArrayInputStream(propBytes);
                Properties props = new Properties();
                props.load(bin);
                config = this.getConfiguration(ca, pid, factoryPid);
                config.update((Dictionary)props);
            }
        } else {
            Map adMap;
            config = this.getConfiguration(ca, pid, factoryPid);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            if ((adMap = this.getAttributeDefinitionMap(config, null)) != null) {
                StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
                while (propTokens.hasMoreTokens()) {
                    String prop;
                    String propName = propTokens.nextToken();
                    AttributeDefinition ad = (AttributeDefinition)adMap.get(propName);
                    if (ad == null || ad.getCardinality() == 0 && ad.getType() == 1) {
                        prop = request.getParameter(propName);
                        if (prop == null) continue;
                        ((Dictionary)props).put(propName, prop);
                        continue;
                    }
                    if (ad.getCardinality() == 0) {
                        prop = request.getParameter(propName);
                        if (prop == null) continue;
                        try {
                            ((Dictionary)props).put(propName, this.toType(ad.getType(), prop));
                        }
                        catch (NumberFormatException nfe) {}
                        continue;
                    }
                    Vector<Object> vec = new Vector<Object>();
                    String[] properties = request.getParameterValues(propName);
                    if (properties != null) {
                        for (int i = 0; i < properties.length; ++i) {
                            try {
                                vec.add(this.toType(ad.getType(), properties[i]));
                                continue;
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                    }
                    int maxSize = Math.abs(ad.getCardinality());
                    if (vec.size() > maxSize && maxSize > 0) {
                        vec.setSize(maxSize);
                    }
                    if (ad.getCardinality() < 0) {
                        ((Dictionary)props).put(propName, vec);
                        continue;
                    }
                    ((Dictionary)props).put(propName, this.toArray(ad.getType(), vec));
                }
            }
            config.update(props);
        }
        return config != null ? config.getPid() : "";
    }

    private Configuration getConfiguration(ConfigurationAdmin ca, String pid, String factoryPid) throws IOException {
        if (factoryPid != null && (pid == null || pid.equals(PLACEHOLDER_PID))) {
            return ca.createFactoryConfiguration(factoryPid, null);
        }
        return ca.getConfiguration(pid, null);
    }

    private Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return new Character(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    private Object toArray(int type, Vector values) {
        Object[] array;
        int size = values.size();
        if (type == 1) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
            }
            case 6: {
                array = new byte[size];
            }
            case 5: {
                array = new char[size];
            }
            case 7: {
                array = new double[size];
            }
            case 8: {
                array = new float[size];
            }
            case 2: {
                array = new long[size];
            }
            case 3: {
                array = new int[size];
            }
            case 4: {
                array = new short[size];
            }
        }
        array = new String[size];
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PlaceholderConfiguration
    implements Configuration {
        private final String factoryPid;
        private String bundleLocation;

        PlaceholderConfiguration(String factoryPid) {
            this.factoryPid = factoryPid;
        }

        public String getPid() {
            return ConfigManager.PLACEHOLDER_PID;
        }

        public String getFactoryPid() {
            return this.factoryPid;
        }

        public void setBundleLocation(String bundleLocation) {
            this.bundleLocation = bundleLocation;
        }

        public String getBundleLocation() {
            return this.bundleLocation;
        }

        public Dictionary getProperties() {
            return null;
        }

        public void update() {
        }

        public void update(Dictionary properties) {
        }

        public void delete() {
        }
    }
}

