/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.Bundle;
import org.osgi.service.component.ComponentContext;

public class LicenseServlet
extends AbstractWebConsolePlugin
implements OsgiManagerPlugin {
    public String getLabel() {
        return "licenses";
    }

    public String getTitle() {
        return "Licenses";
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws IOException {
        Bundle bundle;
        int i;
        PrintWriter pw = res.getWriter();
        String appRoot = req.getContextPath() + req.getServletPath();
        pw.println("<link href='" + appRoot + "/res/ui/license.css' rel='stylesheet' type='text/css'>");
        pw.println("<script src='" + appRoot + "/res/ui/license.js' language='JavaScript'></script>");
        Bundle[] bundles = this.getBundleContext().getBundles();
        Util.sort(bundles);
        Util.startScript(pw);
        pw.print("bundleData = ");
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            for (i = 0; i < bundles.length; ++i) {
                bundle = bundles[i];
                jw.key(String.valueOf(bundle.getBundleId()));
                jw.object();
                jw.key("title");
                jw.value((Object)Util.getName(bundle));
                jw.key("files");
                jw.object();
                this.findResource(jw, bundle, new String[]{"README", "DISCLAIMER", "LICENSE", "NOTICE"});
                jw.endObject();
                jw.endObject();
            }
            jw.endObject();
            pw.println(";");
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
        Util.endScript(pw);
        pw.println("<div id='licenseContent'>");
        pw.println("<div id='licenseLeft'>");
        for (i = 0; i < bundles.length; ++i) {
            bundle = bundles[i];
            String link = "displayBundle( \"" + bundle.getBundleId() + "\" );";
            pw.println("<a href='javascript:" + link + "'>" + Util.getName(bundle) + "</a><br />");
        }
        pw.println("</div>");
        pw.println("<div id='licenseRight'>");
        pw.println("<div id='licenseButtons' class='licenseButtons'>&nbsp;</div>");
        pw.println("<br />");
        pw.println("<div id='licenseDetails' class='licenseDetails'>&nbsp;</div>");
        pw.println("</div>");
        pw.println("<div id='licenseClear'>&nbsp;</div>");
        pw.println("</div>");
        Util.startScript(pw);
        pw.println("displayBundle( '0' );");
        Util.endScript(pw);
    }

    private String getName(String path) {
        return path.substring(path.lastIndexOf(47) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findResource(JSONWriter jw, Bundle bundle, String[] patterns) throws IOException, JSONException {
        jw.key("Bundle Resources");
        jw.array();
        for (int i = 0; i < patterns.length; ++i) {
            Enumeration entries = bundle.findEntries("/", patterns[i] + "*", true);
            if (entries == null) continue;
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                jw.object();
                jw.key("url");
                jw.value((Object)this.getName(url.getPath()));
                jw.key("data");
                jw.value((Object)this.readResource(url));
                jw.endObject();
            }
        }
        jw.endArray();
        Enumeration entries = bundle.findEntries("/", "*.jar", true);
        if (entries != null) {
            while (entries.hasMoreElements()) {
                URL url = (URL)entries.nextElement();
                jw.key("Embedded " + this.getName(url.getPath()));
                jw.array();
                for (int i = 0; i < patterns.length; ++i) {
                    String pattern = ".*/" + patterns[i] + "[^/]*$";
                    InputStream ins = null;
                    try {
                        ins = url.openStream();
                        ZipInputStream zin = new ZipInputStream(ins);
                        ZipEntry zentry = zin.getNextEntry();
                        while (zentry != null) {
                            String name = zentry.getName();
                            if (!name.endsWith("/") && "/".concat(name).matches(pattern)) {
                                jw.object();
                                jw.key("url");
                                jw.value((Object)this.getName(name));
                                jw.key("data");
                                jw.value((Object)this.readResource(new FilterInputStream(zin){

                                    public void close() {
                                    }
                                }));
                                jw.endObject();
                            }
                            zentry = zin.getNextEntry();
                        }
                        continue;
                    }
                    finally {
                        if (ins != null) {
                            try {
                                ins.close();
                            }
                            catch (IOException ignore) {}
                        }
                    }
                }
                jw.endArray();
            }
        }
    }

    private String getResource(Bundle bundle, String[] path) throws IOException {
        for (int i = 0; i < path.length; ++i) {
            URL resource = bundle.getResource(path[i]);
            if (resource == null) continue;
            return this.readResource(resource);
        }
        return null;
    }

    private String readResource(URL resource) throws IOException {
        return this.readResource(resource.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResource(InputStream resource) throws IOException {
        Reader r = null;
        StringBuffer buffer = new StringBuffer();
        try {
            int num;
            char[] buf = new char[1024];
            r = new InputStreamReader(resource, "ISO-8859-1");
            while ((num = r.read(buf)) >= 0) {
                buffer.append(buf, 0, num);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ignore) {}
            }
        }
        return buffer.toString();
    }

    protected void activate(ComponentContext context) {
        this.activate(context.getBundleContext());
    }

    protected void deactivate(ComponentContext context) {
        this.deactivate();
    }
}

