/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.osgi.service.prefs.PreferencesService;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationRender
extends BaseManagementPlugin
implements Render {
    public static final String NAME = "config";
    public static final String LABEL = "Configuration Status";
    private ServiceTracker cfgPrinterTracker;
    private int cfgPrinterTrackerCount;
    private SortedMap configurationPrinters = new TreeMap();
    static /* synthetic */ Class class$org$osgi$service$prefs$PreferencesService;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationAdmin;

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
        pw.println("<tr class='content'>");
        pw.println("<th class='content container'>Configuration Details</th>");
        pw.println("</tr>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>");
        pw.println("<pre>");
        pw.println("*** Date: " + SimpleDateFormat.getDateTimeInstance(1, 1, Locale.US).format(new Date()));
        pw.println();
        this.printSystemProperties(pw);
        this.printBundles(pw);
        this.printServices(pw);
        this.printPreferences(pw);
        this.printConfigurations(pw);
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            this.printConfigurationPrinter(pw, (ConfigurationPrinter)cpi.next());
        }
        pw.println("</pre>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</table>");
    }

    private Collection getConfigurationPrinters() {
        if (this.cfgPrinterTracker == null) {
            this.cfgPrinterTracker = new ServiceTracker(this.getBundleContext(), ConfigurationPrinter.SERVICE, null);
            this.cfgPrinterTracker.open();
            this.cfgPrinterTrackerCount = -1;
        }
        if (this.cfgPrinterTrackerCount != this.cfgPrinterTracker.getTrackingCount()) {
            TreeMap<String, ConfigurationPrinter> cp = new TreeMap<String, ConfigurationPrinter>();
            Object[] services = this.cfgPrinterTracker.getServices();
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    Object srv = services[i];
                    ConfigurationPrinter cfgPrinter = (ConfigurationPrinter)srv;
                    cp.put(cfgPrinter.getTitle(), cfgPrinter);
                }
            }
            this.configurationPrinters = cp;
            this.cfgPrinterTrackerCount = this.cfgPrinterTracker.getTrackingCount();
        }
        return this.configurationPrinters.values();
    }

    private void printSystemProperties(PrintWriter pw) {
        pw.println("*** System properties:");
        Properties props = System.getProperties();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        Iterator ki = keys.iterator();
        while (ki.hasNext()) {
            Object key = ki.next();
            this.infoLine(pw, null, (String)key, props.get(key));
        }
        pw.println();
    }

    private void printBundles(PrintWriter pw) {
        pw.println("*** Bundles:");
        Bundle[] bundles = this.getBundleContext().getBundles();
        TreeSet<String> keys = new TreeSet<String>();
        for (int i = 0; i < bundles.length; ++i) {
            keys.add(this.getBundleString(bundles[i], true));
        }
        Iterator ki = keys.iterator();
        while (ki.hasNext()) {
            this.infoLine(pw, null, null, ki.next());
        }
        pw.println();
    }

    private void printServices(PrintWriter pw) {
        pw.println("*** Services:");
        TreeMap<Object, ServiceReference> srMap = new TreeMap<Object, ServiceReference>();
        try {
            ServiceReference[] srs = this.getBundleContext().getAllServiceReferences(null, null);
            for (int i = 0; i < srs.length; ++i) {
                srMap.put(srs[i].getProperty("service.id"), srs[i]);
            }
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        Iterator si = srMap.values().iterator();
        while (si.hasNext()) {
            int i;
            ServiceReference sr = (ServiceReference)si.next();
            this.infoLine(pw, null, String.valueOf(sr.getProperty("service.id")), sr.getProperty("objectClass"));
            this.infoLine(pw, "  ", "Bundle", this.getBundleString(sr.getBundle(), false));
            Bundle[] users = sr.getUsingBundles();
            if (users != null && users.length > 0) {
                ArrayList<String> userString = new ArrayList<String>();
                for (i = 0; i < users.length; ++i) {
                    userString.add(this.getBundleString(users[i], false));
                }
                this.infoLine(pw, "  ", "Using Bundles", userString);
            }
            Object[] keys = sr.getPropertyKeys();
            Arrays.sort(keys);
            for (i = 0; i < keys.length; ++i) {
                if ("service.id".equals(keys[i]) || "objectClass".equals(keys[i])) continue;
                this.infoLine(pw, "  ", (String)keys[i], sr.getProperty((String)keys[i]));
            }
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printPreferences(PrintWriter pw) {
        pw.println("*** System Preferences:");
        ServiceReference sr = this.getBundleContext().getServiceReference((class$org$osgi$service$prefs$PreferencesService == null ? (class$org$osgi$service$prefs$PreferencesService = ConfigurationRender.class$("org.osgi.service.prefs.PreferencesService")) : class$org$osgi$service$prefs$PreferencesService).getName());
        if (sr == null) {
            pw.println("  Preferences Service not registered");
            pw.println();
            return;
        }
        PreferencesService ps = (PreferencesService)this.getBundleContext().getService(sr);
        try {
            this.printPreferences(pw, ps.getSystemPreferences());
            String[] users = ps.getUsers();
            for (int i = 0; users != null && i < users.length; ++i) {
                pw.println("*** User Preferences " + users[i] + ":");
                this.printPreferences(pw, ps.getUserPreferences(users[i]));
            }
        }
        catch (BackingStoreException bse) {
        }
        finally {
            this.getBundleContext().ungetService(sr);
        }
    }

    private void printPreferences(PrintWriter pw, Preferences prefs) throws BackingStoreException {
        String[] children = prefs.childrenNames();
        for (int i = 0; i < children.length; ++i) {
            this.printPreferences(pw, prefs.node(children[i]));
        }
        String[] keys = prefs.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.infoLine(pw, null, prefs.absolutePath() + "/" + keys[i], prefs.get(keys[i], null));
        }
        pw.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printConfigurations(PrintWriter pw) {
        pw.println("*** Configurations:");
        ServiceReference sr = this.getBundleContext().getServiceReference((class$org$osgi$service$cm$ConfigurationAdmin == null ? (class$org$osgi$service$cm$ConfigurationAdmin = ConfigurationRender.class$("org.osgi.service.cm.ConfigurationAdmin")) : class$org$osgi$service$cm$ConfigurationAdmin).getName());
        if (sr == null) {
            pw.println("  Configuration Admin Service not registered");
        } else {
            ConfigurationAdmin ca = (ConfigurationAdmin)this.getBundleContext().getService(sr);
            try {
                Configuration[] configs = ca.listConfigurations(null);
                if (configs != null && configs.length > 0) {
                    TreeMap<String, Configuration> sm = new TreeMap<String, Configuration>();
                    for (int i = 0; i < configs.length; ++i) {
                        sm.put(configs[i].getPid(), configs[i]);
                    }
                    Iterator mi = sm.values().iterator();
                    while (mi.hasNext()) {
                        this.printConfiguration(pw, (Configuration)mi.next());
                    }
                } else {
                    pw.println("  No Configurations available");
                }
            }
            catch (Exception e) {
            }
            finally {
                this.getBundleContext().ungetService(sr);
            }
        }
        pw.println();
    }

    private void printConfigurationPrinter(PrintWriter pw, ConfigurationPrinter cp) {
        pw.println("*** " + cp.getTitle() + ":");
        cp.printConfiguration(pw);
        pw.println();
    }

    private void printConfiguration(PrintWriter pw, Configuration config) {
        this.infoLine(pw, "", "PID", config.getPid());
        if (config.getFactoryPid() != null) {
            this.infoLine(pw, "  ", "Factory PID", config.getFactoryPid());
        }
        String loc = config.getBundleLocation() != null ? config.getBundleLocation() : "Unbound";
        this.infoLine(pw, "  ", "BundleLocation", loc);
        Dictionary props = config.getProperties();
        if (props != null) {
            TreeSet keys = new TreeSet();
            Enumeration ke = props.keys();
            while (ke.hasMoreElements()) {
                keys.add(ke.nextElement());
            }
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                this.infoLine(pw, "  ", key, props.get(key));
            }
        }
        pw.println();
    }

    private void infoLine(PrintWriter pw, String indent, String label, Object value) {
        if (indent != null) {
            pw.print(indent);
        }
        if (label != null) {
            pw.print(label);
            pw.print('=');
        }
        this.printObject(pw, value);
        pw.println();
    }

    private void printObject(PrintWriter pw, Object value) {
        if (value == null) {
            pw.print("null");
        } else if (value.getClass().isArray()) {
            this.printArray(pw, (Object[])value);
        } else {
            pw.print(value);
        }
    }

    private void printArray(PrintWriter pw, Object[] values) {
        pw.print('[');
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                this.printObject(pw, values[i]);
            }
        }
        pw.print(']');
    }

    private String getBundleString(Bundle bundle, boolean withState) {
        StringBuffer buf = new StringBuffer();
        if (bundle.getSymbolicName() != null) {
            buf.append(bundle.getSymbolicName());
        } else if (bundle.getLocation() != null) {
            buf.append(bundle.getLocation());
        } else {
            buf.append(bundle.getBundleId());
        }
        Dictionary headers = bundle.getHeaders();
        if (headers.get("Bundle-Version") != null) {
            buf.append(" (").append(headers.get("Bundle-Version")).append(')');
        }
        if (headers.get("Bundle-Name") != null) {
            buf.append(" \"").append(headers.get("Bundle-Name")).append('\"');
        }
        if (withState) {
            buf.append(" [");
            switch (bundle.getState()) {
                case 2: {
                    buf.append("Installed");
                    break;
                }
                case 4: {
                    buf.append("Resolved");
                    break;
                }
                case 8: {
                    buf.append("Starting");
                    break;
                }
                case 32: {
                    buf.append("Active");
                    break;
                }
                case 16: {
                    buf.append("Stopping");
                    break;
                }
                case 1: {
                    buf.append("Uninstalled");
                }
            }
            buf.append(']');
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

