/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.bundlerepository.R4Attribute;
import org.apache.felix.bundlerepository.R4Export;
import org.apache.felix.bundlerepository.R4Import;
import org.apache.felix.bundlerepository.R4Package;
import org.apache.felix.webconsole.internal.core.BundleAction;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class AjaxBundleDetailsAction
extends BundleAction {
    public static final String NAME = "ajaxBundleDetails";
    private String[] bootPkgs;
    private boolean[] bootPkgWildcards;

    public void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        String bootDelegation = bundleContext.getProperty("org.osgi.framework.bootdelegation");
        bootDelegation = bootDelegation == null ? "java.*" : bootDelegation + ",java.*";
        StringTokenizer st = new StringTokenizer(bootDelegation, " ,");
        this.bootPkgs = new String[st.countTokens()];
        this.bootPkgWildcards = new boolean[this.bootPkgs.length];
        for (int i = 0; i < this.bootPkgs.length; ++i) {
            bootDelegation = st.nextToken();
            if (bootDelegation.endsWith("*")) {
                this.bootPkgWildcards[i] = true;
                bootDelegation = bootDelegation.substring(0, bootDelegation.length() - 1);
            }
            this.bootPkgs[i] = bootDelegation;
        }
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return NAME;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject result = null;
        try {
            long bundleId = this.getBundleId(request);
            Bundle bundle = this.getBundleContext().getBundle(bundleId);
            if (bundle != null) {
                Dictionary headers = bundle.getHeaders();
                JSONArray props = new JSONArray();
                this.keyVal(props, "Symbolic Name", bundle.getSymbolicName());
                this.keyVal(props, "Version", headers.get("Bundle-Version"));
                this.keyVal(props, "Location", bundle.getLocation());
                this.keyVal(props, "Last Modification", new Date(bundle.getLastModified()));
                this.keyVal(props, "Vendor", headers.get("Bundle-Vendor"));
                this.keyVal(props, "Copyright", headers.get("Bundle-Copyright"));
                this.keyVal(props, "Description", headers.get("Bundle-Description"));
                this.keyVal(props, "Start Level", this.getStartLevel(bundle));
                if (bundle.getState() == 2) {
                    this.listImportExportsUnresolved(props, bundle);
                } else {
                    this.listImportExport(props, bundle);
                }
                this.listServices(props, bundle);
                result = new JSONObject();
                result.put("bundleId", bundleId);
                result.put("props", props);
            }
        }
        catch (Exception exception) {
            result = new JSONObject();
        }
        response.setContentType("text/javascript");
        response.getWriter().print(result.toString());
        return false;
    }

    private Integer getStartLevel(Bundle bundle) {
        StartLevel sl = this.getStartLevel();
        return sl != null ? new Integer(sl.getBundleStartLevel(bundle)) : null;
    }

    private void listImportExport(JSONArray props, Bundle bundle) {
        StringBuffer val;
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return;
        }
        TreeMap<String, Bundle> usingBundles = new TreeMap<String, Bundle>();
        ExportedPackage[] exports = packageAdmin.getExportedPackages(bundle);
        if (exports != null && exports.length > 0) {
            Arrays.sort(exports, new Comparator(){

                public int compare(ExportedPackage p1, ExportedPackage p2) {
                    return p1.getName().compareTo(p2.getName());
                }

                public int compare(Object o1, Object o2) {
                    return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                }
            });
            val = new StringBuffer();
            for (int j = 0; j < exports.length; ++j) {
                ExportedPackage export = exports[j];
                this.printExport(val, export.getName(), export.getVersion());
                Bundle[] ubList = export.getImportingBundles();
                if (ubList == null) continue;
                for (int i = 0; i < ubList.length; ++i) {
                    Bundle ub = ubList[i];
                    usingBundles.put(ub.getSymbolicName(), ub);
                }
            }
            this.keyVal(props, "Exported Packages", val.toString());
        } else {
            this.keyVal(props, "Exported Packages", "None");
        }
        exports = packageAdmin.getExportedPackages((Bundle)null);
        if (exports != null && exports.length > 0) {
            ArrayList<ExportedPackage> imports = new ArrayList<ExportedPackage>();
            block2: for (int i = 0; i < exports.length; ++i) {
                ExportedPackage ep = exports[i];
                Bundle[] importers = ep.getImportingBundles();
                for (int j = 0; importers != null && j < importers.length; ++j) {
                    if (importers[j].getBundleId() != bundle.getBundleId()) continue;
                    imports.add(ep);
                    continue block2;
                }
            }
            StringBuffer val2 = new StringBuffer();
            if (imports.size() > 0) {
                ExportedPackage[] packages = imports.toArray(new ExportedPackage[imports.size()]);
                Arrays.sort(packages, new Comparator(){

                    public int compare(ExportedPackage p1, ExportedPackage p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((ExportedPackage)o1, (ExportedPackage)o2);
                    }
                });
                for (int i = 0; i < packages.length; ++i) {
                    ExportedPackage ep = packages[i];
                    this.printImport(val2, ep.getName(), ep.getVersion(), ep);
                }
            } else {
                val2.append("None");
            }
            this.keyVal(props, "Imported Packages", val2.toString());
        }
        if (!usingBundles.isEmpty()) {
            val = new StringBuffer();
            Iterator ui = usingBundles.values().iterator();
            while (ui.hasNext()) {
                Bundle usingBundle = (Bundle)ui.next();
                val.append(this.getBundleDescriptor(usingBundle));
                val.append("<br />");
            }
            this.keyVal(props, "Importing Bundles", val.toString());
        }
    }

    private void listImportExportsUnresolved(JSONArray props, Bundle bundle) {
        int i;
        R4Package[] pkgs;
        Dictionary dict = bundle.getHeaders();
        String target = (String)dict.get("Export-Package");
        if (target != null) {
            pkgs = R4Package.parseImportOrExportHeader(target);
            if (pkgs != null && pkgs.length > 0) {
                Arrays.sort(pkgs, new Comparator(){

                    public int compare(R4Package p1, R4Package p2) {
                        return p1.getName().compareTo(p2.getName());
                    }

                    public int compare(Object o1, Object o2) {
                        return this.compare((R4Package)o1, (R4Package)o2);
                    }
                });
                StringBuffer val = new StringBuffer();
                for (i = 0; i < pkgs.length; ++i) {
                    R4Export export = new R4Export(pkgs[i]);
                    this.printExport(val, export.getName(), export.getVersion());
                }
                this.keyVal(props, "Exported Packages", val.toString());
            } else {
                this.keyVal(props, "Exported Packages", "None");
            }
        }
        if ((target = (String)dict.get("Import-Package")) != null && (pkgs = R4Package.parseImportOrExportHeader(target)) != null && pkgs.length > 0) {
            ExportedPackage[] exports;
            TreeMap<String, R4Import> imports = new TreeMap<String, R4Import>();
            for (i = 0; i < pkgs.length; ++i) {
                R4Package pkg = pkgs[i];
                imports.put(pkg.getName(), new R4Import(pkg));
            }
            HashMap<String, ExportedPackage> candidates = new HashMap<String, ExportedPackage>();
            PackageAdmin packageAdmin = this.getPackageAdmin();
            if (packageAdmin != null && (exports = packageAdmin.getExportedPackages((Bundle)null)) != null && exports.length > 0) {
                for (int i2 = 0; i2 < exports.length; ++i2) {
                    ExportedPackage ep = exports[i2];
                    R4Import imp = (R4Import)imports.get(ep.getName());
                    if (imp == null || !imp.isSatisfied(this.toR4Export(ep))) continue;
                    candidates.put(ep.getName(), ep);
                }
            }
            StringBuffer val = new StringBuffer();
            if (imports.size() > 0) {
                Iterator ii = imports.values().iterator();
                while (ii.hasNext()) {
                    String path;
                    R4Import r4Import = (R4Import)ii.next();
                    ExportedPackage ep = (ExportedPackage)candidates.get(r4Import.getName());
                    if (ep == null && bundle.getResource(path = r4Import.getName().replace('.', '/')) != null) continue;
                    this.printImport(val, r4Import.getName(), r4Import.getVersion(), ep);
                }
            } else {
                val.append("None");
            }
            this.keyVal(props, "Imported Packages", val.toString());
        }
    }

    private void listServices(JSONArray props, Bundle bundle) {
        ServiceReference[] refs = bundle.getRegisteredServices();
        if (refs == null || refs.length == 0) {
            return;
        }
        for (int i = 0; i < refs.length; ++i) {
            String key = "Service ID " + refs[i].getProperty("service.id");
            StringBuffer val = new StringBuffer();
            this.appendProperty(val, refs[i], "objectClass", "Types");
            this.appendProperty(val, refs[i], "service.pid", "PID");
            this.appendProperty(val, refs[i], "service.factoryPid", "Factory PID");
            this.appendProperty(val, refs[i], "component.name", "Component Name");
            this.appendProperty(val, refs[i], "component.id", "Component ID");
            this.appendProperty(val, refs[i], "component.factory", "Component Factory");
            this.appendProperty(val, refs[i], "service.description", "Description");
            this.appendProperty(val, refs[i], "service.vendor", "Vendor");
            this.keyVal(props, key, val.toString());
        }
    }

    private void appendProperty(StringBuffer dest, ServiceReference ref, String name, String label) {
        Object value = ref.getProperty(name);
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            dest.append(label).append(": ");
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    dest.append(", ");
                }
                dest.append(values[j]);
            }
            dest.append("<br />");
        } else if (value != null) {
            dest.append(label).append(": ").append(value).append("<br />");
        }
    }

    private void keyVal(JSONArray props, String key, Object value) {
        if (key != null && value != null) {
            try {
                JSONObject obj = new JSONObject();
                obj.put("key", key);
                obj.put("value", value);
                props.put(obj);
            }
            catch (JSONException je) {
                // empty catch block
            }
        }
    }

    private void printExport(StringBuffer val, String name, Version version) {
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel) {
            val.append("<span style=\"color: red\">!! ");
        }
        val.append(name);
        val.append(",version=");
        val.append(version);
        if (bootDel) {
            val.append(" -- Overwritten by Boot Delegation</span>");
        }
        val.append("<br />");
    }

    private void printImport(StringBuffer val, String name, Version version, ExportedPackage export) {
        boolean bootDel = this.isBootDelegated(name);
        if (bootDel || export == null) {
            val.append("<span style=\"color: red\">!! ");
        }
        val.append(name);
        val.append(",version=").append(version);
        val.append(" from ");
        if (export != null) {
            val.append(this.getBundleDescriptor(export.getExportingBundle()));
            if (bootDel) {
                val.append(" -- Overwritten by Boot Delegation</span>");
            }
        } else {
            val.append(" -- Cannot be resolved");
            if (bootDel) {
                val.append(" and overwritten by Boot Delegation");
            }
            val.append("</span>");
        }
        val.append("<br />");
    }

    private boolean isBootDelegated(String pkgName) {
        if (pkgName.length() > 0) {
            for (int i = 0; i < this.bootPkgs.length; ++i) {
                if ((!this.bootPkgWildcards[i] || !pkgName.startsWith(this.bootPkgs[i]) && !this.bootPkgs[i].regionMatches(0, pkgName, 0, pkgName.length())) && (this.bootPkgWildcards[i] || !this.bootPkgs[i].equals(pkgName))) continue;
                return true;
            }
        }
        return false;
    }

    private R4Export toR4Export(ExportedPackage export) {
        R4Attribute version = new R4Attribute("version", export.getVersion().toString(), false);
        return new R4Export(export.getName(), null, new R4Attribute[]{version});
    }

    private String getBundleDescriptor(Bundle bundle) {
        StringBuffer val = new StringBuffer();
        if (bundle.getSymbolicName() != null) {
            val.append(bundle.getSymbolicName());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else if (bundle.getLocation() != null) {
            val.append(bundle.getLocation());
            val.append(" (").append(bundle.getBundleId());
            val.append(")");
        } else {
            val.append(bundle.getBundleId());
        }
        return val.toString();
    }
}

