/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.felix.webconsole.Render;

public class Util {
    public static final String PAGE_WEBAPPS = "/webapps";
    public static final String PAGE_VM_STAT = "/vmstat";
    public static final String PAGE_LOGS = "/logs";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_CONTENT = "content";
    public static final String PARAM_SHUTDOWN = "shutdown";
    public static final String VALUE_SHUTDOWN = "shutdown";
    private static final String HEADER = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\"><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; utf-8\"><link rel=\"icon\" href=\"res/imgs/favicon.ico\"><title>{0} - {12}</title><script src=\"res/ui/admin.js\" language=\"JavaScript\"></script><script language=\"JavaScript\">ABOUT_VERSION=''{1}'';ABOUT_JVERSION=''{2}'';ABOUT_JRT=''{3} (build {2})'';ABOUT_JVM=''{4} (build {5}, {6})'';ABOUT_MEM=\"{7} KB\";ABOUT_USED=\"{8} KB\";ABOUT_FREE=\"{9} KB\";</script><link href=\"res/ui/admin.css\" rel=\"stylesheet\" type=\"text/css\"></head><body><div id=\"main\"><div id=\"lead\"><h1>{0}<br>{12}</h1><p><a target=\"_blank\" href=\"{13}\" title=\"{11}\"><img src=\"res/imgs/logo.png\" width=\"165\" height=\"63\" border=\"0\"></a></p></div>";
    public static final String ATTR_FILEUPLOAD = "org.apache.felix.webconsole.fileupload";
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$Util;

    public static PrintWriter startHtml(HttpServletResponse resp, String pageTitle) throws IOException {
        resp.setContentType("text/html; utf-8");
        PrintWriter pw = resp.getWriter();
        String adminTitle = "OSGi Management Console";
        String productName = "Felix";
        String productWeb = "http://felix.apache.org";
        String vendorName = "http://www.apache.org";
        String vendorWeb = "http://www.apache.org";
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long usedMem = totalMem - freeMem;
        String header = MessageFormat.format(HEADER, adminTitle, "1.0.0-SNAPSHOT", System.getProperty("java.runtime.version"), System.getProperty("java.runtime.name"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.info"), new Long(totalMem), new Long(usedMem), new Long(freeMem), vendorWeb, productName, pageTitle, productWeb, vendorName);
        pw.println(header);
        return pw;
    }

    public static void navigation(PrintWriter pw, Collection renders, String current, boolean disabled) {
        pw.println("<p id='technav'>");
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator ri = renders.iterator();
        while (ri.hasNext()) {
            Render render = (Render)ri.next();
            if (render.getLabel() == null) continue;
            if (disabled || current.equals(render.getName())) {
                map.put(render.getLabel(), "<span class='technavat'>" + render.getLabel() + "</span>");
                continue;
            }
            map.put(render.getLabel(), "<a href='" + render.getName() + "'>" + render.getLabel() + "</a></li>");
        }
        Iterator li = map.values().iterator();
        while (li.hasNext()) {
            pw.println(li.next());
        }
        pw.println("</p>");
    }

    public static void endHhtml(PrintWriter pw) {
        pw.println("</body>");
        pw.println("</html>");
    }

    public static void startScript(PrintWriter pw) {
        pw.println("<script type='text/javascript'>");
        pw.println("// <![CDATA[");
    }

    public static void endScript(PrintWriter pw) {
        pw.println("// ]]>");
        pw.println("</script>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void spool(String res, HttpServletResponse resp) throws IOException {
        InputStream ins = Util.getResource(res);
        if (ins != null) {
            try {
                IOUtils.copy(ins, (OutputStream)resp.getOutputStream());
            }
            finally {
                IOUtils.closeQuietly(ins);
            }
        }
    }

    private static InputStream getResource(String resource) {
        return (class$org$apache$felix$webconsole$internal$Util == null ? (class$org$apache$felix$webconsole$internal$Util = Util.class$("org.apache.felix.webconsole.internal.Util")) : class$org$apache$felix$webconsole$internal$Util).getResourceAsStream(resource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

