/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.LocalVariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor {
    private final String m_name;
    private final String m_returnType;
    private final String[] m_arguments;
    private final String m_desc;
    private List<ClassChecker.AnnotationDescriptor> m_annotations;
    private Map<Integer, List<ClassChecker.AnnotationDescriptor>> m_parameterAnnotations = new HashMap<Integer, List<ClassChecker.AnnotationDescriptor>>();
    private List<LocalVariableNode> m_argLocalVariables;
    private final int m_argsVarLength;
    private final boolean m_isStatic;
    private LinkedHashMap<Integer, LocalVariableNode> m_locals = new LinkedHashMap();

    public MethodDescriptor(String name, String desc, boolean isStatic) {
        this.m_name = name;
        this.m_desc = desc;
        this.m_isStatic = isStatic;
        Type ret = Type.getReturnType(desc);
        Type[] args = Type.getArgumentTypes(desc);
        this.m_returnType = this.getType(ret);
        this.m_arguments = new String[args.length];
        int argsVarLength = args.length;
        if (!this.m_isStatic) {
            ++argsVarLength;
        }
        for (int i = 0; i < args.length; ++i) {
            String type;
            this.m_arguments[i] = type = this.getType(args[i]);
            if (!"long".equals(type) && !"double".equals(type)) continue;
            ++argsVarLength;
        }
        this.m_argsVarLength = argsVarLength;
    }

    public void addAnnotation(ClassChecker.AnnotationDescriptor ann) {
        if (this.m_annotations == null) {
            this.m_annotations = new ArrayList<ClassChecker.AnnotationDescriptor>();
        }
        this.m_annotations.add(ann);
    }

    public void addParameterAnnotation(int id, ClassChecker.AnnotationDescriptor ann) {
        List<ClassChecker.AnnotationDescriptor> list = this.m_parameterAnnotations.get(new Integer(id));
        if (list == null) {
            list = new ArrayList<ClassChecker.AnnotationDescriptor>();
            this.m_parameterAnnotations.put(new Integer(id), list);
        }
        list.add(ann);
    }

    public List<ClassChecker.AnnotationDescriptor> getAnnotations() {
        return this.m_annotations;
    }

    public Map<Integer, List<ClassChecker.AnnotationDescriptor>> getParameterAnnotations() {
        return this.m_parameterAnnotations;
    }

    public String getDescriptor() {
        return this.m_desc;
    }

    public Element getElement() {
        Element method = new Element("method", "");
        method.addAttribute(new Attribute("name", this.m_name));
        if (!this.m_returnType.equals("void")) {
            method.addAttribute(new Attribute("return", this.m_returnType));
        }
        if (this.m_arguments.length > 0) {
            StringBuilder args = new StringBuilder("{");
            StringBuilder names = new StringBuilder("{");
            args.append(this.m_arguments[0]);
            if (this.m_locals.containsKey(1)) {
                names.append(this.m_locals.get((Object)Integer.valueOf((int)1)).name);
            }
            for (int i = 1; i < this.m_arguments.length; ++i) {
                args.append(",").append(this.m_arguments[i]);
                if (!this.m_locals.containsKey(i + 1)) continue;
                names.append(",").append(this.m_locals.get((Object)Integer.valueOf((int)(i + 1))).name);
            }
            args.append("}");
            names.append("}");
            method.addAttribute(new Attribute("arguments", args.toString()));
            method.addAttribute(new Attribute("names", names.toString()));
        }
        return method;
    }

    private String getType(Type type) {
        switch (type.getSort()) {
            case 9: {
                String brackets = "";
                for (int i = 0; i < type.getDimensions(); ++i) {
                    brackets = brackets + "[]";
                }
                Type elemType = type.getElementType();
                return this.getType(elemType) + brackets;
            }
            case 1: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 5: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 10: {
                return type.getClassName();
            }
            case 4: {
                return "short";
            }
            case 0: {
                return "void";
            }
        }
        return "unknown";
    }

    public String getName() {
        return this.m_name;
    }

    public void addLocalVariable(String name, String desc, String signature, int index) {
        this.m_locals.put(index, new LocalVariableNode(name, desc, signature, null, null, index));
        if (index >= this.m_argsVarLength) {
            return;
        }
        if (this.m_argLocalVariables == null) {
            this.m_argLocalVariables = new ArrayList<LocalVariableNode>();
        }
        this.m_argLocalVariables.add(new LocalVariableNode(name, desc, signature, null, null, index));
    }

    public void end() {
        if (this.m_argLocalVariables != null && this.m_argLocalVariables.size() > 1) {
            Collections.sort(this.m_argLocalVariables, new Comparator<LocalVariableNode>(){

                @Override
                public int compare(LocalVariableNode o1, LocalVariableNode o2) {
                    return o1.index - o2.index;
                }
            });
        }
    }

    public List<LocalVariableNode> getArgumentLocalVariables() {
        return this.m_argLocalVariables;
    }

    public LinkedHashMap<Integer, LocalVariableNode> getLocals() {
        return this.m_locals;
    }
}

