/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.CompletableBindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.FieldGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.MethodGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.ParameterGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.TypeGenericVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.AnnotationVisitorFactory;
import org.apache.felix.ipojo.manipulator.spi.BindingContext;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyGenericBindingRegistry
extends CompletableBindingRegistry {
    public static final Pattern CUSTOM_HANDLER_PATTERN = Pattern.compile("(.*\\.ipojo\\..*)|(.*\\.handler\\..*)");

    public LegacyGenericBindingRegistry(BindingRegistry delegate, Reporter reporter) {
        super(delegate, reporter);
    }

    @Override
    protected List<Binding> createBindings(final Type type) {
        if (CUSTOM_HANDLER_PATTERN.matcher(type.getClassName()).matches()) {
            Binding binding = new Binding();
            binding.setAnnotationType(type);
            binding.setPredicate(Predicates.alwaysTrue());
            binding.setFactory(new AnnotationVisitorFactory(){

                public AnnotationVisitor newAnnotationVisitor(BindingContext context) {
                    if (context.getNode() instanceof ClassNode) {
                        return new TypeGenericVisitor(context.getWorkbench(), Elements.buildElement(type));
                    }
                    if (context.getNode() instanceof FieldNode) {
                        return new FieldGenericVisitor(context.getWorkbench(), Elements.buildElement(type), (FieldNode)context.getNode());
                    }
                    if (context.getNode() instanceof MethodNode && context.getParameterIndex() == -1) {
                        return new MethodGenericVisitor(context.getWorkbench(), Elements.buildElement(type), (MethodNode)context.getNode());
                    }
                    return new ParameterGenericVisitor(context.getWorkbench(), Elements.buildElement(type), (MethodNode)context.getNode(), context.getParameterIndex());
                }

                public String toString() {
                    return "LegacyGenericVisitorFactory";
                }
            });
            return Collections.singletonList(binding);
        }
        return Collections.emptyList();
    }
}

