/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Selection;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBindingRegistry
implements BindingRegistry {
    private final Map<String, List<Binding>> tree = new HashMap<String, List<Binding>>();
    protected final Reporter reporter;

    public DefaultBindingRegistry(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void addBindings(Iterable<Binding> bindings) {
        for (Binding binding : bindings) {
            Type type = binding.getAnnotationType();
            List<Binding> potential = this.tree.get(type.getDescriptor());
            if (potential == null) {
                potential = new ArrayList<Binding>();
                this.tree.put(type.getDescriptor(), potential);
            }
            potential.add(binding);
        }
    }

    @Override
    public Selection selection(ComponentWorkbench workbench) {
        return new Selection(this, workbench, this.reporter);
    }

    @Override
    public List<Binding> getBindings(String descriptor) {
        List<Binding> bindings = this.tree.get(descriptor);
        if (bindings == null) {
            bindings = Collections.emptyList();
        }
        return bindings;
    }
}

