/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulator.metadata.annotation.stereotype.replay.RootAnnotationRecorder;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationRegistry {
    private Map<Type, List<RootAnnotationRecorder>> stereotypes = new HashMap<Type, List<RootAnnotationRecorder>>();
    private List<Type> unbound = new ArrayList<Type>();

    public void addStereotype(Type type, List<RootAnnotationRecorder> recorders) {
        this.stereotypes.put(type, recorders);
    }

    public void addUnbound(Type type) {
        this.unbound.add(type);
    }

    public List<RootAnnotationRecorder> getRecorders(Type type) {
        List<RootAnnotationRecorder> recorders = this.stereotypes.get(type);
        if (recorders == null) {
            return Collections.emptyList();
        }
        return recorders;
    }

    public boolean isStereotype(Type type) {
        return this.stereotypes.get(type) != null;
    }

    public boolean isUnbound(Type type) {
        return this.unbound.contains(type);
    }

    public boolean isUnknown(Type type) {
        return !this.isStereotype(type) && !this.isUnbound(type);
    }
}

