/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulation.InnerClassManipulator;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulator.ManipulationResultVisitor;
import org.apache.felix.ipojo.manipulator.ManipulationUnit;
import org.apache.felix.ipojo.manipulator.ManipulationVisitor;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;

public class ManipulationEngine {
    private List<ManipulationUnit> m_manipulationUnits = new ArrayList<ManipulationUnit>();
    private Reporter m_reporter;
    private ResourceStore m_store;
    private ManipulationVisitor m_manipulationVisitor;

    public void addManipulationUnit(ManipulationUnit component) {
        this.m_manipulationUnits.add(component);
    }

    public void setManipulationVisitor(ManipulationVisitor manipulationVisitor) {
        this.m_manipulationVisitor = manipulationVisitor;
    }

    public void setReporter(Reporter reporter) {
        this.m_reporter = reporter;
    }

    public void setResourceStore(ResourceStore store) {
        this.m_store = store;
    }

    public void generate() {
        for (ManipulationUnit info : this.m_manipulationUnits) {
            byte[] bytecode;
            try {
                bytecode = this.m_store.read(info.getResourcePath());
            }
            catch (IOException e) {
                this.m_reporter.error("Cannot find bytecode for class '" + info.getClassName() + "': no bytecode found.", new Object[0]);
                return;
            }
            ManipulationResultVisitor result = this.m_manipulationVisitor.visitManipulationResult(info.getComponentMetadata());
            if (result == null) continue;
            Manipulator manipulator = new Manipulator();
            try {
                byte[] out = manipulator.manipulate(bytecode);
                result.visitClassStructure(manipulator.getManipulationMetadata());
                result.visitManipulatedResource(info.getResourcePath(), out);
            }
            catch (IOException e) {
                this.m_reporter.error("Cannot manipulate the class " + info.getClassName() + " : " + e.getMessage(), new Object[0]);
                return;
            }
            for (String inner : manipulator.getInnerClasses()) {
                byte[] innerClassBytecode;
                String resourcePath = inner + ".class";
                String outerClassInternalName = info.getClassName().replace('.', '/');
                try {
                    innerClassBytecode = this.m_store.read(resourcePath);
                }
                catch (IOException e) {
                    this.m_reporter.error("Cannot find inner class '" + resourcePath + "'", new Object[0]);
                    return;
                }
                try {
                    InnerClassManipulator innerManipulator = new InnerClassManipulator(outerClassInternalName, manipulator.getFields().keySet());
                    byte[] manipulated = innerManipulator.manipulate(innerClassBytecode, manipulator.getClassVersion());
                    result.visitManipulatedResource(resourcePath, manipulated);
                }
                catch (IOException e) {
                    this.m_reporter.error("Cannot manipulate inner class '" + resourcePath + "'", new Object[0]);
                    return;
                }
            }
            result.visitEnd();
        }
    }
}

