/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.MethodCreator;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manipulator {
    private Map<String, String> m_fields;
    private List<String> m_interfaces;
    private List<MethodDescriptor> m_methods;
    private String m_superClass;
    private List<String> m_inners;
    private int m_version;

    public byte[] manipulate(byte[] origin) throws IOException {
        ByteArrayInputStream is1 = new ByteArrayInputStream(origin);
        ClassReader ckReader = new ClassReader(is1);
        ClassChecker ck = new ClassChecker();
        ckReader.accept(ck, 4);
        ((InputStream)is1).close();
        this.m_fields = ck.getFields();
        this.m_interfaces = ck.getInterfaces();
        this.m_superClass = ck.getSuperClass();
        this.m_methods = ck.getMethods();
        this.m_inners = ck.getInnerClasses();
        this.m_version = ck.getClassVersion();
        ClassWriter finalWriter = null;
        if (!ck.isalreadyManipulated()) {
            ByteArrayInputStream is2 = new ByteArrayInputStream(origin);
            ClassReader cr0 = new ClassReader(is2);
            ClassWriter cw0 = new ClassWriter(1);
            MethodCreator preprocess = new MethodCreator(cw0, this.m_fields, this.m_methods);
            if (ck.getClassVersion() >= 50) {
                cr0.accept(preprocess, 8);
            } else {
                cr0.accept(preprocess, 0);
            }
            ((InputStream)is2).close();
            finalWriter = cw0;
        }
        if (ck.isalreadyManipulated()) {
            return origin;
        }
        return finalWriter.toByteArray();
    }

    public Element getManipulationMetadata() {
        Element elem = new Element("Manipulation", "");
        if (this.m_superClass != null) {
            elem.addAttribute(new Attribute("super", this.m_superClass));
        }
        for (int j = 0; j < this.m_interfaces.size(); ++j) {
            Element itf = new Element("Interface", "");
            Attribute att = new Attribute("name", this.m_interfaces.get(j).toString());
            itf.addAttribute(att);
            elem.addElement(itf);
        }
        Iterator<String> it = this.m_fields.keySet().iterator();
        while (it.hasNext()) {
            Element field = new Element("Field", "");
            String name = it.next();
            String type = this.m_fields.get(name);
            Attribute attName = new Attribute("name", name);
            Attribute attType = new Attribute("type", type);
            field.addAttribute(attName);
            field.addAttribute(attType);
            elem.addElement(field);
        }
        for (int j = 0; j < this.m_methods.size(); ++j) {
            MethodDescriptor method = this.m_methods.get(j);
            elem.addElement(method.getElement());
        }
        return elem;
    }

    public Map<String, String> getFields() {
        return this.m_fields;
    }

    public List<String> getInnerClasses() {
        return this.m_inners;
    }

    public int getClassVersion() {
        return this.m_version;
    }
}

