/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.felix.ipojo.ComponentFactory;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.composite.CompositeManager;
import org.apache.felix.ipojo.composite.instance.InstanceHandler;
import org.apache.felix.ipojo.composite.service.provides.CompositionException;
import org.apache.felix.ipojo.composite.service.provides.CompositionMetadata;
import org.apache.felix.ipojo.composite.service.provides.FieldMetadata;
import org.apache.felix.ipojo.composite.service.provides.ProvidedServiceHandler;
import org.apache.felix.ipojo.composite.service.provides.ServiceExporter;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class ProvidedService
implements DependencyStateListener {
    private CompositeManager m_manager;
    private CompositionMetadata m_composition;
    private ServiceContext m_scope;
    private BundleContext m_context;
    private ComponentFactory m_factory;
    private ComponentInstance m_instance;
    private ServiceExporter m_exports;
    private String m_instanceName;

    public ProvidedService(ProvidedServiceHandler handler, Element element, String name) {
        this.m_manager = handler.getCompositeManager();
        this.m_scope = this.m_manager.getServiceContext();
        this.m_context = this.m_manager.getContext();
        this.m_composition = new CompositionMetadata(this.m_manager.getContext(), element, handler, name);
    }

    public void start() throws CompositionException {
        this.m_composition.buildMapping();
        this.m_instanceName = this.m_composition.getSpecificationMetadata().getName() + "Provider-Gen";
        byte[] clazz = this.m_composition.buildPOJO();
        Element metadata = this.m_composition.buildMetadata(this.m_instanceName);
        try {
            this.m_factory = new ComponentFactory(this.m_context, clazz, metadata);
            this.m_factory.start();
        }
        catch (ConfigurationException e) {
            this.m_manager.getFactory().getLogger().log(1, "A factory cannot be created", (Throwable)e);
        }
        try {
            Class spec = DependencyModel.loadSpecification((String)this.m_composition.getSpecificationMetadata().getName(), (BundleContext)this.m_context);
            Filter filter = this.m_context.createFilter("(instance.name=" + this.m_instanceName + ")");
            this.m_exports = new ServiceExporter(spec, filter, false, false, null, 0, this.m_scope, this.m_context, this, this.m_manager);
        }
        catch (InvalidSyntaxException e) {
            throw new CompositionException("A provided service filter is invalid : " + e.getMessage());
        }
        catch (ConfigurationException e) {
            throw new CompositionException("The class " + this.m_composition.getSpecificationMetadata().getName() + " cannot be loaded : " + e.getMessage());
        }
    }

    public void stop() {
        if (this.m_exports != null) {
            this.m_exports.stop();
            this.m_exports = null;
        }
        if (this.m_instance != null) {
            this.m_instance.dispose();
            this.m_instance = null;
        }
        if (this.m_factory != null) {
            this.m_factory.stop();
            this.m_factory = null;
        }
    }

    protected CompositeManager getManager() {
        return this.m_manager;
    }

    public void validate(DependencyModel exporter) {
    }

    public void invalidate(DependencyModel exporter) {
    }

    private Object getObjectByType(String type) {
        InstanceHandler handler = (InstanceHandler)this.m_manager.getCompositeHandler("org.apache.felix.ipojo.composite.instance.InstanceHandler");
        Object pojo = handler.getObjectFromInstance(type);
        if (pojo == null) {
            this.m_manager.getFactory().getLogger().log(1, "An instance object cannot be found for the type : " + type);
        }
        return pojo;
    }

    public String getSpecification() {
        return this.m_composition.getSpecificationMetadata().getName();
    }

    public void unregister() {
        this.m_exports.stop();
    }

    public void register() {
        Properties props = new Properties();
        props.put("name", this.m_instanceName);
        List fields = this.m_composition.getFieldList();
        for (int i = 0; i < fields.size(); ++i) {
            FieldMetadata field = (FieldMetadata)fields.get(i);
            if (!field.isUseful() || field.getSpecification().isInterface()) continue;
            String type = field.getSpecification().getComponentType();
            Object pojo = this.getObjectByType(type);
            props.put(field.getName(), pojo);
        }
        if (this.m_instance == null) {
            try {
                this.m_instance = this.m_factory.createComponentInstance((Dictionary)props, this.m_manager.getServiceContext());
            }
            catch (UnacceptableConfiguration e) {
                throw new IllegalStateException("Cannot create the service implementation : " + e.getMessage());
            }
            catch (MissingHandlerException e) {
                throw new IllegalStateException("Cannot create the service implementation : " + e.getMessage());
            }
            catch (ConfigurationException e) {
                throw new IllegalStateException("Cannot create the service implementation : " + e.getMessage());
            }
        } else {
            this.m_instance.reconfigure((Dictionary)props);
        }
        this.m_exports.start();
    }

    public boolean isRegistered() {
        return this.m_exports.getState() == 1;
    }
}

