/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.provides;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.felix.ipojo.composite.service.provides.FieldMetadata;
import org.apache.felix.ipojo.composite.service.provides.MethodMetadata;
import org.apache.felix.ipojo.composite.service.provides.SpecificationMetadata;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class POJOWriter
implements Opcodes {
    private static void createClass(ClassWriter cw, String className, String spec) {
        cw.visit(46, 33, className, null, "java/lang/Object", new String[]{spec.replace('.', '/')});
    }

    private static void injectFields(ClassWriter cw, List fields) {
        for (int i = 0; i < fields.size(); ++i) {
            FieldMetadata field = (FieldMetadata)fields.get(i);
            if (!field.isUseful()) continue;
            SpecificationMetadata spec = field.getSpecification();
            String fieldName = field.getName();
            String desc = "";
            desc = field.isAggregate() ? "[L" + spec.getName().replace('.', '/') + ";" : "L" + spec.getName().replace('.', '/') + ";";
            cw.visitField(2, fieldName, desc, null, null);
        }
    }

    public static byte[] dump(Class clazz, String className, List fields, List methods) {
        Method[] itfmethods = clazz.getMethods();
        ClassWriter cw = new ClassWriter(1);
        className = className.replace('.', '/');
        POJOWriter.createClass(cw, className, clazz.getName());
        POJOWriter.injectFields(cw, fields);
        MethodVisitor cst = cw.visitMethod(1, "<init>", "()V", null, null);
        cst.visitVarInsn(25, 0);
        cst.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        cst.visitInsn(177);
        cst.visitMaxs(0, 0);
        cst.visitEnd();
        for (int i = 0; i < itfmethods.length; ++i) {
            Method method = itfmethods[i];
            FieldMetadata delegator = null;
            MethodMetadata methodDelegator = null;
            for (int j = 0; j < methods.size(); ++j) {
                MethodMetadata methodMeta = (MethodMetadata)methods.get(j);
                if (!methodMeta.equals(method)) continue;
                delegator = methodMeta.getDelegation();
                methodDelegator = methodMeta;
            }
            POJOWriter.generateOneMethod(cw, className, methodDelegator, method, delegator);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private static void generateOneMethod(ClassWriter cw, String className, MethodMetadata method, Method sign, FieldMetadata delegator) {
        String desc = Type.getMethodDescriptor(sign);
        String name = sign.getName();
        String[] exc = new String[sign.getExceptionTypes().length];
        for (int i = 0; i < sign.getExceptionTypes().length; ++i) {
            exc[i] = Type.getType(sign.getExceptionTypes()[i]).getInternalName();
        }
        MethodVisitor mv = cw.visitMethod(1, name, desc, null, exc);
        if (delegator.isOptional()) {
            if (!delegator.isAggregate()) {
                POJOWriter.generateOptionalCase(mv, delegator, className);
            }
            if (delegator.isAggregate()) {
                POJOWriter.generateOptionalAggregateCase(mv, delegator, className);
            }
        }
        if (delegator.isAggregate()) {
            if (method.getPolicy() == 1) {
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, delegator.getName(), "[L" + delegator.getSpecification().getName().replace('.', '/') + ";");
                mv.visitInsn(3);
                mv.visitInsn(50);
                Type[] args = Type.getArgumentTypes(desc);
                for (int i = 0; i < args.length; ++i) {
                    POJOWriter.writeLoad(args[i], i + 1, mv);
                }
                mv.visitMethodInsn(185, delegator.getSpecification().getName().replace('.', '/'), name, desc);
                POJOWriter.writeReturn(Type.getReturnType(desc), mv);
            } else {
                if (Type.getReturnType(desc).getSort() != 0) {
                    System.err.println("All policy cannot be used on method which does not return void");
                }
                Type[] args = Type.getArgumentTypes(desc);
                int index = args.length + 1;
                mv.visitInsn(3);
                mv.visitVarInsn(54, index);
                Label l1b = new Label();
                mv.visitLabel(l1b);
                Label l2b = new Label();
                mv.visitJumpInsn(167, l2b);
                Label l3b = new Label();
                mv.visitLabel(l3b);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, delegator.getName(), "[L" + delegator.getSpecification().getName().replace('.', '/') + ";");
                mv.visitVarInsn(21, index);
                mv.visitInsn(50);
                for (int i = 0; i < args.length; ++i) {
                    POJOWriter.writeLoad(args[i], i + 1, mv);
                }
                mv.visitMethodInsn(185, delegator.getSpecification().getName().replace('.', '/'), name, desc);
                Label l4b = new Label();
                mv.visitLabel(l4b);
                mv.visitIincInsn(index, 1);
                mv.visitLabel(l2b);
                mv.visitVarInsn(21, index);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, className, delegator.getName(), "[L" + delegator.getSpecification().getName().replace('.', '/') + ";");
                mv.visitInsn(190);
                mv.visitJumpInsn(161, l3b);
                Label l5b = new Label();
                mv.visitLabel(l5b);
                mv.visitInsn(177);
            }
        } else {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, className, delegator.getName(), "L" + delegator.getSpecification().getName().replace('.', '/') + ";");
            Type[] args = Type.getArgumentTypes(desc);
            for (int i = 0; i < args.length; ++i) {
                POJOWriter.writeLoad(args[i], i + 1, mv);
            }
            if (delegator.getSpecification().isInterface()) {
                mv.visitMethodInsn(185, delegator.getSpecification().getName().replace('.', '/'), name, desc);
            } else {
                mv.visitMethodInsn(182, delegator.getSpecification().getName().replace('.', '/'), name, desc);
            }
            POJOWriter.writeReturn(Type.getReturnType(desc), mv);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void generateOptionalAggregateCase(MethodVisitor mv, FieldMetadata delegator, String className) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, delegator.getName(), "[L" + delegator.getSpecification().getName().replace('.', '/') + ";");
        mv.visitInsn(190);
        Label l1a = new Label();
        mv.visitJumpInsn(154, l1a);
        Label l2a = new Label();
        mv.visitLabel(l2a);
        mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Operation not supported");
        mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitLabel(l1a);
    }

    private static void generateOptionalCase(MethodVisitor mv, FieldMetadata delegator, String className) {
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, className, delegator.getName(), "L" + delegator.getSpecification().getName().replace('.', '/') + ";");
        mv.visitTypeInsn(193, "org/apache/felix/ipojo/Nullable");
        Label end = new Label();
        mv.visitJumpInsn(153, end);
        Label begin = new Label();
        mv.visitLabel(begin);
        mv.visitTypeInsn(187, "java/lang/UnsupportedOperationException");
        mv.visitInsn(89);
        mv.visitLdcInsn("Operation not supported");
        mv.visitMethodInsn(183, "java/lang/UnsupportedOperationException", "<init>", "(Ljava/lang/String;)V");
        mv.visitInsn(191);
        mv.visitLabel(end);
    }

    private static void writeReturn(Type t, MethodVisitor mv) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitInsn(172);
                break;
            }
            case 7: {
                mv.visitInsn(173);
                break;
            }
            case 8: {
                mv.visitInsn(175);
                break;
            }
            case 6: {
                mv.visitInsn(174);
                break;
            }
            case 9: 
            case 10: {
                mv.visitInsn(176);
                break;
            }
            case 0: {
                mv.visitInsn(177);
                break;
            }
            default: {
                System.err.println("Type not yet managed : " + t);
            }
        }
    }

    private static void writeLoad(Type t, int index, MethodVisitor mv) {
        switch (t.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                mv.visitVarInsn(21, index);
                break;
            }
            case 7: {
                mv.visitVarInsn(22, index);
                break;
            }
            case 6: {
                mv.visitVarInsn(23, index);
                break;
            }
            case 8: {
                mv.visitVarInsn(24, index);
                break;
            }
            case 9: 
            case 10: {
                mv.visitVarInsn(25, index);
                break;
            }
            default: {
                System.err.println("Type not yet managed : " + t);
            }
        }
    }
}

