/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Util;
import org.apache.felix.utils.collections.DictionaryAsMap;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

public class ConfigInstaller
implements ArtifactInstaller,
ConfigurationListener {
    private final BundleContext context;
    private final ConfigurationAdmin configAdmin;
    private final FileInstall fileInstall;
    private ServiceRegistration registration;
    static /* synthetic */ Class class$org$osgi$service$cm$ConfigurationListener;
    static /* synthetic */ Class class$org$apache$felix$fileinstall$ArtifactListener;
    static /* synthetic */ Class class$org$apache$felix$fileinstall$ArtifactInstaller;

    ConfigInstaller(BundleContext context, ConfigurationAdmin configAdmin, FileInstall fileInstall) {
        this.context = context;
        this.configAdmin = configAdmin;
        this.fileInstall = fileInstall;
    }

    public void init() {
        if (this.registration == null) {
            Properties props = new Properties();
            this.registration = this.context.registerService(new String[]{(class$org$osgi$service$cm$ConfigurationListener == null ? (class$org$osgi$service$cm$ConfigurationListener = ConfigInstaller.class$("org.osgi.service.cm.ConfigurationListener")) : class$org$osgi$service$cm$ConfigurationListener).getName(), (class$org$apache$felix$fileinstall$ArtifactListener == null ? (class$org$apache$felix$fileinstall$ArtifactListener = ConfigInstaller.class$("org.apache.felix.fileinstall.ArtifactListener")) : class$org$apache$felix$fileinstall$ArtifactListener).getName(), (class$org$apache$felix$fileinstall$ArtifactInstaller == null ? (class$org$apache$felix$fileinstall$ArtifactInstaller = ConfigInstaller.class$("org.apache.felix.fileinstall.ArtifactInstaller")) : class$org$apache$felix$fileinstall$ArtifactInstaller).getName()}, (Object)this, (Dictionary)props);
        }
    }

    public void destroy() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public boolean canHandle(File artifact) {
        return artifact.getName().endsWith(".cfg") || artifact.getName().endsWith(".config");
    }

    public void install(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void update(File artifact) throws Exception {
        this.setConfig(artifact);
    }

    public void uninstall(File artifact) throws Exception {
        this.deleteConfig(artifact);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurationEvent(ConfigurationEvent configurationEvent) {
        block12: {
            if (!this.shouldSaveConfig()) {
                return;
            }
            if (configurationEvent.getType() == 1) {
                try {
                    File file;
                    Configuration config = this.getConfigurationAdmin().getConfiguration(configurationEvent.getPid(), configurationEvent.getFactoryPid());
                    Dictionary dict = config.getProperties();
                    String fileName = (String)dict.get("felix.fileinstall.filename");
                    File file2 = file = fileName != null ? this.fromConfigKey(fileName) : null;
                    if (file == null || !file.isFile()) break block12;
                    if (fileName.endsWith(".cfg")) {
                        org.apache.felix.utils.properties.Properties props = new org.apache.felix.utils.properties.Properties(file);
                        Enumeration e = dict.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                            String val = dict.get(key).toString();
                            props.put(key, val);
                        }
                        props.save();
                    } else if (fileName.endsWith(".config")) {
                        FileOutputStream fos = new FileOutputStream(file);
                        Properties props = new Properties();
                        Enumeration e = dict.keys();
                        while (e.hasMoreElements()) {
                            String key = e.nextElement().toString();
                            if ("service.pid".equals(key) || "service.factoryPid".equals(key) || "felix.fileinstall.filename".equals(key)) continue;
                            props.put(key, dict.get(key));
                        }
                        try {
                            ConfigurationHandler.write(fos, props);
                        }
                        finally {
                            ((OutputStream)fos).close();
                        }
                    }
                    this.fileInstall.updateChecksum(file);
                }
                catch (Exception e) {
                    Util.log(this.context, Util.getGlobalLogLevel(this.context), 3, "Unable to save configuration", e);
                }
            }
        }
    }

    boolean shouldSaveConfig() {
        Object obj = this.context.getProperty("felix.fileinstall.enableConfigSave");
        if (obj instanceof String) {
            obj = Boolean.valueOf((String)obj);
        }
        if (Boolean.FALSE.equals(obj)) {
            return false;
        }
        if (!Boolean.TRUE.equals(obj)) {
            obj = this.context.getProperty("felix.fileinstall.disableConfigSave");
            if (obj instanceof String) {
                obj = Boolean.valueOf((String)obj);
            }
            if (Boolean.FALSE.equals(obj)) {
                return false;
            }
        }
        return true;
    }

    ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setConfig(File f) throws Exception {
        Hashtable old;
        Hashtable<Object, Object> ht = new Hashtable<Object, Object>();
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
        try {
            if (f.getName().endsWith(".cfg")) {
                Properties p = new Properties();
                ((InputStream)in).mark(1);
                boolean isXml = ((InputStream)in).read() == 60;
                ((InputStream)in).reset();
                if (isXml) {
                    p.loadFromXML(in);
                } else {
                    p.load(in);
                }
                InterpolationHelper.performSubstitution(p, this.context);
                ht.putAll(p);
            } else if (f.getName().endsWith(".config")) {
                Dictionary config = ConfigurationHandler.read(in);
                Enumeration i = config.keys();
                while (i.hasMoreElements()) {
                    Object key = i.nextElement();
                    ht.put(key, config.get(key));
                }
            }
        }
        finally {
            ((InputStream)in).close();
        }
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        Dictionary props = config.getProperties();
        Hashtable hashtable = old = props != null ? new Hashtable(new DictionaryAsMap(props)) : null;
        if (old != null) {
            old.remove("felix.fileinstall.filename");
            old.remove("service.pid");
            old.remove("service.factoryPid");
        }
        if (!ht.equals(old)) {
            ht.put("felix.fileinstall.filename", this.toConfigKey(f));
            if (config.getBundleLocation() != null) {
                config.setBundleLocation(null);
            }
            config.update(ht);
            return true;
        }
        return false;
    }

    boolean deleteConfig(File f) throws Exception {
        String[] pid = this.parsePid(f.getName());
        Configuration config = this.getConfiguration(this.toConfigKey(f), pid[0], pid[1]);
        config.delete();
        return true;
    }

    String toConfigKey(File f) {
        return f.getAbsoluteFile().toURI().toString();
    }

    File fromConfigKey(String key) {
        return new File(URI.create(key));
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.lastIndexOf(46));
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    Configuration getConfiguration(String fileName, String pid, String factoryPid) throws Exception {
        Configuration oldConfiguration = this.findExistingConfiguration(fileName);
        if (oldConfiguration != null) {
            Util.log(this.context, Util.getGlobalLogLevel(this.context), 4, "Updating configuration from " + pid + (factoryPid == null ? "" : "-" + factoryPid) + ".cfg", null);
            return oldConfiguration;
        }
        Configuration newConfiguration = factoryPid != null ? this.getConfigurationAdmin().createFactoryConfiguration(pid, null) : this.getConfigurationAdmin().getConfiguration(pid, null);
        return newConfiguration;
    }

    Configuration findExistingConfiguration(String fileName) throws Exception {
        String filter = "(felix.fileinstall.filename=" + this.escapeFilterValue(fileName) + ")";
        Configuration[] configurations = this.getConfigurationAdmin().listConfigurations(filter);
        if (configurations != null && configurations.length > 0) {
            return configurations[0];
        }
        return null;
    }

    private String escapeFilterValue(String s) {
        return s.replaceAll("[(]", "\\\\(").replaceAll("[)]", "\\\\)").replaceAll("[=]", "\\\\=").replaceAll("[\\*]", "\\\\*");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

