/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.felix.fileinstall.ArtifactListener;
import org.apache.felix.fileinstall.ArtifactTransformer;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.fileinstall.internal.Artifact;
import org.apache.felix.fileinstall.internal.FileInstall;
import org.apache.felix.fileinstall.internal.Scanner;
import org.apache.felix.fileinstall.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.PackageAdmin;

public class DirectoryWatcher
extends Thread
implements BundleListener {
    public static final String FILENAME = "felix.fileinstall.filename";
    public static final String POLL = "felix.fileinstall.poll";
    public static final String DIR = "felix.fileinstall.dir";
    public static final String LOG_LEVEL = "felix.fileinstall.log.level";
    public static final String TMPDIR = "felix.fileinstall.tmpdir";
    public static final String FILTER = "felix.fileinstall.filter";
    public static final String START_NEW_BUNDLES = "felix.fileinstall.bundles.new.start";
    public static final String USE_START_TRANSIENT = "felix.fileinstall.bundles.startTransient";
    public static final String NO_INITIAL_DELAY = "felix.fileinstall.noInitialDelay";
    public static final String START_LEVEL = "felix.fileinstall.start.level";
    static final SecureRandom random = new SecureRandom();
    static final File javaIoTmpdir = new File(System.getProperty("java.io.tmpdir"));
    Dictionary properties;
    File watchedDirectory;
    File tmpDir;
    long poll;
    int logLevel;
    boolean startBundles;
    boolean useStartTransient;
    String filter;
    BundleContext context;
    String originatingFileName;
    boolean noInitialDelay;
    int startLevel;
    Map currentManagedArtifacts = new HashMap();
    Scanner scanner;
    Set processingFailures = new HashSet();
    Map installationFailures = new HashMap();

    public DirectoryWatcher(Dictionary properties, BundleContext context) {
        super("fileinstall-" + DirectoryWatcher.getThreadName(properties));
        this.properties = properties;
        this.context = context;
        this.poll = this.getLong(properties, POLL, 2000L);
        this.logLevel = this.getInt(properties, LOG_LEVEL, 0);
        this.originatingFileName = (String)properties.get(FILENAME);
        this.watchedDirectory = this.getFile(properties, DIR, new File("./load"));
        this.verifyWatchedDir();
        this.tmpDir = this.getFile(properties, TMPDIR, null);
        this.prepareTempDir();
        this.startBundles = this.getBoolean(properties, START_NEW_BUNDLES, true);
        this.useStartTransient = this.getBoolean(properties, USE_START_TRANSIENT, false);
        this.filter = (String)properties.get(FILTER);
        this.noInitialDelay = this.getBoolean(properties, NO_INITIAL_DELAY, false);
        this.startLevel = this.getInt(properties, START_LEVEL, 0);
        this.context.addBundleListener((BundleListener)this);
        FilenameFilter flt = this.filter != null && this.filter.length() > 0 ? new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(DirectoryWatcher.this.filter);
            }
        } : null;
        this.scanner = new Scanner(this.watchedDirectory, flt);
    }

    private void verifyWatchedDir() {
        if (!this.watchedDirectory.exists()) {
            this.log(2, this.watchedDirectory + " does not exist, please create it.", null);
        } else if (!this.watchedDirectory.isDirectory()) {
            this.log(1, "Cannot use " + this.watchedDirectory + " because it's not a directory", null);
            throw new RuntimeException("File Install can't monitor " + this.watchedDirectory + " because it is not a directory");
        }
    }

    public static String getThreadName(Dictionary properties) {
        return (properties.get(DIR) != null ? properties.get(DIR) : "./load").toString();
    }

    public Dictionary getProperties() {
        return this.properties;
    }

    public void start() {
        if (this.noInitialDelay) {
            this.log(4, "Starting initial scan", null);
            this.initializeCurrentManagedBundles();
            Set files = this.scanner.scan(true);
            if (files != null) {
                this.process(files);
            }
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log(4, "{felix.fileinstall.poll (ms) = " + this.poll + ", " + DIR + " = " + this.watchedDirectory.getAbsolutePath() + ", " + LOG_LEVEL + " = " + this.logLevel + ", " + START_NEW_BUNDLES + " = " + this.startBundles + ", " + TMPDIR + " = " + this.tmpDir + ", " + FILTER + " = " + this.filter + ", " + START_LEVEL + " = " + this.startLevel + "}", null);
        if (!this.noInitialDelay) {
            this.initializeCurrentManagedBundles();
        }
        while (!DirectoryWatcher.interrupted()) {
            try {
                Object files;
                if (FileInstall.getStartLevel().getStartLevel() >= this.startLevel && (files = this.scanner.scan(false)) != null) {
                    this.process((Set)files);
                }
                files = this;
                synchronized (files) {
                    this.wait(this.poll);
                }
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Throwable e) {
                try {
                    this.context.getBundle();
                }
                catch (IllegalStateException t) {
                    return;
                }
                this.log(1, "In main loop, we have serious trouble", e);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() == 16) {
            Iterator it = this.currentManagedArtifacts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Artifact artifact = (Artifact)entry.getValue();
                if (artifact.getBundleId() != bundleEvent.getBundle().getBundleId()) continue;
                this.log(4, "Bundle " + bundleEvent.getBundle().getBundleId() + " has been uninstalled", null);
                this.currentManagedArtifacts.remove(entry.getKey());
                break;
            }
        }
    }

    private void process(Set files) {
        List listeners = FileInstall.getListeners();
        ArrayList<Artifact> deleted = new ArrayList<Artifact>();
        ArrayList<Artifact> modified = new ArrayList<Artifact>();
        ArrayList<Artifact> created = new ArrayList<Artifact>();
        files.addAll(this.processingFailures);
        this.processingFailures.clear();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            ArtifactListener listener;
            File file = (File)it.next();
            boolean exists = file.exists();
            Artifact artifact = (Artifact)this.currentManagedArtifacts.get(file);
            if (!exists) {
                if (artifact == null) continue;
                this.deleteJaredDirectory(artifact);
                this.deleteTransformedFile(artifact);
                deleted.add(artifact);
                continue;
            }
            File jar = file;
            URL jaredUrl = null;
            try {
                jaredUrl = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
            if (file.isDirectory()) {
                this.prepareTempDir();
                try {
                    jar = new File(this.tmpDir, file.getName() + ".jar");
                    Util.jarDir(file, jar);
                    jaredUrl = new URL("jardir", null, file.getPath());
                }
                catch (IOException e) {
                    this.log(2, "Unable to create jar for: " + file.getAbsolutePath(), e);
                    continue;
                }
            }
            if (artifact != null) {
                artifact.setChecksum(this.scanner.getChecksum(file));
                if (artifact.getListener() == null) {
                    listener = this.findListener(jar, listeners);
                    if (listener == null) {
                        this.processingFailures.add(file);
                        continue;
                    }
                    artifact.setListener(listener);
                }
                if (!listeners.contains(artifact.getListener()) || !artifact.getListener().canHandle(jar)) {
                    deleted.add(artifact);
                    artifact = null;
                    continue;
                }
                this.deleteTransformedFile(artifact);
                artifact.setJaredDirectory(jar);
                artifact.setJaredUrl(jaredUrl);
                if (this.transformArtifact(artifact)) {
                    modified.add(artifact);
                    continue;
                }
                this.deleteJaredDirectory(artifact);
                deleted.add(artifact);
                continue;
            }
            listener = this.findListener(jar, listeners);
            if (listener == null) {
                this.processingFailures.add(file);
                continue;
            }
            artifact = new Artifact();
            artifact.setPath(file);
            artifact.setJaredDirectory(jar);
            artifact.setJaredUrl(jaredUrl);
            artifact.setListener(listener);
            artifact.setChecksum(this.scanner.getChecksum(file));
            if (this.transformArtifact(artifact)) {
                created.add(artifact);
                continue;
            }
            this.deleteJaredDirectory(artifact);
        }
        Collection uninstalledBundles = this.uninstall(deleted);
        Collection updatedBundles = this.update(modified);
        Collection installedBundles = this.install(created);
        if (uninstalledBundles.size() > 0 || updatedBundles.size() > 0) {
            this.refresh();
        }
        if (this.startBundles || this.startLevel != 0) {
            this.processAllBundles();
            this.process(installedBundles);
        }
    }

    ArtifactListener findListener(File artifact, List listeners) {
        Iterator itL = listeners.iterator();
        while (itL.hasNext()) {
            ArtifactListener listener = (ArtifactListener)itL.next();
            if (!listener.canHandle(artifact)) continue;
            return listener;
        }
        return null;
    }

    boolean transformArtifact(Artifact artifact) {
        if (artifact.getListener() instanceof ArtifactTransformer) {
            this.prepareTempDir();
            try {
                File transformed = ((ArtifactTransformer)artifact.getListener()).transform(artifact.getJaredDirectory(), this.tmpDir);
                if (transformed != null) {
                    artifact.setTransformed(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        if (artifact.getListener() instanceof ArtifactUrlTransformer) {
            try {
                URL url = artifact.getJaredUrl();
                URL transformed = ((ArtifactUrlTransformer)artifact.getListener()).transform(url);
                if (transformed != null) {
                    artifact.setTransformedUrl(transformed);
                    return true;
                }
            }
            catch (Exception e) {
                this.log(2, "Unable to transform artifact: " + artifact.getPath().getAbsolutePath(), e);
            }
            return false;
        }
        return true;
    }

    private void deleteTransformedFile(Artifact artifact) {
        if (artifact.getTransformed() != null && !artifact.getTransformed().equals(artifact.getPath()) && !artifact.getTransformed().delete()) {
            this.log(2, "Unable to delete transformed artifact: " + artifact.getTransformed().getAbsolutePath(), null);
        }
    }

    private void deleteJaredDirectory(Artifact artifact) {
        if (artifact.getJaredDirectory() != null && !artifact.getJaredDirectory().equals(artifact.getPath()) && !artifact.getJaredDirectory().delete()) {
            this.log(2, "Unable to delete jared artifact: " + artifact.getJaredDirectory().getAbsolutePath(), null);
        }
    }

    private void prepareTempDir() {
        if (this.tmpDir == null) {
            File f;
            while ((f = new File(javaIoTmpdir, "fileinstall-" + Long.toString(random.nextLong()))).exists() || !f.mkdirs()) {
            }
            this.tmpDir = f;
            this.tmpDir.deleteOnExit();
        } else {
            this.prepareDir(this.tmpDir);
        }
    }

    private void prepareDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            this.log(1, "Cannot create folder " + dir + ". Is the folder write-protected?", null);
            throw new RuntimeException("Cannot create folder: " + dir);
        }
        if (!dir.isDirectory()) {
            this.log(1, "Cannot use " + dir + " because it's not a directory", null);
            throw new RuntimeException("Cannot start FileInstall using something that is not a directory");
        }
    }

    void log(int msgLevel, String message, Throwable e) {
        Util.log(this.context, this.logLevel, msgLevel, message, e);
    }

    boolean isFragment(Bundle bundle) {
        PackageAdmin padmin = FileInstall.getPackageAdmin();
        if (padmin != null) {
            return padmin.getBundleType(bundle) == 1;
        }
        return false;
    }

    void refresh() {
        PackageAdmin padmin = FileInstall.getPackageAdmin();
        if (padmin != null) {
            padmin.refreshPackages(null);
        }
    }

    int getInt(Dictionary properties, String property, int dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a int: " + value, null);
            }
        }
        return dflt;
    }

    long getLong(Dictionary properties, String property, long dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception e) {
                this.log(2, property + " set, but not a long: " + value, null);
            }
        }
        return dflt;
    }

    File getFile(Dictionary properties, String property, File dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return new File(value);
        }
        return dflt;
    }

    boolean getBoolean(Dictionary properties, String property, boolean dflt) {
        String value = (String)properties.get(property);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return dflt;
    }

    public void close() {
        this.context.removeBundleListener((BundleListener)this);
        this.interrupt();
        Iterator iter = this.currentManagedArtifacts.values().iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            this.deleteTransformedFile(artifact);
            this.deleteJaredDirectory(artifact);
        }
        try {
            this.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initializeCurrentManagedBundles() {
        Bundle[] bundles = this.context.getBundles();
        String watchedDirPath = this.watchedDirectory.toURI().normalize().getPath();
        HashMap<File, Long> checksums = new HashMap<File, Long>();
        for (int i = 0; i < bundles.length; ++i) {
            int index;
            String location = bundles[i].getLocation();
            String path = null;
            if (location != null && !location.equals("System Bundle")) {
                URI uri;
                try {
                    uri = new URI(bundles[i].getLocation()).normalize();
                }
                catch (URISyntaxException e) {
                    uri = new File(location).toURI().normalize();
                }
                path = uri.getPath();
            }
            if (path == null || (index = path.lastIndexOf(47)) == -1 || !path.startsWith(watchedDirPath)) continue;
            Artifact artifact = new Artifact();
            artifact.setBundleId(bundles[i].getBundleId());
            artifact.setChecksum(Util.loadChecksum(bundles[i], this.context));
            artifact.setListener(null);
            artifact.setPath(new File(path));
            this.currentManagedArtifacts.put(new File(path), artifact);
            checksums.put(new File(path), new Long(artifact.getChecksum()));
        }
        this.scanner.initialize(checksums);
    }

    private Collection install(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.install(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection uninstall(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.uninstall(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    private Collection update(Collection artifacts) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            Bundle bundle = this.update(artifact);
            if (bundle == null) continue;
            bundles.add(bundle);
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle install(Artifact artifact) {
        File path = artifact.getPath();
        Bundle bundle = null;
        try {
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).install(path);
            } else if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                Artifact badArtifact = (Artifact)this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                URL transformed = artifact.getTransformedUrl();
                String location = transformed.toString();
                BufferedInputStream in = new BufferedInputStream(transformed.openStream());
                try {
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum());
                }
                finally {
                    in.close();
                }
                artifact.setBundleId(bundle.getBundleId());
            } else if (artifact.getListener() instanceof ArtifactTransformer) {
                Artifact badArtifact = (Artifact)this.installationFailures.get(path);
                if (badArtifact != null && badArtifact.getChecksum() == artifact.getChecksum()) {
                    return null;
                }
                File transformed = artifact.getTransformed();
                String location = path.toURI().normalize().toString();
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(transformed != null ? transformed : path));
                try {
                    bundle = this.installOrUpdateBundle(location, in, artifact.getChecksum());
                }
                finally {
                    in.close();
                }
                artifact.setBundleId(bundle.getBundleId());
            }
            this.installationFailures.remove(path);
            this.currentManagedArtifacts.put(path, artifact);
            this.log(3, "Installed " + path, null);
        }
        catch (Exception e) {
            this.log(2, "Failed to install artifact: " + path, e);
            this.installationFailures.put(path, artifact);
        }
        return bundle;
    }

    private Bundle installOrUpdateBundle(String bundleLocation, BufferedInputStream is, long checksum) throws IOException, BundleException {
        is.mark(262144);
        JarInputStream jar = new JarInputStream(is);
        Manifest m = jar.getManifest();
        if (m == null) {
            throw new BundleException("The bundle " + bundleLocation + " does not have a META-INF/MANIFEST.MF! " + "Make sure, META-INF and MANIFEST.MF are the first 2 entries in your JAR!");
        }
        String sn = m.getMainAttributes().getValue("Bundle-SymbolicName");
        String vStr = m.getMainAttributes().getValue("Bundle-Version");
        Version v = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
        Bundle[] bundles = this.context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Version bv;
            Bundle b = bundles[i];
            if (b.getSymbolicName() == null || !b.getSymbolicName().equals(sn)) continue;
            vStr = (String)b.getHeaders().get("Bundle-Version");
            Version version = bv = vStr == null ? Version.emptyVersion : Version.parseVersion((String)vStr);
            if (!v.equals((Object)bv)) continue;
            is.reset();
            if (Util.loadChecksum(b, this.context) != checksum) {
                this.log(2, "A bundle with the same symbolic name (" + sn + ") and version (" + vStr + ") is already installed.  Updating this bundle instead.", null);
                this.stopTransient(b);
                Util.storeChecksum(b, checksum, this.context);
                b.update((InputStream)is);
            }
            return b;
        }
        is.reset();
        Bundle b = this.context.installBundle(bundleLocation, (InputStream)is);
        Util.storeChecksum(b, checksum, this.context);
        return b;
    }

    private Bundle uninstall(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() == null) {
                artifact.setListener(this.findListener(path, FileInstall.getListeners()));
            }
            this.currentManagedArtifacts.remove(path);
            this.deleteTransformedFile(artifact);
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).uninstall(path);
            } else if (artifact.getBundleId() != 0L) {
                bundle = this.context.getBundle(artifact.getBundleId());
                if (bundle == null) {
                    this.log(2, "Failed to uninstall bundle: " + path + " with id: " + artifact.getBundleId() + ". The bundle has already been uninstalled", null);
                    return null;
                }
                this.log(4, "Uninstalling bundle " + bundle.getBundleId() + " (" + bundle.getSymbolicName() + ")", null);
                bundle.uninstall();
            }
            this.log(3, "Uninstalled " + path, null);
        }
        catch (Exception e) {
            this.log(2, "Failed to uninstall artifact: " + artifact.getPath(), e);
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle update(Artifact artifact) {
        Bundle bundle = null;
        try {
            File path = artifact.getPath();
            if (artifact.getListener() instanceof ArtifactInstaller) {
                ((ArtifactInstaller)artifact.getListener()).update(path);
            } else {
                if (artifact.getListener() instanceof ArtifactUrlTransformer) {
                    URL transformed = artifact.getTransformedUrl();
                    bundle = this.context.getBundle(artifact.getBundleId());
                    if (bundle == null) {
                        this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                        return null;
                    }
                    this.stopTransient(bundle);
                    Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                    InputStream in = transformed != null ? transformed.openStream() : new FileInputStream(path);
                    try {
                        bundle.update(in);
                    }
                    finally {
                        in.close();
                    }
                }
                if (artifact.getListener() instanceof ArtifactTransformer) {
                    File transformed = artifact.getTransformed();
                    bundle = this.context.getBundle(artifact.getBundleId());
                    if (bundle == null) {
                        this.log(2, "Failed to update bundle: " + path + " with ID " + artifact.getBundleId() + ". The bundle has been uninstalled", null);
                        return null;
                    }
                    this.stopTransient(bundle);
                    Util.storeChecksum(bundle, artifact.getChecksum(), this.context);
                    FileInputStream in = new FileInputStream(transformed != null ? transformed : path);
                    try {
                        bundle.update((InputStream)in);
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            }
            this.log(3, "Updated " + path, null);
        }
        catch (Throwable t) {
            this.log(2, "Failed to update artifact " + artifact.getPath(), t);
        }
        return bundle;
    }

    private void stopTransient(Bundle bundle) throws BundleException {
        if (this.startBundles && !this.isFragment(bundle)) {
            bundle.stop(1);
        }
    }

    private void processAllBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Iterator it = this.currentManagedArtifacts.values().iterator();
        while (it.hasNext()) {
            Bundle bundle;
            Artifact artifact = (Artifact)it.next();
            if (artifact.getBundleId() <= 0L || (bundle = this.context.getBundle(artifact.getBundleId())) == null || bundle.getState() == 8 || bundle.getState() == 32 || !this.useStartTransient && !FileInstall.getStartLevel().isBundlePersistentlyStarted(bundle) || FileInstall.getStartLevel().getStartLevel() < FileInstall.getStartLevel().getBundleStartLevel(bundle)) continue;
            bundles.add(bundle);
        }
        this.process(bundles);
    }

    private void process(Collection bundles) {
        Iterator b = bundles.iterator();
        while (b.hasNext()) {
            this.process((Bundle)b.next());
        }
    }

    private void process(Bundle bundle) {
        if (this.startLevel != 0) {
            FileInstall.getStartLevel().setBundleStartLevel(bundle, this.startLevel);
        }
        if (!this.isFragment(bundle) && this.startBundles) {
            try {
                bundle.start(this.useStartTransient ? 1 : 0);
                this.log(3, "Started bundle: " + bundle.getLocation(), null);
            }
            catch (BundleException e) {
                this.log(2, "Error while starting bundle: " + bundle.getLocation(), e);
            }
        }
    }
}

