/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.util;

import java.util.ArrayList;

public abstract class Matchers {
    private static final char SEP_TOPIC = '/';
    private static final char SEP_PCK = '.';

    public static Matcher[] createEventTopicMatchers(String[] config) {
        Matcher[] matchers;
        if (config == null || config.length == 0) {
            matchers = null;
        } else {
            ArrayList<Matcher> list = new ArrayList<Matcher>();
            for (int i = 0; i < config.length; ++i) {
                String value = config[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                if (value.endsWith(".")) {
                    list.add(new PackageMatcher(value.substring(0, value.length() - 1), '/'));
                    continue;
                }
                if (value.endsWith("*")) {
                    if (value.equals("*")) {
                        return new Matcher[]{new MatcherAll()};
                    }
                    list.add(new SubPackageMatcher(value.substring(0, value.length() - 1), '/'));
                    continue;
                }
                list.add(new ClassMatcher(value));
            }
            matchers = list.size() > 0 ? list.toArray(new Matcher[list.size()]) : null;
        }
        return matchers;
    }

    public static Matcher[] createPackageMatchers(String[] ignoreTimeout) {
        Matcher[] ignoreTimeoutMatcher;
        if (ignoreTimeout == null || ignoreTimeout.length == 0) {
            ignoreTimeoutMatcher = null;
        } else {
            ignoreTimeoutMatcher = new Matcher[ignoreTimeout.length];
            for (int i = 0; i < ignoreTimeout.length; ++i) {
                String value = ignoreTimeout[i];
                if (value != null) {
                    value = value.trim();
                }
                if (value == null || value.length() <= 0) continue;
                ignoreTimeoutMatcher[i] = value.endsWith(".") ? new PackageMatcher(value.substring(0, value.length() - 1), '.') : (value.endsWith("*") ? new SubPackageMatcher(value.substring(0, value.length() - 1), '.') : new ClassMatcher(value));
            }
        }
        return ignoreTimeoutMatcher;
    }

    private static final class PackageMatcher
    implements Matcher {
        private final String packageName;
        private final char sep;

        public PackageMatcher(String name, char sep) {
            this.packageName = name;
            this.sep = sep;
        }

        @Override
        public boolean match(String className) {
            int pos = className.lastIndexOf(this.sep);
            return pos > -1 && className.substring(0, pos).equals(this.packageName);
        }
    }

    public static interface Matcher {
        public boolean match(String var1);
    }

    private static final class MatcherAll
    implements Matcher {
        private MatcherAll() {
        }

        @Override
        public boolean match(String className) {
            return true;
        }
    }

    private static final class SubPackageMatcher
    implements Matcher {
        private final String packageName;
        private final char sep;

        public SubPackageMatcher(String name, char sep) {
            this.packageName = name + sep;
            this.sep = sep;
        }

        @Override
        public boolean match(String className) {
            int pos = className.lastIndexOf(this.sep);
            return pos > -1 && className.substring(0, pos + 1).startsWith(this.packageName);
        }
    }

    private static final class ClassMatcher
    implements Matcher {
        private final String m_className;

        public ClassMatcher(String name) {
            this.m_className = name;
        }

        @Override
        public boolean match(String className) {
            return this.m_className.equals(className);
        }
    }
}

