/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import java.util.List;
import org.apache.felix.eventadmin.impl.dispatch.DefaultThreadPool;
import org.apache.felix.eventadmin.impl.handler.HandlerTasks;
import org.apache.felix.eventadmin.impl.tasks.AsyncDeliverTasks;
import org.apache.felix.eventadmin.impl.tasks.DeliverTask;
import org.apache.felix.eventadmin.impl.tasks.SyncDeliverTasks;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class EventAdminImpl
implements EventAdmin {
    private volatile HandlerTasks m_managers;
    private final DeliverTask m_postManager;
    private final SyncDeliverTasks m_sendManager;

    public EventAdminImpl(HandlerTasks managers, DefaultThreadPool syncPool, DefaultThreadPool asyncPool, int timeout, String[] ignoreTimeout) {
        this.checkNull(managers, "Managers");
        this.checkNull(syncPool, "syncPool");
        this.checkNull(asyncPool, "asyncPool");
        this.m_managers = managers;
        this.m_sendManager = new SyncDeliverTasks(syncPool, timeout > 100 ? timeout : 0, ignoreTimeout);
        this.m_postManager = new AsyncDeliverTasks(asyncPool, this.m_sendManager);
    }

    public void postEvent(Event event) {
        this.handleEvent(this.m_managers.createHandlerTasks(event), this.m_postManager);
    }

    public void sendEvent(Event event) {
        this.handleEvent(this.m_managers.createHandlerTasks(event), this.m_sendManager);
    }

    public void stop() {
        this.m_managers = new HandlerTasks(){

            public List createHandlerTasks(Event event) {
                throw new IllegalStateException("The EventAdmin is stopped");
            }
        };
    }

    public void update(HandlerTasks managers, int timeout, String[] ignoreTimeout) {
        this.m_managers = managers;
        this.m_sendManager.update(timeout, ignoreTimeout);
    }

    private void handleEvent(List managers, DeliverTask manager) {
        if (managers != null && managers.size() > 0) {
            manager.execute(managers);
        }
    }

    private void checkNull(Object object, String name) {
        if (null == object) {
            throw new NullPointerException(name + " may not be null");
        }
    }
}

