/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentDeclaration;
import org.apache.felix.dm.ComponentDependencyDeclaration;
import org.apache.felix.dm.ComponentState;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.Logger;
import org.apache.felix.dm.context.ComponentContext;
import org.apache.felix.dm.context.DependencyContext;
import org.apache.felix.dm.context.Event;
import org.apache.felix.dm.context.EventType;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.DefaultNullObject;
import org.apache.felix.dm.impl.DispatchExecutor;
import org.apache.felix.dm.impl.FieldUtil;
import org.apache.felix.dm.impl.InvocationUtil;
import org.apache.felix.dm.impl.SerialExecutor;
import org.apache.felix.dm.impl.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ComponentImpl
implements Component,
ComponentContext,
ComponentDeclaration {
    private static final ServiceRegistration NULL_REGISTRATION = (ServiceRegistration)Proxy.newProxyInstance(ComponentImpl.class.getClassLoader(), new Class[]{ServiceRegistration.class}, (InvocationHandler)new DefaultNullObject());
    private static final Class<?>[] VOID = new Class[0];
    private volatile Executor m_executor = new SerialExecutor(new Logger(null));
    private ComponentState m_state = ComponentState.INACTIVE;
    private final CopyOnWriteArrayList<DependencyContext> m_dependencies = new CopyOnWriteArrayList();
    private final List<ComponentStateListener> m_listeners = new CopyOnWriteArrayList<ComponentStateListener>();
    private boolean m_isStarted;
    private final Logger m_logger;
    private final BundleContext m_context;
    private final DependencyManager m_manager;
    private Object m_componentDefinition;
    private Object m_componentInstance;
    private volatile Object m_serviceName;
    private volatile Dictionary<Object, Object> m_serviceProperties;
    private volatile ServiceRegistration m_registration;
    private final Map<Class<?>, Boolean> m_autoConfig = new ConcurrentHashMap();
    private final Map<Class<?>, String> m_autoConfigInstance = new ConcurrentHashMap();
    private final Map<String, Long> m_stopwatch = new ConcurrentHashMap<String, Long>();
    private final long m_id;
    private static AtomicLong m_idGenerator = new AtomicLong();
    private final Map<DependencyContext, ConcurrentSkipListSet<Event>> m_dependencyEvents = new HashMap<DependencyContext, ConcurrentSkipListSet<Event>>();
    private final AtomicBoolean m_active = new AtomicBoolean(false);
    private volatile String m_callbackInit;
    private volatile String m_callbackStart;
    private volatile String m_callbackStop;
    private volatile String m_callbackDestroy;
    private volatile Object m_callbackInstance;
    private volatile Object m_instanceFactory;
    private volatile String m_instanceFactoryCreateMethod;
    private volatile Object m_compositionManager;
    private volatile String m_compositionManagerGetMethod;
    private volatile Object m_compositionManagerInstance;
    private final Bundle m_bundle;

    @Override
    public Component setDebug(String debugKey) {
        this.m_logger.setEnabledLevel(4);
        this.m_logger.setDebugKey(debugKey);
        return this;
    }

    public ComponentImpl() {
        this(null, null, new Logger(null));
    }

    public ComponentImpl(BundleContext context, DependencyManager manager, Logger logger) {
        this.m_context = context;
        this.m_bundle = context != null ? context.getBundle() : null;
        this.m_manager = manager;
        this.m_logger = logger;
        this.m_autoConfig.put(BundleContext.class, Boolean.TRUE);
        this.m_autoConfig.put(ServiceRegistration.class, Boolean.TRUE);
        this.m_autoConfig.put(DependencyManager.class, Boolean.TRUE);
        this.m_autoConfig.put(Component.class, Boolean.TRUE);
        this.m_callbackInit = "init";
        this.m_callbackStart = "start";
        this.m_callbackStop = "stop";
        this.m_callbackDestroy = "destroy";
        this.m_id = m_idGenerator.getAndIncrement();
    }

    @Override
    public Component add(final Dependency ... dependencies) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                ArrayList<DependencyContext> instanceBoundDeps = new ArrayList<DependencyContext>();
                for (Dependency d : dependencies) {
                    DependencyContext dc = (DependencyContext)d;
                    if (dc.getComponentContext() != null) {
                        ComponentImpl.this.m_logger.err("%s can't be added to %s (dependency already added to another component).", dc, ComponentImpl.this);
                        continue;
                    }
                    ComponentImpl.this.m_dependencyEvents.put(dc, new ConcurrentSkipListSet());
                    ComponentImpl.this.m_dependencies.add(dc);
                    dc.setComponentContext(ComponentImpl.this);
                    if (ComponentImpl.this.m_state == ComponentState.INACTIVE) continue;
                    dc.setInstanceBound(true);
                    instanceBoundDeps.add(dc);
                }
                ComponentImpl.this.startDependencies(instanceBoundDeps);
                ComponentImpl.this.handleChange();
            }
        });
        return this;
    }

    @Override
    public Component remove(final Dependency d) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                DependencyContext dc = (DependencyContext)d;
                ComponentImpl.this.m_dependencies.remove(d);
                if (ComponentImpl.this.m_state != ComponentState.INACTIVE) {
                    dc.stop();
                }
                ComponentImpl.this.m_dependencyEvents.remove(d);
                ComponentImpl.this.handleChange();
            }
        });
        return this;
    }

    @Override
    public void start() {
        if (this.m_active.compareAndSet(false, true)) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    ComponentImpl.this.m_isStarted = true;
                    ComponentImpl.this.handleChange();
                }
            });
        }
    }

    @Override
    public void stop() {
        if (this.m_active.compareAndSet(true, false)) {
            boolean stopping;
            Executor executor = this.getExecutor();
            Runnable stopTask = new Runnable(){

                @Override
                public void run() {
                    ComponentImpl.this.m_isStarted = false;
                    ComponentImpl.this.handleChange();
                }
            };
            boolean bl = stopping = this.m_bundle != null && this.m_bundle.getState() == 16;
            if (stopping && executor instanceof DispatchExecutor) {
                ((DispatchExecutor)executor).execute(stopTask, false);
            } else {
                executor.execute(stopTask);
            }
        }
    }

    @Override
    public Component setInterface(String serviceName, Dictionary<?, ?> properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    @Override
    public Component setInterface(String[] serviceName, Dictionary<?, ?> properties) {
        this.ensureNotActive();
        this.m_serviceName = serviceName;
        this.m_serviceProperties = properties;
        return this;
    }

    @Override
    public void handleEvent(final DependencyContext dc, final EventType type, final Event ... event) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case ADDED: {
                        ComponentImpl.this.handleAdded(dc, event[0]);
                        break;
                    }
                    case CHANGED: {
                        ComponentImpl.this.handleChanged(dc, event[0]);
                        break;
                    }
                    case REMOVED: {
                        ComponentImpl.this.handleRemoved(dc, event[0]);
                        break;
                    }
                    case SWAPPED: {
                        ComponentImpl.this.handleSwapped(dc, event[0], event[1]);
                    }
                }
            }
        });
    }

    @Override
    public Event getDependencyEvent(DependencyContext dc) {
        ConcurrentSkipListSet<Event> events = this.m_dependencyEvents.get(dc);
        return events.size() > 0 ? events.last() : null;
    }

    @Override
    public Set<Event> getDependencyEvents(DependencyContext dc) {
        return this.m_dependencyEvents.get(dc);
    }

    @Override
    public Component setAutoConfig(Class<?> clazz, boolean autoConfig) {
        this.m_autoConfig.put(clazz, autoConfig);
        return this;
    }

    @Override
    public Component setAutoConfig(Class<?> clazz, String instanceName) {
        this.m_autoConfig.put(clazz, instanceName != null);
        this.m_autoConfigInstance.put(clazz, instanceName);
        return this;
    }

    @Override
    public boolean getAutoConfig(Class<?> clazz) {
        Boolean result = this.m_autoConfig.get(clazz);
        return result != null && result != false;
    }

    @Override
    public String getAutoConfigInstance(Class<?> clazz) {
        return this.m_autoConfigInstance.get(clazz);
    }

    private void handleAdded(DependencyContext dc, Event e) {
        if (!this.m_isStarted) {
            return;
        }
        this.m_logger.debug("handleAdded %s", e);
        Set dependencyEvents = this.m_dependencyEvents.get(dc);
        dependencyEvents.add(e);
        dc.setAvailable(true);
        switch (this.m_state) {
            case WAITING_FOR_REQUIRED: {
                if (!dc.isStarted() || !dc.isRequired()) break;
                this.handleChange();
                break;
            }
            case INSTANTIATED_AND_WAITING_FOR_REQUIRED: {
                if (!dc.isInstanceBound()) {
                    if (dc.isRequired()) {
                        dc.invokeCallback(EventType.ADDED, e);
                    }
                    this.updateInstance(dc, e, false, true);
                    break;
                }
                if (!dc.isStarted() || !dc.isRequired()) break;
                this.handleChange();
                break;
            }
            case TRACKING_OPTIONAL: {
                dc.invokeCallback(EventType.ADDED, e);
                this.updateInstance(dc, e, false, true);
                break;
            }
        }
    }

    private void handleChanged(DependencyContext dc, Event e) {
        if (!this.m_isStarted) {
            return;
        }
        Set dependencyEvents = this.m_dependencyEvents.get(dc);
        dependencyEvents.remove(e);
        dependencyEvents.add(e);
        switch (this.m_state) {
            case TRACKING_OPTIONAL: {
                dc.invokeCallback(EventType.CHANGED, e);
                this.updateInstance(dc, e, true, false);
                break;
            }
            case INSTANTIATED_AND_WAITING_FOR_REQUIRED: {
                if (dc.isInstanceBound()) break;
                dc.invokeCallback(EventType.CHANGED, e);
                this.updateInstance(dc, e, true, false);
                break;
            }
        }
    }

    private void handleRemoved(DependencyContext dc, Event e) {
        if (!this.m_isStarted) {
            return;
        }
        Set dependencyEvents = this.m_dependencyEvents.get(dc);
        int size = dependencyEvents.size();
        if (dependencyEvents.contains(e)) {
            --size;
        }
        dc.setAvailable(size > 0);
        if (size == 0 && dc.isStarted()) {
            this.handleChange();
        }
        dependencyEvents.remove(e);
        switch (this.m_state) {
            case INSTANTIATED_AND_WAITING_FOR_REQUIRED: {
                if (dc.isInstanceBound()) break;
                if (dc.isRequired()) {
                    dc.invokeCallback(EventType.REMOVED, e);
                }
                this.updateInstance(dc, e, false, false);
                break;
            }
            case TRACKING_OPTIONAL: {
                dc.invokeCallback(EventType.REMOVED, e);
                this.updateInstance(dc, e, false, false);
                break;
            }
        }
    }

    private void handleSwapped(DependencyContext dc, Event oldEvent, Event newEvent) {
        if (!this.m_isStarted) {
            return;
        }
        Set dependencyEvents = this.m_dependencyEvents.get(dc);
        dependencyEvents.remove(oldEvent);
        dependencyEvents.add(newEvent);
        switch (this.m_state) {
            case WAITING_FOR_REQUIRED: {
                break;
            }
            case INSTANTIATED_AND_WAITING_FOR_REQUIRED: {
                if (dc.isInstanceBound() || !dc.isRequired()) break;
                dc.invokeCallback(EventType.SWAPPED, oldEvent, newEvent);
                break;
            }
            case TRACKING_OPTIONAL: {
                dc.invokeCallback(EventType.SWAPPED, oldEvent, newEvent);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleChange() {
        this.m_logger.debug("handleChanged", new Object[0]);
        try {
            ComponentState newState;
            ComponentState oldState;
            do {
                oldState = this.m_state;
                newState = this.calculateNewState(oldState);
                this.m_logger.debug("%s -> %s", new Object[]{oldState, newState});
                this.m_state = newState;
            } while (this.performTransition(oldState, newState));
        }
        finally {
            this.m_logger.debug("end handling change.", new Object[0]);
        }
    }

    private ComponentState calculateNewState(ComponentState currentState) {
        if (currentState == ComponentState.INACTIVE && this.m_isStarted) {
            return ComponentState.WAITING_FOR_REQUIRED;
        }
        if (currentState == ComponentState.WAITING_FOR_REQUIRED) {
            if (!this.m_isStarted) {
                return ComponentState.INACTIVE;
            }
            if (this.allRequiredAvailable()) {
                return ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED;
            }
        }
        if (currentState == ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED) {
            if (this.m_isStarted && this.allRequiredAvailable()) {
                if (this.allInstanceBoundAvailable()) {
                    return ComponentState.TRACKING_OPTIONAL;
                }
                return currentState;
            }
            return ComponentState.WAITING_FOR_REQUIRED;
        }
        if (currentState == ComponentState.TRACKING_OPTIONAL) {
            if (this.m_isStarted && this.allRequiredAvailable() && this.allInstanceBoundAvailable()) {
                return currentState;
            }
            return ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED;
        }
        return currentState;
    }

    private boolean performTransition(ComponentState oldState, ComponentState newState) {
        if (oldState == ComponentState.INACTIVE && newState == ComponentState.WAITING_FOR_REQUIRED) {
            this.startDependencies(this.m_dependencies);
            this.notifyListeners(newState);
            return true;
        }
        if (oldState == ComponentState.WAITING_FOR_REQUIRED && newState == ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED) {
            this.instantiateComponent();
            this.invokeAutoConfigDependencies();
            this.invokeAddRequiredDependencies();
            ComponentState stateBeforeCallingInit = this.m_state;
            this.invoke(this.m_callbackInit);
            if (stateBeforeCallingInit == this.m_state) {
                this.notifyListeners(newState);
            }
            return true;
        }
        if (oldState == ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED && newState == ComponentState.TRACKING_OPTIONAL) {
            this.invokeAutoConfigInstanceBoundDependencies();
            this.invokeAddRequiredInstanceBoundDependencies();
            this.invoke(this.m_callbackStart);
            this.invokeAddOptionalDependencies();
            this.registerService();
            this.notifyListeners(newState);
            return true;
        }
        if (oldState == ComponentState.TRACKING_OPTIONAL && newState == ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED) {
            this.unregisterService();
            this.invokeRemoveOptionalDependencies();
            this.invoke(this.m_callbackStop);
            this.invokeRemoveInstanceBoundDependencies();
            this.notifyListeners(newState);
            return true;
        }
        if (oldState == ComponentState.INSTANTIATED_AND_WAITING_FOR_REQUIRED && newState == ComponentState.WAITING_FOR_REQUIRED) {
            this.invoke(this.m_callbackDestroy);
            this.invokeRemoveRequiredDependencies();
            this.notifyListeners(newState);
            if (!this.someDependenciesNeedInstance()) {
                this.destroyComponent();
            }
            return true;
        }
        if (oldState == ComponentState.WAITING_FOR_REQUIRED && newState == ComponentState.INACTIVE) {
            this.stopDependencies();
            this.destroyComponent();
            this.notifyListeners(newState);
            return true;
        }
        return false;
    }

    private boolean allRequiredAvailable() {
        boolean available = true;
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isRequired() || d.isInstanceBound() || d.isAvailable()) continue;
            available = false;
            break;
        }
        return available;
    }

    private boolean allInstanceBoundAvailable() {
        boolean available = true;
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isRequired() || !d.isInstanceBound() || d.isAvailable()) continue;
            available = false;
            break;
        }
        return available;
    }

    private boolean someDependenciesNeedInstance() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.needsInstance()) continue;
            return true;
        }
        return false;
    }

    private void updateInstance(DependencyContext dc, Event event, boolean update, boolean add) {
        if (dc.isAutoConfig()) {
            this.updateImplementation(dc.getAutoConfigType(), dc, dc.getAutoConfigName(), event, update, add);
        }
        if (dc.isPropagated() && this.m_registration != null) {
            this.m_registration.setProperties(this.calculateServiceProperties());
        }
    }

    private void startDependencies(List<DependencyContext> dependencies) {
        this.m_logger.debug("startDependencies.", new Object[0]);
        ArrayList<DependencyContext> requiredDeps = new ArrayList<DependencyContext>();
        for (DependencyContext d : dependencies) {
            if (d.isRequired()) {
                requiredDeps.add(d);
                continue;
            }
            if (d.needsInstance()) {
                this.instantiateComponent();
            }
            d.start();
        }
        for (DependencyContext d : requiredDeps) {
            if (d.needsInstance()) {
                this.instantiateComponent();
            }
            d.start();
        }
        this.handleChange();
    }

    private void stopDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            d.stop();
        }
    }

    private void registerService() {
        if (this.m_context != null && this.m_serviceName != null) {
            ServiceRegistrationImpl wrapper = new ServiceRegistrationImpl();
            this.m_registration = wrapper;
            this.autoConfigureImplementation(ServiceRegistration.class, this.m_registration);
            Dictionary<Object, Object> properties = this.calculateServiceProperties();
            try {
                ServiceRegistration registration = this.m_serviceName instanceof String ? this.m_context.registerService((String)this.m_serviceName, this.m_componentInstance, properties) : this.m_context.registerService((String[])this.m_serviceName, this.m_componentInstance, properties);
                wrapper.setServiceRegistration(registration);
            }
            catch (IllegalArgumentException iae) {
                this.m_logger.log(1, "Could not register service " + this.m_componentInstance, iae);
                wrapper.setIllegalState();
            }
        }
    }

    private void unregisterService() {
        if (this.m_serviceName != null && this.m_registration != null) {
            try {
                if (this.m_bundle != null && this.m_bundle.getState() == 32) {
                    this.m_registration.unregister();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.autoConfigureImplementation(ServiceRegistration.class, NULL_REGISTRATION);
            this.m_registration = null;
        }
    }

    private Dictionary<Object, Object> calculateServiceProperties() {
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        for (int i = 0; i < this.m_dependencies.size(); ++i) {
            DependencyContext d = this.m_dependencies.get(i);
            if (!d.isPropagated() || !d.isAvailable()) continue;
            Dictionary<Object, Object> dict = d.getProperties();
            this.addTo(properties, dict);
        }
        this.addTo(properties, this.m_serviceProperties);
        if (((Dictionary)properties).size() == 0) {
            properties = null;
        }
        return properties;
    }

    private void addTo(Dictionary<Object, Object> properties, Dictionary<Object, Object> additional) {
        if (properties == null) {
            throw new IllegalArgumentException("Dictionary to add to cannot be null.");
        }
        if (additional != null) {
            Enumeration<Object> e = additional.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                properties.put(key, additional.get(key));
            }
        }
    }

    void instantiateComponent() {
        this.m_logger.debug("instantiating component.", new Object[0]);
        if (this.m_componentInstance == null) {
            if (this.m_componentDefinition instanceof Class) {
                try {
                    this.m_componentInstance = this.createInstance((Class)this.m_componentDefinition);
                }
                catch (Exception e) {
                    this.m_logger.log(1, "Could not instantiate class " + this.m_componentDefinition, e);
                }
            } else if (this.m_instanceFactoryCreateMethod != null) {
                Object factory = null;
                if (this.m_instanceFactory != null) {
                    if (this.m_instanceFactory instanceof Class) {
                        try {
                            factory = this.createInstance((Class)this.m_instanceFactory);
                        }
                        catch (Exception e) {
                            this.m_logger.log(1, "Could not create factory instance of class " + this.m_instanceFactory + ".", e);
                        }
                    } else {
                        factory = this.m_instanceFactory;
                    }
                }
                if (factory == null) {
                    this.m_logger.log(1, "Factory cannot be null.");
                } else {
                    try {
                        this.m_componentInstance = InvocationUtil.invokeMethod(factory, factory.getClass(), this.m_instanceFactoryCreateMethod, new Class[][]{new Class[0], {Component.class}}, new Object[][]{new Object[0], {this}}, false);
                    }
                    catch (Exception e) {
                        this.m_logger.log(1, "Could not create service instance using factory " + factory + " method " + this.m_instanceFactoryCreateMethod + ".", e);
                    }
                }
            }
            if (this.m_componentInstance == null) {
                this.m_componentInstance = this.m_componentDefinition;
            }
            this.autoConfigureImplementation(BundleContext.class, this.m_context);
            this.autoConfigureImplementation(ServiceRegistration.class, NULL_REGISTRATION);
            this.autoConfigureImplementation(DependencyManager.class, this.m_manager);
            this.autoConfigureImplementation(Component.class, this);
        }
    }

    private void destroyComponent() {
        this.m_componentInstance = null;
    }

    private void invokeAddRequiredDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isRequired() || d.isInstanceBound()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.ADDED, e);
            }
        }
    }

    private void invokeAutoConfigDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isAutoConfig() || d.isInstanceBound()) continue;
            this.configureImplementation(d.getAutoConfigType(), d, d.getAutoConfigName());
        }
    }

    private void invokeAutoConfigInstanceBoundDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isAutoConfig() || !d.isInstanceBound()) continue;
            this.configureImplementation(d.getAutoConfigType(), d, d.getAutoConfigName());
        }
    }

    private void invokeAddRequiredInstanceBoundDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isRequired() || !d.isInstanceBound()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.ADDED, e);
            }
        }
    }

    private void invokeAddOptionalDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (d.isRequired()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.ADDED, e);
            }
        }
    }

    private void invokeRemoveRequiredDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (d.isInstanceBound() || !d.isRequired()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.REMOVED, e);
            }
        }
    }

    private void invokeRemoveOptionalDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (d.isRequired()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.REMOVED, e);
            }
        }
    }

    private void invokeRemoveInstanceBoundDependencies() {
        for (DependencyContext d : this.m_dependencies) {
            if (!d.isInstanceBound()) continue;
            for (Event e : this.m_dependencyEvents.get(d)) {
                d.invokeCallback(EventType.REMOVED, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(String name) {
        if (name != null) {
            Object[] objectArray;
            if (this.m_callbackInstance != null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = this.m_callbackInstance;
            } else {
                objectArray = this.getCompositionInstances();
            }
            Object[] instances = objectArray;
            long t1 = System.nanoTime();
            try {
                this.invokeCallbackMethod(instances, name, new Class[][]{{Component.class}, new Class[0]}, new Object[][]{{this}, new Object[0]}, false);
            }
            finally {
                long t2 = System.nanoTime();
                this.m_stopwatch.put(name, t2 - t1);
            }
        }
    }

    @Override
    public <T> T getInstance() {
        Object[] instances = this.getCompositionInstances();
        return (T)(instances.length == 0 ? null : instances[0]);
    }

    @Override
    public Object[] getInstances() {
        return this.getCompositionInstances();
    }

    @Override
    public void invokeCallbackMethod(Object[] instances, String methodName, Class<?>[][] signatures, Object[][] parameters) {
        this.invokeCallbackMethod(instances, methodName, signatures, parameters, true);
    }

    public void invokeCallbackMethod(Object[] instances, String methodName, Class<?>[][] signatures, Object[][] parameters, boolean logIfNotFound) {
        boolean callbackFound = false;
        for (int i = 0; i < instances.length; ++i) {
            try {
                InvocationUtil.invokeCallbackMethod(instances[i], methodName, signatures, parameters);
                callbackFound |= true;
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                this.m_logger.log(1, "Invocation of '" + methodName + "' failed.", e.getCause());
                continue;
            }
            catch (Throwable e) {
                this.m_logger.log(1, "Could not invoke '" + methodName + "'.", e);
            }
        }
        if (logIfNotFound && !callbackFound && !(this.getInstance() instanceof AbstractDecorator)) {
            if (this.m_logger == null) {
                System.out.println("Callback \"" + methodName + "\" not found on componnent instances " + Arrays.toString(this.getInstances()));
            } else {
                this.m_logger.log(1, "Callback \"" + methodName + "\" callback not found on componnent instances " + Arrays.toString(this.getInstances()));
            }
        }
    }

    private Object createInstance(Class<?> clazz) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(VOID);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private void notifyListeners(ComponentState state) {
        for (ComponentStateListener l : this.m_listeners) {
            l.changed(this, state);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.m_state == ComponentState.TRACKING_OPTIONAL;
    }

    @Override
    public boolean isActive() {
        return this.m_active.get();
    }

    @Override
    public Component add(ComponentStateListener l) {
        this.m_listeners.add(l);
        return this;
    }

    @Override
    public Component remove(ComponentStateListener l) {
        this.m_listeners.remove(l);
        return this;
    }

    @Override
    public List<DependencyContext> getDependencies() {
        return (List)this.m_dependencies.clone();
    }

    @Override
    public Component setImplementation(Object implementation) {
        this.m_componentDefinition = implementation;
        return this;
    }

    private void autoConfigureImplementation(Class<?> clazz, Object instance) {
        if (this.m_autoConfig.get(clazz).booleanValue()) {
            this.configureImplementation(clazz, instance, this.m_autoConfigInstance.get(clazz));
        }
    }

    private void configureImplementation(Class<?> clazz, Object instance, String fieldName) {
        Object[] targets = this.getInstances();
        if (!FieldUtil.injectField(targets, fieldName, clazz, instance, this.m_logger) && fieldName != null && !(this.getInstance() instanceof AbstractDecorator)) {
            this.m_logger.log(1, "Could not inject " + instance + " to field \"" + fieldName + "\" at any of the following component instances: " + Arrays.toString(targets));
        }
    }

    private void configureImplementation(Class<?> clazz, DependencyContext dc, String fieldName) {
        Object[] targets = this.getInstances();
        if (!FieldUtil.injectDependencyField(targets, fieldName, clazz, dc, this.m_logger) && fieldName != null && !(this.getInstance() instanceof AbstractDecorator)) {
            this.m_logger.log(1, "Could not inject dependency " + clazz.getName() + " to field \"" + fieldName + "\" at any of the following component instances: " + Arrays.toString(targets));
        }
    }

    private void updateImplementation(Class<?> clazz, DependencyContext dc, String fieldName, Event event, boolean update, boolean add) {
        Object[] targets = this.getInstances();
        FieldUtil.updateDependencyField(targets, fieldName, update, add, clazz, event, dc, this.m_logger);
    }

    @Override
    public ServiceRegistration getServiceRegistration() {
        return this.m_registration;
    }

    @Override
    public <K, V> Dictionary<K, V> getServiceProperties() {
        if (this.m_serviceProperties != null) {
            Hashtable<Object, Object> serviceProperties = new Hashtable<Object, Object>();
            this.addTo(serviceProperties, this.m_serviceProperties);
            return serviceProperties;
        }
        return null;
    }

    @Override
    public Component setServiceProperties(final Dictionary<?, ?> serviceProperties) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Dictionary properties = null;
                ComponentImpl.this.m_serviceProperties = serviceProperties;
                if (ComponentImpl.this.m_registration != null && ComponentImpl.this.m_serviceName != null) {
                    properties = ComponentImpl.this.calculateServiceProperties();
                    ComponentImpl.this.m_registration.setProperties(properties);
                }
            }
        });
        return this;
    }

    @Override
    public Component setCallbacks(String init, String start, String stop, String destroy) {
        this.ensureNotActive();
        this.m_callbackInit = init;
        this.m_callbackStart = start;
        this.m_callbackStop = stop;
        this.m_callbackDestroy = destroy;
        return this;
    }

    @Override
    public Component setCallbacks(Object instance, String init, String start, String stop, String destroy) {
        this.ensureNotActive();
        this.m_callbackInstance = instance;
        this.m_callbackInit = init;
        this.m_callbackStart = start;
        this.m_callbackStop = stop;
        this.m_callbackDestroy = destroy;
        return this;
    }

    @Override
    public Component setFactory(Object factory, String createMethod) {
        this.ensureNotActive();
        this.m_instanceFactory = factory;
        this.m_instanceFactoryCreateMethod = createMethod;
        return this;
    }

    @Override
    public Component setFactory(String createMethod) {
        return this.setFactory(null, createMethod);
    }

    @Override
    public Component setComposition(Object instance, String getMethod) {
        this.ensureNotActive();
        this.m_compositionManager = instance;
        this.m_compositionManagerGetMethod = getMethod;
        return this;
    }

    @Override
    public Component setComposition(String getMethod) {
        return this.setComposition(null, getMethod);
    }

    private Object[] getCompositionInstances() {
        Object[] instances = null;
        if (this.m_compositionManagerGetMethod != null) {
            this.m_compositionManagerInstance = this.m_compositionManager != null ? this.m_compositionManager : this.m_componentInstance;
            if (this.m_compositionManagerInstance != null) {
                try {
                    instances = (Object[])InvocationUtil.invokeMethod(this.m_compositionManagerInstance, this.m_compositionManagerInstance.getClass(), this.m_compositionManagerGetMethod, new Class[][]{new Class[0]}, new Object[][]{new Object[0]}, false);
                }
                catch (Exception e) {
                    Object[] objectArray;
                    this.m_logger.log(1, "Could not obtain instances from the composition manager.", e);
                    if (this.m_componentInstance == null) {
                        objectArray = new Object[]{};
                    } else {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = this.m_componentInstance;
                    }
                    instances = objectArray;
                }
            }
        } else {
            Object[] objectArray;
            if (this.m_componentInstance == null) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = this.m_componentInstance;
            }
            instances = objectArray;
        }
        return instances;
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.m_manager;
    }

    @Override
    public ComponentDependencyDeclaration[] getComponentDependencies() {
        List<DependencyContext> deps = this.getDependencies();
        if (deps != null) {
            ComponentDependencyDeclaration[] result = new ComponentDependencyDeclaration[deps.size()];
            for (int i = 0; i < result.length; ++i) {
                DependencyContext dep = deps.get(i);
                result[i] = dep instanceof ComponentDependencyDeclaration ? (ComponentDependencyDeclaration)((Object)dep) : new SCDImpl(dep.toString(), (dep.isAvailable() ? 1 : 0) + (dep.isRequired() ? 2 : 0), dep.getClass().getName());
            }
            return result;
        }
        return null;
    }

    @Override
    public String getName() {
        StringBuffer sb;
        block13: {
            sb = new StringBuffer();
            Object serviceName = this.m_serviceName;
            if (serviceName instanceof String[]) {
                String[] names = (String[])serviceName;
                for (int i = 0; i < names.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(names[i]);
                }
                this.appendProperties(sb);
            } else if (serviceName instanceof String) {
                sb.append(serviceName.toString());
                this.appendProperties(sb);
            } else {
                Object implementation = this.m_componentDefinition;
                if (implementation != null) {
                    if (implementation instanceof Class) {
                        sb.append(((Class)implementation).getName());
                    } else {
                        try {
                            Method m = implementation.getClass().getMethod("toString", new Class[0]);
                            if (m.getDeclaringClass().equals(Object.class)) {
                                sb.append(implementation.getClass().getName());
                                break block13;
                            }
                            sb.append(implementation.toString());
                        }
                        catch (NoSuchMethodException e) {
                            sb.append(implementation.getClass().getName());
                        }
                    }
                } else {
                    sb.append(super.toString());
                }
            }
        }
        return sb.toString();
    }

    private void appendProperties(StringBuffer result) {
        Dictionary<Object, Object> properties = this.calculateServiceProperties();
        if (properties != null) {
            result.append("(");
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                result.append(key.toString());
                result.append('=');
                Object value = properties.get(key);
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    result.append('{');
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            result.append(',');
                        }
                        result.append(values[i].toString());
                    }
                    result.append('}');
                } else {
                    result.append(value.toString());
                }
                if (!enumeration.hasMoreElements()) continue;
                result.append(',');
            }
            result.append(")");
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.m_context;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public long getId() {
        return this.m_id;
    }

    @Override
    public String getClassName() {
        Object serviceInstance = this.m_componentInstance;
        if (serviceInstance != null) {
            return serviceInstance.getClass().getName();
        }
        Object implementation = this.m_componentDefinition;
        if (implementation != null) {
            if (implementation instanceof Class) {
                return ((Class)implementation).getName();
            }
            return implementation.getClass().getName();
        }
        Object instanceFactory = this.m_instanceFactory;
        if (instanceFactory != null) {
            return instanceFactory.getClass().getName();
        }
        return ComponentImpl.class.getName();
    }

    @Override
    public String[] getServices() {
        if (this.m_serviceName instanceof String[]) {
            return (String[])this.m_serviceName;
        }
        if (this.m_serviceName instanceof String) {
            return new String[]{(String)this.m_serviceName};
        }
        return null;
    }

    @Override
    public int getState() {
        return this.isAvailable() ? 1 : 0;
    }

    public void ensureNotActive() {
        if (this.m_active.get()) {
            throw new IllegalStateException("Can't modify an already started component.");
        }
    }

    @Override
    public ComponentDeclaration getComponentDeclaration() {
        return this;
    }

    public String toString() {
        if (this.m_logger.getDebugKey() != null) {
            return this.m_logger.getDebugKey();
        }
        return this.getClassName();
    }

    @Override
    public void setThreadPool(Executor threadPool) {
        this.ensureNotActive();
        this.m_executor = new DispatchExecutor(threadPool, this.m_logger);
    }

    @Override
    public Logger getLogger() {
        return this.m_logger;
    }

    @Override
    public Map<String, Long> getCallbacksTime() {
        return this.m_stopwatch;
    }

    private Executor getExecutor() {
        return this.m_executor;
    }

    static class SCDImpl
    implements ComponentDependencyDeclaration {
        private final String m_name;
        private final int m_state;
        private final String m_type;

        public SCDImpl(String name, int state, String type) {
            this.m_name = name;
            this.m_state = state;
            this.m_type = type;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        @Override
        public String getSimpleName() {
            return this.m_name;
        }

        @Override
        public String getFilter() {
            return null;
        }

        @Override
        public int getState() {
            return this.m_state;
        }

        @Override
        public String getType() {
            return this.m_type;
        }
    }
}

