/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.DependencyService;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterService;
import org.apache.felix.dm.impl.dependencies.ServiceDependencyImpl;
import org.osgi.framework.ServiceReference;

public class AspectServiceImpl
extends FilterService {
    private final String m_add;
    private final String m_change;
    private final String m_remove;
    private final String m_swap;
    private final String m_aspectFilter;
    private final int m_ranking;

    public AspectServiceImpl(DependencyManager dm, Class aspectInterface, String aspectFilter, int ranking, String autoConfig, String add, String change, String remove, String swap) {
        super(dm.createComponent());
        this.m_ranking = ranking;
        this.m_add = add;
        this.m_change = change;
        this.m_remove = remove;
        this.m_swap = swap;
        this.m_aspectFilter = aspectFilter;
        this.m_component.setImplementation(new AspectImpl(aspectInterface, autoConfig)).add(dm.createServiceDependency().setService(aspectInterface, this.createDependencyFilterForAspect(aspectFilter)).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    private String createDependencyFilterForAspect(String filter) {
        if (filter == null || filter.length() == 0) {
            return "(!(org.apache.felix.dependencymanager.aspect=*))";
        }
        return "(&(!(org.apache.felix.dependencymanager.aspect=*))" + filter + ")";
    }

    private Properties getServiceProperties(ServiceReference ref) {
        String key;
        Properties props = new Properties();
        String[] keys = ref.getPropertyKeys();
        for (int i = 0; i < keys.length; ++i) {
            key = keys[i];
            if (key.equals("service.id") || key.equals("service.ranking") || key.equals("org.apache.felix.dependencymanager.aspect") || key.equals("objectClass")) continue;
            props.put(key, ref.getProperty(key));
        }
        if (this.m_serviceProperties != null) {
            Enumeration e = this.m_serviceProperties.keys();
            while (e.hasMoreElements()) {
                key = e.nextElement();
                props.put(key, this.m_serviceProperties.get(key));
            }
        }
        props.put("org.apache.felix.dependencymanager.aspect", ref.getProperty("service.id"));
        props.put("service.ranking", (Object)this.m_ranking);
        return props;
    }

    class CallbackProxy {
        private final ServiceDependencyImpl m_aspectDependency;
        private final ServiceReference m_originalServiceRef;

        CallbackProxy(ServiceDependency aspectDependency, ServiceReference originalServiceRef) {
            this.m_aspectDependency = (ServiceDependencyImpl)aspectDependency;
            this.m_originalServiceRef = originalServiceRef;
        }

        private void addAspect(Component c, ServiceReference ref, Object service) {
            this.m_aspectDependency.invoke(c.getCompositionInstances(), (DependencyService)((Object)c), ref, service, AspectServiceImpl.this.m_add);
        }

        private void changeAspect(Component c, ServiceReference ref, Object service) {
            if (AspectServiceImpl.this.m_change != null) {
                this.m_aspectDependency.invoke(c.getCompositionInstances(), (DependencyService)((Object)c), ref, service, AspectServiceImpl.this.m_change);
            }
            Properties props = AspectServiceImpl.this.getServiceProperties(this.m_originalServiceRef);
            c.setServiceProperties(props);
        }

        private void removeAspect(Component c, ServiceReference ref, Object service) {
            this.m_aspectDependency.invoke(c.getCompositionInstances(), (DependencyService)((Object)c), ref, service, AspectServiceImpl.this.m_remove);
        }

        private void swapAspect(Component c, ServiceReference prevRef, Object prev, ServiceReference currRef, Object curr) {
            this.m_aspectDependency.invokeSwappedCallback(c.getCompositionInstances(), (DependencyService)((Object)c), prevRef, prev, currRef, curr, AspectServiceImpl.this.m_swap);
        }
    }

    class AspectImpl
    extends AbstractDecorator {
        private final String m_autoConfig;
        private final Class m_aspectInterface;

        public AspectImpl(Class aspectInterface, String autoConfig) {
            this.m_aspectInterface = aspectInterface;
            this.m_autoConfig = autoConfig;
        }

        public Component createService(Object[] params) {
            int i;
            ServiceReference ref = (ServiceReference)params[0];
            List dependencies = AspectServiceImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            Properties serviceProperties = AspectServiceImpl.this.getServiceProperties(ref);
            String[] serviceInterfaces = this.getServiceInterfaces();
            ServiceDependencyImpl aspectDependency = (ServiceDependencyImpl)this.m_manager.createServiceDependency().setService(this.m_aspectInterface, this.createAspectFilter(ref)).setRequired(true);
            aspectDependency.setCallbacks(new CallbackProxy(aspectDependency, ref), AspectServiceImpl.this.m_add != null ? "addAspect" : null, "changeAspect", AspectServiceImpl.this.m_remove != null ? "removeAspect" : null, AspectServiceImpl.this.m_swap != null ? "swapAspect" : null);
            if (this.m_autoConfig != null) {
                aspectDependency.setAutoConfig(this.m_autoConfig);
            } else if (AspectServiceImpl.this.m_add == null && AspectServiceImpl.this.m_change == null && AspectServiceImpl.this.m_remove == null && AspectServiceImpl.this.m_swap == null) {
                aspectDependency.setAutoConfig(true);
            }
            Component service = this.m_manager.createComponent().setInterface(serviceInterfaces, (Dictionary)serviceProperties).setImplementation(AspectServiceImpl.this.m_serviceImpl).setFactory(AspectServiceImpl.this.m_factory, AspectServiceImpl.this.m_factoryCreateMethod).setComposition(AspectServiceImpl.this.m_compositionInstance, AspectServiceImpl.this.m_compositionMethod).setCallbacks(AspectServiceImpl.this.m_callbackObject, AspectServiceImpl.this.m_init, AspectServiceImpl.this.m_start, AspectServiceImpl.this.m_stop, AspectServiceImpl.this.m_destroy).add(aspectDependency);
            this.configureAutoConfigState(service, AspectServiceImpl.this.m_component);
            for (i = 0; i < dependencies.size(); ++i) {
                service.add(((Dependency)dependencies.get(i)).createCopy());
            }
            for (i = 0; i < AspectServiceImpl.this.m_stateListeners.size(); ++i) {
                service.addStateListener((ComponentStateListener)AspectServiceImpl.this.m_stateListeners.get(i));
            }
            return service;
        }

        public void setServiceProperties(Dictionary props) {
            Map services = super.getServices();
            Iterator it = services.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ServiceReference originalServiceRef = (ServiceReference)entry.getKey();
                Component c = (Component)entry.getValue();
                Properties newProps = AspectServiceImpl.this.getServiceProperties(originalServiceRef);
                c.setServiceProperties(newProps);
            }
        }

        private String[] getServiceInterfaces() {
            ArrayList<String> serviceNames = new ArrayList<String>();
            serviceNames.add(this.m_aspectInterface.getName());
            if (AspectServiceImpl.this.m_serviceInterfaces != null) {
                for (int i = 0; i < AspectServiceImpl.this.m_serviceInterfaces.length; ++i) {
                    if (AspectServiceImpl.this.m_serviceInterfaces[i].equals(this.m_aspectInterface.getName())) continue;
                    serviceNames.add(AspectServiceImpl.this.m_serviceInterfaces[i]);
                }
            }
            return serviceNames.toArray(new String[serviceNames.size()]);
        }

        private String createAspectFilter(ServiceReference ref) {
            Long sid = (Long)ref.getProperty("service.id");
            return "(&(|(!(service.ranking=*))(service.ranking<=" + (AspectServiceImpl.this.m_ranking - 1) + "))(|(" + "service.id" + "=" + sid + ")(" + "org.apache.felix.dependencymanager.aspect" + "=" + sid + ")))";
        }

        public String toString() {
            return "Aspect for " + this.m_aspectInterface + (AspectServiceImpl.this.m_aspectFilter != null ? " with filter " + AspectServiceImpl.this.m_aspectFilter : "");
        }
    }
}

