/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.tracker;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.felix.dm.ServiceUtil;
import org.apache.felix.dm.tracker.AbstractTracked;
import org.apache.felix.dm.tracker.ServiceTrackerCustomizer;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    final ServiceTrackerCustomizer customizer;
    final String listenerFilter;
    private final String trackClass;
    private final ServiceReference trackReference;
    private volatile Tracked tracked;
    private volatile ServiceReference cachedReference;
    private volatile Object cachedService;
    private static final Version endMatchVersion = new Version(1, 5, 0);
    public boolean m_trackAllAspects;

    private Tracked tracked() {
        return this.tracked;
    }

    public ServiceTracker(BundleContext context, ServiceReference reference, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = reference;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(service.id=" + reference.getProperty("service.id").toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(BundleContext context, String clazz, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = clazz;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(objectClass=" + clazz.toString() + ")";
        try {
            this.filter = context.createFilter(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            IllegalArgumentException iae = new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
            iae.initCause(e);
            throw iae;
        }
    }

    public ServiceTracker(final BundleContext context, Filter filter, ServiceTrackerCustomizer customizer) {
        this.context = context;
        this.trackReference = null;
        this.trackClass = null;
        Version frameworkVersion = (Version)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String version = context.getProperty("org.osgi.framework.version");
                return version == null ? Version.emptyVersion : new Version(version);
            }
        });
        boolean endMatchSupported = frameworkVersion.compareTo((Object)endMatchVersion) >= 0;
        this.listenerFilter = endMatchSupported ? filter.toString() : null;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer = this.customizer = customizer == null ? this : customizer;
        if (context == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public void open() {
        this.open(false);
    }

    public void open(boolean trackAllServices) {
        this.open(trackAllServices, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(boolean trackAllServices, boolean trackAllAspects) {
        Tracked t;
        ServiceTracker serviceTracker = this;
        synchronized (serviceTracker) {
            if (this.tracked != null) {
                return;
            }
            this.m_trackAllAspects = trackAllAspects;
            Tracked tracked = t = trackAllServices ? new AllTracked() : new Tracked();
            synchronized (tracked) {
                try {
                    this.context.addServiceListener((ServiceListener)t, this.listenerFilter);
                    Object[] references = null;
                    if (this.trackClass != null) {
                        references = this.getInitialReferences(trackAllServices, this.trackClass, null);
                    } else if (this.trackReference != null) {
                        if (this.trackReference.getBundle() != null) {
                            references = new ServiceReference[]{this.trackReference};
                        }
                    } else {
                        references = this.getInitialReferences(trackAllServices, null, this.listenerFilter != null ? this.listenerFilter : this.filter.toString());
                    }
                    t.setInitial(references);
                }
                catch (InvalidSyntaxException e) {
                    throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage(), e);
                }
            }
            this.tracked = t;
        }
        t.trackInitial();
    }

    private ServiceReference[] getInitialReferences(boolean trackAllServices, String className, String filterString) throws InvalidSyntaxException {
        if (trackAllServices) {
            return this.context.getAllServiceReferences(className, filterString);
        }
        return this.context.getServiceReferences(className, filterString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServiceReference[] references;
        Tracked outgoing;
        Object object = this;
        synchronized (object) {
            outgoing = this.tracked;
            if (outgoing == null) {
                return;
            }
            outgoing.close();
            references = this.getServiceReferences();
            this.tracked = null;
            try {
                this.context.removeServiceListener((ServiceListener)outgoing);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        this.modified();
        object = outgoing;
        synchronized (object) {
            outgoing.notifyAll();
        }
        if (references != null) {
            for (int i = 0; i < references.length; ++i) {
                outgoing.untrack(references[i], null);
            }
        }
    }

    public Object addingService(ServiceReference reference) {
        return this.context.getService(reference);
    }

    public void addedService(ServiceReference reference, Object service) {
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.context.ungetService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked t = this.tracked();
            if (t == null) {
                return null;
            }
            Tracked tracked = t;
            synchronized (tracked) {
                if (t.size() == 0) {
                    t.wait(timeout);
                }
            }
            object = this.getService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceReference[] getServiceReferences() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            if (length == 0) {
                return null;
            }
            return (ServiceReference[])t.getTracked(new ServiceReference[length]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReference() {
        if (this.cachedReference != null) {
            return true;
        }
        Tracked t = this.tracked();
        if (t == null) {
            return false;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length = t.size();
            return length > 0;
        }
    }

    public ServiceReference getServiceReference() {
        int length;
        ServiceReference reference = this.cachedReference;
        if (reference != null) {
            return reference;
        }
        ServiceReference[] references = this.getServiceReferences();
        int n = length = references == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            for (int i = 0; i < length; ++i) {
                int ranking;
                Object property = references[i].getProperty("service.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                    continue;
                }
                if (ranking != maxRanking) continue;
                ++count;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                for (int i = 0; i < length; ++i) {
                    long id;
                    if (rankings[i] != maxRanking || (id = ((Long)references[i].getProperty("service.id")).longValue()) >= minId) continue;
                    index = i;
                    minId = id;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getCustomizedObject(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getServices() {
        Tracked t = this.tracked();
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            ServiceReference[] references = this.getServiceReferences();
            int n = length = references == null ? 0 : references.length;
            if (length == 0) {
                return null;
            }
            Object[] objects = new Object[length];
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getService(references[i]);
            }
            return objects;
        }
    }

    public Object getService() {
        Object service = this.cachedService;
        if (service != null) {
            return service;
        }
        ServiceReference reference = this.getServiceReference();
        if (reference == null) {
            return null;
        }
        this.cachedService = this.getService(reference);
        return this.cachedService;
    }

    public void remove(ServiceReference reference) {
        Tracked t = this.tracked();
        if (t == null) {
            return;
        }
        t.untrack(reference, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked t = this.tracked();
        if (t == null) {
            return 0;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked t = this.tracked();
        if (t == null) {
            return -1;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return t.getTrackingCount();
        }
    }

    void modified() {
        this.cachedReference = null;
        this.cachedService = null;
    }

    private static final class RankedService {
        private int m_ranking;
        private ServiceReference m_serviceReference;

        public RankedService(int ranking, ServiceReference serviceReference) {
            this.m_ranking = ranking;
            this.m_serviceReference = serviceReference;
        }

        public void update(int ranking, ServiceReference serviceReference) {
            this.m_ranking = ranking;
            this.m_serviceReference = serviceReference;
        }

        public int getRanking() {
            return this.m_ranking;
        }

        public ServiceReference getServiceReference() {
            return this.m_serviceReference;
        }
    }

    class AllTracked
    extends Tracked
    implements AllServiceListener {
        AllTracked() {
            this.setTracked(new Tracked.HashMapCache());
        }
    }

    class Tracked
    extends AbstractTracked
    implements ServiceListener {
        private final List m_hidden = new ArrayList();
        private final HashMap m_highestTrackedCache = new HashMap();
        private final HashMap m_highestHiddenCache = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestHidden(long serviceId) {
            ServiceReference result = null;
            int max = Integer.MIN_VALUE;
            Tracked tracked = this;
            synchronized (tracked) {
                for (int i = 0; i < this.m_hidden.size(); ++i) {
                    ServiceReference ref = (ServiceReference)this.m_hidden.get(i);
                    Long sid = (Long)ref.getProperty("service.id");
                    Long aid = (Long)ref.getProperty("org.apache.felix.dependencymanager.aspect");
                    if ((aid == null || aid != serviceId) && (aid != null || sid == null || sid != serviceId)) continue;
                    Integer ranking = (Integer)ref.getProperty("service.ranking");
                    int r = 0;
                    if (ranking != null) {
                        r = ranking;
                    }
                    if (r <= max) continue;
                    max = r;
                    result = ref;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestTracked(long serviceId) {
            ServiceReference result = null;
            int max = Integer.MIN_VALUE;
            Tracked tracked = this;
            synchronized (tracked) {
                int length = this.size();
                if (length == 0) {
                    return null;
                }
                Object[] trackedServices = this.getTracked(new ServiceReference[length]);
                for (int i = 0; i < trackedServices.length; ++i) {
                    ServiceReference ref = (ServiceReference)trackedServices[i];
                    Long sid = (Long)ref.getProperty("service.id");
                    Long aid = (Long)ref.getProperty("org.apache.felix.dependencymanager.aspect");
                    if ((aid == null || aid != serviceId) && (aid != null || sid == null || sid != serviceId)) continue;
                    Integer ranking = (Integer)ref.getProperty("service.ranking");
                    int r = 0;
                    if (ranking != null) {
                        r = ranking;
                    }
                    if (r <= max) continue;
                    max = r;
                    result = ref;
                }
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestTrackedCache(long serviceId) {
            Long sid = serviceId;
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet services = (TreeSet)this.m_highestTrackedCache.get(sid);
                if (services != null && services.size() > 0) {
                    ServiceReference result = (ServiceReference)services.last();
                    return result;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHighestTrackedCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = (TreeSet<ServiceReference>)this.m_highestTrackedCache.get(serviceId);
                if (services == null) {
                    services = new TreeSet<ServiceReference>();
                    this.m_highestTrackedCache.put(serviceId, services);
                }
                services.add(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHighestTrackedCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet services = (TreeSet)this.m_highestTrackedCache.get(serviceId);
                if (services != null) {
                    services.remove(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearHighestTrackedCache() {
            Tracked tracked = this;
            synchronized (tracked) {
                this.m_highestTrackedCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceReference highestHiddenCache(long serviceId) {
            Long sid = serviceId;
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet services = (TreeSet)this.m_highestHiddenCache.get(sid);
                if (services != null && services.size() > 0) {
                    ServiceReference result = (ServiceReference)services.last();
                    return result;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addHighestHiddenCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet<ServiceReference> services = (TreeSet<ServiceReference>)this.m_highestHiddenCache.get(serviceId);
                if (services == null) {
                    services = new TreeSet<ServiceReference>();
                    this.m_highestHiddenCache.put(serviceId, services);
                }
                services.add(reference);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeHighestHiddenCache(ServiceReference reference) {
            Long serviceId = ServiceUtil.getServiceIdObject(reference);
            Tracked tracked = this;
            synchronized (tracked) {
                TreeSet services = (TreeSet)this.m_highestHiddenCache.get(serviceId);
                if (services != null) {
                    services.remove(reference);
                }
            }
        }

        private void hide(ServiceReference ref) {
            this.addHighestHiddenCache(ref);
        }

        private void unhide(ServiceReference ref) {
            this.removeHighestHiddenCache(ref);
        }

        Tracked() {
            this.setTracked(new HashMapCache());
        }

        void setInitial(Object[] list) {
            if (list == null) {
                return;
            }
            HashMap<Long, RankedService> highestRankedServiceMap = new HashMap<Long, RankedService>();
            for (int i = 0; i < list.length; ++i) {
                ServiceReference sr = (ServiceReference)list[i];
                if (sr == null) continue;
                Long serviceId = ServiceUtil.getServiceIdAsLong(sr);
                int ranking = ServiceUtil.getRanking(sr);
                RankedService rs = (RankedService)highestRankedServiceMap.get(serviceId);
                if (rs == null) {
                    highestRankedServiceMap.put(serviceId, new RankedService(ranking, sr));
                    continue;
                }
                if (ranking > rs.getRanking()) {
                    this.hide(rs.getServiceReference());
                    rs.update(ranking, sr);
                    continue;
                }
                this.hide(sr);
            }
            if (highestRankedServiceMap.size() > 0) {
                Object[] result = new Object[highestRankedServiceMap.size()];
                int index = 0;
                Iterator it = highestRankedServiceMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    result[index] = ((RankedService)entry.getValue()).getServiceReference();
                    ++index;
                }
                super.setInitial(result);
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (ServiceTracker.this.m_trackAllAspects) {
                this.serviceChangedIncludeAspects(event);
            } else {
                this.serviceChangedHideAspects(event);
            }
        }

        public void serviceChangedIncludeAspects(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            switch (event.getType()) {
                case 1: 
                case 2: {
                    if (ServiceTracker.this.listenerFilter != null) {
                        this.track(reference, event);
                        break;
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        this.track(reference, event);
                        break;
                    }
                    this.untrack(reference, event);
                    break;
                }
                case 4: 
                case 8: {
                    this.untrack(reference, event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void serviceChangedHideAspects(ServiceEvent event) {
            if (this.closed) {
                return;
            }
            ServiceReference reference = event.getServiceReference();
            long sid = ServiceUtil.getServiceId(reference);
            switch (event.getType()) {
                case 1: 
                case 2: {
                    ServiceReference higher = null;
                    ServiceReference lower = null;
                    ServiceReference sr = this.highestTrackedCache(sid);
                    if (sr != null) {
                        int trackedRanking;
                        int ranking = ServiceUtil.getRanking(reference);
                        if (ranking > (trackedRanking = ServiceUtil.getRanking(sr))) {
                            higher = sr;
                        } else if (ranking < trackedRanking) {
                            lower = sr;
                        }
                    }
                    if (ServiceTracker.this.listenerFilter != null) {
                        if (lower != null) {
                            this.hide(reference);
                            return;
                        }
                        try {
                            this.track(reference, event);
                            if (higher == null) return;
                        }
                        catch (Throwable throwable) {
                            if (higher == null) throw throwable;
                            try {
                                this.untrack(higher, null);
                                throw throwable;
                            }
                            finally {
                                this.hide(higher);
                            }
                        }
                        try {
                            this.untrack(higher, null);
                            return;
                        }
                        finally {
                            this.hide(higher);
                        }
                    }
                    if (ServiceTracker.this.filter.match(reference)) {
                        if (lower != null) {
                            this.hide(reference);
                            return;
                        }
                        try {
                            this.track(reference, event);
                            if (higher == null) return;
                        }
                        catch (Throwable throwable) {
                            if (higher == null) throw throwable;
                            try {
                                this.untrack(higher, null);
                                throw throwable;
                            }
                            finally {
                                this.hide(higher);
                            }
                        }
                        try {
                            this.untrack(higher, null);
                            return;
                        }
                        finally {
                            this.hide(higher);
                        }
                    }
                    ServiceReference ht = this.highestTrackedCache(sid);
                    if (reference.equals(ht)) {
                        try {
                            ServiceReference hh = this.highestHiddenCache(sid);
                            if (hh == null) return;
                            this.unhide(hh);
                            this.track(hh, null);
                            return;
                        }
                        finally {
                            this.untrack(reference, event);
                        }
                    }
                    this.unhide(reference);
                    return;
                }
                case 4: 
                case 8: {
                    ServiceReference ht = this.highestTrackedCache(sid);
                    if (reference.equals(ht)) {
                        try {
                            ServiceReference hh = this.highestHiddenCache(sid);
                            if (hh == null) return;
                            this.unhide(hh);
                            this.track(hh, null);
                            return;
                        }
                        finally {
                            this.untrack(reference, event);
                        }
                    }
                    this.unhide(reference);
                }
            }
        }

        void modified() {
            super.modified();
            ServiceTracker.this.modified();
        }

        Object customizerAdding(Object item, Object related) {
            return ServiceTracker.this.customizer.addingService((ServiceReference)item);
        }

        void customizerAdded(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.addedService((ServiceReference)item, object);
        }

        void customizerModified(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.modifiedService((ServiceReference)item, object);
        }

        void customizerRemoved(Object item, Object related, Object object) {
            ServiceTracker.this.customizer.removedService((ServiceReference)item, object);
        }

        class HashMapCache
        extends HashMap {
            HashMapCache() {
            }

            public Object put(Object key, Object value) {
                Tracked.this.addHighestTrackedCache((ServiceReference)key);
                return super.put(key, value);
            }

            public void putAll(Map m) {
                Iterator i = m.keySet().iterator();
                while (i.hasNext()) {
                    Tracked.this.addHighestTrackedCache((ServiceReference)i.next());
                }
                super.putAll(m);
            }

            public Object remove(Object key) {
                Tracked.this.removeHighestTrackedCache((ServiceReference)key);
                return super.remove(key);
            }

            public void clear() {
                Tracked.this.clearHighestTrackedCache();
                super.clear();
            }
        }
    }
}

