/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ResourceDependency;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterService;

public class ResourceAdapterServiceImpl
extends FilterService {
    private Object m_callbackInstance = null;
    private String m_callbackChanged = "changed";
    private String m_callbackAdded = "setResource";

    public ResourceAdapterServiceImpl(DependencyManager dm, String resourceFilter, boolean propagate, Object callbackInstance, String callbackSet, String callbackChanged) {
        super(dm.createComponent());
        this.m_callbackInstance = callbackInstance;
        this.m_callbackAdded = callbackSet;
        this.m_callbackChanged = callbackChanged;
        this.m_component.setImplementation(new ResourceAdapterImpl(propagate)).add(dm.createResourceDependency().setFilter(resourceFilter).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    public ResourceAdapterServiceImpl(DependencyManager dm, String resourceFilter, Object propagateCallbackInstance, String propagateCallbackMethod, Object callbackInstance, String callbackSet, String callbackChanged) {
        super(dm.createComponent());
        this.m_callbackInstance = callbackInstance;
        this.m_callbackAdded = callbackSet;
        this.m_callbackChanged = callbackChanged;
        this.m_component.setImplementation(new ResourceAdapterImpl(propagateCallbackInstance, propagateCallbackMethod)).add(dm.createResourceDependency().setFilter(resourceFilter).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    public class ResourceAdapterImpl
    extends AbstractDecorator {
        private final boolean m_propagate;
        private final Object m_propagateCallbackInstance;
        private final String m_propagateCallbackMethod;

        public ResourceAdapterImpl(boolean propagate) {
            this(propagate, null, null);
        }

        public ResourceAdapterImpl(Object propagateCallbackInstance, String propagateCallbackMethod) {
            this(true, propagateCallbackInstance, propagateCallbackMethod);
        }

        private ResourceAdapterImpl(boolean propagate, Object propagateCallbackInstance, String propagateCallbackMethod) {
            this.m_propagate = propagate;
            this.m_propagateCallbackInstance = propagateCallbackInstance;
            this.m_propagateCallbackMethod = propagateCallbackMethod;
        }

        public Component createService(Object[] properties) {
            int i;
            URL resource = (URL)properties[0];
            Properties props = new Properties();
            if (ResourceAdapterServiceImpl.this.m_serviceProperties != null) {
                Enumeration e = ResourceAdapterServiceImpl.this.m_serviceProperties.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    props.put(key, ResourceAdapterServiceImpl.this.m_serviceProperties.get(key));
                }
            }
            List dependencies = ResourceAdapterServiceImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            ResourceDependency resourceDependency = this.m_manager.createResourceDependency().setResource(resource).setCallbacks(ResourceAdapterServiceImpl.this.m_callbackInstance, ResourceAdapterServiceImpl.this.m_callbackAdded, ResourceAdapterServiceImpl.this.m_callbackChanged, null).setAutoConfig(ResourceAdapterServiceImpl.this.m_callbackAdded == null).setRequired(true);
            if (this.m_propagateCallbackInstance != null && this.m_propagateCallbackMethod != null) {
                resourceDependency.setPropagate(this.m_propagateCallbackInstance, this.m_propagateCallbackMethod);
            } else {
                resourceDependency.setPropagate(this.m_propagate);
            }
            Component service = this.m_manager.createComponent().setInterface(ResourceAdapterServiceImpl.this.m_serviceInterfaces, (Dictionary)props).setImplementation(ResourceAdapterServiceImpl.this.m_serviceImpl).setFactory(ResourceAdapterServiceImpl.this.m_factory, ResourceAdapterServiceImpl.this.m_factoryCreateMethod).setComposition(ResourceAdapterServiceImpl.this.m_compositionInstance, ResourceAdapterServiceImpl.this.m_compositionMethod).setCallbacks(ResourceAdapterServiceImpl.this.m_callbackObject, ResourceAdapterServiceImpl.this.m_init, ResourceAdapterServiceImpl.this.m_start, ResourceAdapterServiceImpl.this.m_stop, ResourceAdapterServiceImpl.this.m_destroy).add(resourceDependency);
            this.configureAutoConfigState(service, ResourceAdapterServiceImpl.this.m_component);
            for (i = 0; i < dependencies.size(); ++i) {
                service.add(((Dependency)dependencies.get(i)).createCopy());
            }
            for (i = 0; i < ResourceAdapterServiceImpl.this.m_stateListeners.size(); ++i) {
                service.addStateListener((ComponentStateListener)ResourceAdapterServiceImpl.this.m_stateListeners.get(i));
            }
            return service;
        }
    }
}

