/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.mojo;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.felix.scrplugin.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.helper.StringUtils;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenJavaClassDescriptorManager
extends JavaClassDescriptorManager {
    private final MavenProject project;
    private final String excludeString;
    private JavaSource[] sources;
    private Map<String, Component> componentDescriptions;

    public MavenJavaClassDescriptorManager(MavenProject project, Log log, ClassLoader classLoader, String[] annotationTagProviders, String excludeString, boolean parseJavadocs, boolean processAnnotations) throws SCRDescriptorFailureException {
        super(log, classLoader, annotationTagProviders, parseJavadocs, processAnnotations);
        this.project = project;
        this.excludeString = excludeString;
    }

    @Override
    public String getOutputDirectory() {
        return this.project.getBuild().getOutputDirectory();
    }

    @Override
    protected JavaSource[] getSources() throws SCRDescriptorException {
        if (this.sources == null) {
            this.log.debug("Setting up QDox");
            JavaDocBuilder builder = new JavaDocBuilder();
            builder.getClassLibrary().addClassLoader(this.getClassLoader());
            Iterator i = this.project.getCompileSourceRoots().iterator();
            if (this.excludeString != null) {
                String[] excludes = StringUtils.split(this.excludeString, ",");
                String[] includes = new String[]{"**/*.java"};
                while (i.hasNext()) {
                    String tree = (String)i.next();
                    this.log.debug("Scanning source tree " + tree);
                    File directory = new File(tree);
                    DirectoryScanner scanner = new DirectoryScanner();
                    scanner.setBasedir(directory);
                    if (excludes != null && excludes.length > 0) {
                        scanner.setExcludes(excludes);
                    }
                    scanner.addDefaultExcludes();
                    scanner.setIncludes(includes);
                    scanner.scan();
                    String[] files = scanner.getIncludedFiles();
                    if (files == null) continue;
                    for (int m = 0; m < files.length; ++m) {
                        this.log.debug("Adding source file " + files[m]);
                        try {
                            builder.addSource(new File(directory, files[m]));
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            throw new SCRDescriptorException("Unable to scan directory.", files[m], 0, e);
                        }
                        catch (IOException e) {
                            throw new SCRDescriptorException("Unable to scan directory.", files[m], 0, e);
                        }
                    }
                }
            } else {
                while (i.hasNext()) {
                    String tree = (String)i.next();
                    this.log.debug("Adding source tree " + tree);
                    File directory = new File(tree);
                    builder.addSourceTree(directory);
                }
            }
            this.sources = builder.getSources();
        }
        return this.sources;
    }

    @Override
    protected Map<String, Component> getComponentDescriptors() throws SCRDescriptorException {
        if (this.componentDescriptions == null) {
            this.componentDescriptions = new HashMap<String, Component>();
            ArrayList<Component> components = new ArrayList<Component>();
            Map resolved = this.project.getArtifactMap();
            Set artifacts = this.project.getDependencyArtifacts();
            for (Artifact declared : artifacts) {
                this.log.debug("Checking artifact " + declared);
                if (this.isJavaArtifact(declared)) {
                    if ("compile".equals(declared.getScope()) || "runtime".equals(declared.getScope()) || "provided".equals(declared.getScope())) {
                        this.log.debug("Resolving artifact " + declared);
                        Artifact artifact = (Artifact)resolved.get(ArtifactUtils.versionlessKey((Artifact)declared));
                        if (artifact != null) {
                            this.log.debug("Trying to get manifest from artifact " + artifact);
                            try {
                                Manifest manifest = this.getManifest(artifact);
                                if (manifest != null) {
                                    if (manifest.getMainAttributes().getValue("Service-Component") != null) {
                                        String serviceComponent = manifest.getMainAttributes().getValue("Service-Component");
                                        this.log.debug("Found Service-Component: " + serviceComponent + " in artifact " + artifact);
                                        StringTokenizer st = new StringTokenizer(serviceComponent, ",");
                                        while (st.hasMoreTokens()) {
                                            Components c;
                                            String entry = st.nextToken().trim();
                                            if (entry.length() <= 0 || (c = this.readServiceComponentDescriptor(artifact, entry)) == null) continue;
                                            components.addAll(c.getComponents());
                                        }
                                    } else {
                                        this.log.debug("Artifact has no service component entry in manifest " + artifact);
                                    }
                                } else {
                                    this.log.debug("Unable to get manifest from artifact " + artifact);
                                }
                            }
                            catch (IOException ioe) {
                                throw new SCRDescriptorException("Unable to get manifest from artifact", artifact.toString(), 0, ioe);
                            }
                            this.log.debug("Trying to get scrinfo from artifact " + artifact);
                            InputStream scrInfoFile = null;
                            try {
                                scrInfoFile = this.getFile(artifact, "OSGI-INF/scr-plugin/scrinfo.xml");
                                if (scrInfoFile != null) {
                                    components.addAll(this.parseServiceComponentDescriptor(scrInfoFile).getComponents());
                                    continue;
                                }
                                this.log.debug("Artifact has no scrinfo file (it's optional): " + artifact);
                                continue;
                            }
                            catch (IOException ioe) {
                                throw new SCRDescriptorException("Unable to get scrinfo from artifact", artifact.toString(), 0, ioe);
                            }
                            finally {
                                if (scrInfoFile == null) continue;
                                try {
                                    scrInfoFile.close();
                                    continue;
                                }
                                catch (IOException ignore) {}
                            }
                        }
                        this.log.debug("Unable to resolve artifact " + declared);
                        continue;
                    }
                    this.log.debug("Artifact " + declared + " has not scope compile or runtime, but " + declared.getScope());
                    continue;
                }
                this.log.debug("Artifact " + declared + " is not a java artifact, type is " + declared.getType());
            }
            for (Component component : components) {
                this.componentDescriptions.put(component.getImplementation().getClassame(), component);
            }
        }
        return this.componentDescriptions;
    }

    private boolean isJavaArtifact(Artifact artifact) {
        if ("jar".equals(artifact.getType())) {
            return true;
        }
        return "bundle".equals(artifact.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Components readServiceComponentDescriptor(Artifact artifact, String entry) {
        this.log.debug("Reading " + entry + " from " + artifact);
        InputStream xml = null;
        try {
            xml = this.getFile(artifact, entry);
            if (xml == null) {
                throw new SCRDescriptorException("Entry " + entry + " not contained in artifact", artifact.toString(), 0);
            }
            Components components = this.parseServiceComponentDescriptor(xml);
            return components;
        }
        catch (IOException mee) {
            this.log.warn("Unable to read SCR descriptor file from artifact " + artifact + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        catch (SCRDescriptorException mee) {
            this.log.warn("Unable to read SCR descriptor file from artifact " + artifact + " at " + entry);
            this.log.debug("Exception occurred during reading: " + mee.getMessage(), mee);
        }
        finally {
            if (xml != null) {
                try {
                    xml.close();
                }
                catch (IOException ignore) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getManifest(Artifact artifact) throws IOException {
        JarFile file = null;
        try {
            file = new JarFile(artifact.getFile());
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getFile(Artifact artifact, String path) throws IOException {
        JarFile file = null;
        try {
            file = new JarFile(artifact.getFile());
            JarEntry entry = file.getJarEntry(path);
            if (entry != null) {
                ArtifactFileInputStream stream = new ArtifactFileInputStream(file, entry);
                file = null;
                ArtifactFileInputStream artifactFileInputStream = stream;
                return artifactFileInputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static class ArtifactFileInputStream
    extends FilterInputStream {
        final JarFile jarFile;

        ArtifactFileInputStream(JarFile jarFile, JarEntry jarEntry) throws IOException {
            super(jarFile.getInputStream(jarEntry));
            this.jarFile = jarFile;
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFile.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

