/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scrplugin.Constants;
import org.apache.felix.scrplugin.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.Log;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.helper.IssueLog;
import org.apache.felix.scrplugin.helper.PropertyHandler;
import org.apache.felix.scrplugin.helper.StringUtils;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.om.metatype.Designate;
import org.apache.felix.scrplugin.om.metatype.MTObject;
import org.apache.felix.scrplugin.om.metatype.MetaData;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptionInheritanceComparator;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.ModifiableJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.apache.felix.scrplugin.xml.MetaTypeIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCRDescriptorGenerator {
    private final Log logger;
    private File outputDirectory = null;
    private JavaClassDescriptorManager descriptorManager;
    private String finalName = "serviceComponents.xml";
    private String metaTypeName = "metatype.xml";
    private boolean generateAccessors = true;
    protected boolean strictMode = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private String specVersion = null;

    public SCRDescriptorGenerator(Log logger) {
        this.logger = logger;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setDescriptorManager(JavaClassDescriptorManager descriptorManager) {
        this.descriptorManager = descriptorManager;
    }

    public void setFinalName(String finalName) {
        this.finalName = finalName;
    }

    public void setMetaTypeName(String metaTypeName) {
        this.metaTypeName = metaTypeName;
    }

    public void setGenerateAccessors(boolean generateAccessors) {
        this.generateAccessors = generateAccessors;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public boolean execute() throws SCRDescriptorException, SCRDescriptorFailureException {
        File descriptorFile;
        this.logger.debug("Starting SCRDescriptorMojo....");
        this.logger.debug("..generating accessors: " + this.generateAccessors);
        this.logger.debug("..parsing javadocs: " + this.descriptorManager.isParseJavadocs());
        this.logger.debug("..processing annotations: " + this.descriptorManager.isProcessAnnotations());
        int specVersion = this.toSpecVersionCode(this.specVersion, null);
        if (this.specVersion == null) {
            this.logger.debug("..auto detecting spec version");
        } else {
            this.logger.debug("..using spec version " + this.specVersion + " (" + specVersion + ")");
        }
        IssueLog iLog = new IssueLog(this.strictMode);
        MetaData metaData = new MetaData();
        metaData.setLocalization("OSGI-INF/metatype/metatype");
        JavaClassDescription[] javaSources = this.descriptorManager.getSourceDescriptions();
        Arrays.sort(javaSources, new JavaClassDescriptionInheritanceComparator());
        ArrayList<Component> scannedComponents = new ArrayList<Component>();
        for (int i = 0; i < javaSources.length; ++i) {
            this.logger.debug("Testing source " + javaSources[i].getName());
            JavaTag tag = javaSources[i].getTagByName("scr.component");
            if (tag == null) continue;
            this.logger.debug("Processing service class " + javaSources[i].getName());
            if (javaSources[i].getTagsByName("scr.component", false).length > 1) {
                iLog.addError("Class " + javaSources[i].getName() + " has more than one " + "scr.component" + " tag." + " Merge the tags to a single tag.", tag.getSourceLocation(), tag.getLineNumber());
                continue;
            }
            try {
                Component comp = this.createComponent(javaSources[i], tag, metaData, iLog);
                if (comp.getSpecVersion() > specVersion) {
                    if (this.specVersion != null) {
                        String v = "1.0";
                        if (comp.getSpecVersion() == 1) {
                            v = "1.1";
                        }
                        iLog.addError("Component " + comp + " requires spec version " + v + " but plugin is configured to use version " + this.specVersion, tag.getSourceLocation(), tag.getLineNumber());
                    }
                    specVersion = comp.getSpecVersion();
                }
                scannedComponents.add(comp);
                continue;
            }
            catch (SCRDescriptorException sde) {
                iLog.addError(sde.getMessage(), sde.getSourceLocation(), sde.getLineNumber());
            }
        }
        this.logger.debug("..generating descriptor for spec version: " + this.specVersion);
        Components components = new Components();
        Components abstractComponents = new Components();
        components.setSpecVersion(specVersion);
        abstractComponents.setSpecVersion(specVersion);
        for (Component comp : scannedComponents) {
            int errorCount = iLog.getNumberOfErrors();
            for (Reference ref : comp.getReferences()) {
                if (!this.generateAccessors || ref.isLookupStrategy() || ref.getJavaTag().getField() == null || !(comp.getJavaClassDescription() instanceof ModifiableJavaClassDescription) || !ref.getCardinality().equals("0..1") && !ref.getCardinality().equals("1..1")) continue;
                String bindValue = ref.getBind();
                String unbindValue = ref.getUnbind();
                String name = ref.getName();
                String type = ref.getInterfacename();
                boolean createBind = false;
                boolean createUnbind = false;
                if (bindValue == null && ref.findMethod(specVersion, "bind") == null) {
                    createBind = true;
                }
                if (unbindValue == null && ref.findMethod(specVersion, "unbind") == null) {
                    createUnbind = true;
                }
                if (!createBind && !createUnbind) continue;
                ((ModifiableJavaClassDescription)((Object)comp.getJavaClassDescription())).addMethods(name, type, createBind, createUnbind);
            }
            comp.validate(specVersion, iLog);
            if (iLog.getNumberOfErrors() != errorCount) continue;
            if (!comp.isDs()) {
                this.logger.debug("Ignoring descriptor " + comp);
                continue;
            }
            if (comp.isAbstract()) {
                this.logger.debug("Adding abstract descriptor " + comp);
                abstractComponents.addComponent(comp);
                continue;
            }
            this.logger.debug("Adding descriptor " + comp);
            components.addComponent(comp);
            abstractComponents.addComponent(comp);
        }
        iLog.logMessages(this.logger);
        if (iLog.hasErrors()) {
            throw new SCRDescriptorFailureException("SCR Descriptor parsing had failures (see log)");
        }
        boolean addResources = false;
        if (!StringUtils.isEmpty(this.metaTypeName)) {
            File mtFile = new File(this.outputDirectory, "OSGI-INF" + File.separator + "metatype" + File.separator + this.metaTypeName);
            int size = metaData.getOCDs().size() + metaData.getDesignates().size();
            if (size > 0) {
                this.logger.info("Generating " + size + " MetaType Descriptors to " + mtFile);
                mtFile.getParentFile().mkdirs();
                MetaTypeIO.write(metaData, mtFile);
                addResources = true;
            } else if (mtFile.exists()) {
                mtFile.delete();
            }
        } else {
            this.logger.info("Meta type file name is not set: meta type info is not written.");
        }
        File adFile = new File(this.outputDirectory, Constants.ABSTRACT_DESCRIPTOR_RELATIVE_PATH);
        if (!abstractComponents.getComponents().isEmpty()) {
            this.logger.info("Writing abstract service descriptor " + adFile + " with " + abstractComponents.getComponents().size() + " entries.");
            adFile.getParentFile().mkdirs();
            ComponentDescriptorIO.write(abstractComponents, adFile, true);
            addResources = true;
        } else {
            this.logger.debug("No abstract SCR Descriptors found in project.");
            if (adFile.exists()) {
                this.logger.debug("Removing obsolete abstract service descriptor " + adFile);
                adFile.delete();
            }
        }
        File file = descriptorFile = StringUtils.isEmpty(this.finalName) ? null : new File(new File(this.outputDirectory, "OSGI-INF"), this.finalName);
        if (components.getComponents().isEmpty()) {
            this.logger.debug("No SCR Descriptors found in project.");
            if (descriptorFile != null && descriptorFile.exists()) {
                this.logger.debug("Removing obsolete service descriptor " + descriptorFile);
                descriptorFile.delete();
            }
        } else {
            if (descriptorFile == null) {
                throw new SCRDescriptorFailureException("Descriptor file name must not be empty.");
            }
            descriptorFile.getParentFile().mkdirs();
            this.logger.info("Generating " + components.getComponents().size() + " Service Component Descriptors to " + descriptorFile);
            ComponentDescriptorIO.write(components, descriptorFile, false);
            addResources = true;
        }
        return addResources;
    }

    protected Component createComponent(JavaClassDescription description, JavaTag componentTag, MetaData metaData, IssueLog iLog) throws SCRDescriptorException {
        JavaTag tag;
        Component component = new Component(componentTag);
        component.setImplementation(new Implementation(description.getName()));
        OCD ocd = this.doComponent(componentTag, component, metaData, iLog);
        boolean inherited = SCRDescriptorGenerator.getBoolean(componentTag, "inherit", true);
        this.doServices(description.getTagsByName("scr.service", inherited), component, description);
        HashMap<String, Object[]> references = new HashMap<String, Object[]>();
        PropertyHandler propertyHandler = new PropertyHandler(component, ocd);
        JavaClassDescription currentDescription = description;
        do {
            JavaTag[] props = currentDescription.getTagsByName("scr.property", false);
            for (int i = 0; i < props.length; ++i) {
                propertyHandler.testProperty(props[i], null, description == currentDescription);
            }
            JavaTag[] refs = currentDescription.getTagsByName("scr.reference", false);
            for (int i = 0; i < refs.length; ++i) {
                this.testReference(references, refs[i], null, description == currentDescription);
            }
            JavaField[] fields = currentDescription.getFields();
            for (int i = 0; i < fields.length; ++i) {
                tag = fields[i].getTagByName("scr.reference");
                if (tag != null) {
                    this.testReference(references, tag, fields[i].getName(), description == currentDescription);
                }
                propertyHandler.handleField(fields[i], description == currentDescription);
            }
            currentDescription = currentDescription.getSuperClass();
        } while (inherited && currentDescription != null);
        propertyHandler.processProperties(this.properties, iLog);
        for (Map.Entry entry : references.entrySet()) {
            String refName = (String)entry.getKey();
            Object[] values = (Object[])entry.getValue();
            tag = (JavaTag)values[0];
            this.doReference(tag, refName, component, values[1].toString());
        }
        boolean createPid = SCRDescriptorGenerator.getBoolean(componentTag, "create-pid", true);
        if (createPid) {
            boolean found = false;
            Iterator<Property> iter = component.getProperties().iterator();
            while (!found && iter.hasNext()) {
                Property prop = iter.next();
                found = "service.pid".equals(prop.getName());
            }
            if (!found) {
                Property pid = new Property();
                component.addProperty(pid);
                pid.setName("service.pid");
                pid.setValue(component.getName());
            }
        }
        return component;
    }

    protected OCD doComponent(JavaTag tag, Component component, MetaData metaData, IssueLog iLog) throws SCRDescriptorException {
        String metaType;
        boolean hasMetaType;
        String abstractType = tag.getNamedParameter("abstract");
        if (abstractType != null) {
            component.setAbstract("yes".equalsIgnoreCase(abstractType) || "true".equalsIgnoreCase(abstractType));
        } else {
            component.setAbstract(tag.getJavaClassDescription().isAbstract());
        }
        String ds = tag.getNamedParameter("ds");
        component.setDs(ds == null ? true : "yes".equalsIgnoreCase(ds) || "true".equalsIgnoreCase(ds));
        String name = tag.getNamedParameter("name");
        component.setName(StringUtils.isEmpty(name) ? component.getImplementation().getClassame() : name);
        component.setEnabled(SCRDescriptorGenerator.getBoolean(tag, "enabled", true));
        component.setFactory(tag.getNamedParameter("factory"));
        String dsSpecVersion = tag.getNamedParameter("specVersion");
        if (dsSpecVersion != null) {
            component.setSpecVersion(this.toSpecVersionCode(dsSpecVersion, tag));
        }
        if (tag.getNamedParameter("immediate") != null) {
            component.setImmediate(SCRDescriptorGenerator.getBoolean(tag, "immediate", true));
        }
        if (tag.getNamedParameter("policy") != null) {
            component.setSpecVersion(1);
            component.setConfigurationPolicy(tag.getNamedParameter("policy"));
        }
        if (tag.getNamedParameter("activate") != null) {
            component.setSpecVersion(1);
            component.setActivate(tag.getNamedParameter("activate"));
        }
        if (tag.getNamedParameter("deactivate") != null) {
            component.setSpecVersion(1);
            component.setDeactivate(tag.getNamedParameter("deactivate"));
        }
        if (tag.getNamedParameter("modified") != null) {
            component.setSpecVersion(1);
            component.setModified(tag.getNamedParameter("modified"));
        }
        boolean bl = hasMetaType = (metaType = tag.getNamedParameter("metatype")) == null || "yes".equalsIgnoreCase(metaType) || "true".equalsIgnoreCase(metaType);
        if (hasMetaType) {
            boolean setFactoryPid;
            OCD ocd = new OCD();
            metaData.addOCD(ocd);
            ocd.setId(component.getName());
            String ocdName = tag.getNamedParameter("label");
            if (ocdName == null) {
                ocdName = "%" + component.getName() + ".name";
            }
            ocd.setName(ocdName);
            String ocdDescription = tag.getNamedParameter("description");
            if (ocdDescription == null) {
                ocdDescription = "%" + component.getName() + ".description";
            }
            ocd.setDescription(ocdDescription);
            Designate designate = new Designate();
            metaData.addDesignate(designate);
            designate.setPid(component.getName());
            String setFactoryPidValue = tag.getNamedParameter("configurationFactory");
            boolean bl2 = setFactoryPid = setFactoryPidValue != null && ("yes".equalsIgnoreCase(setFactoryPidValue) || "true".equalsIgnoreCase(setFactoryPidValue));
            if (setFactoryPid) {
                if (component.getFactory() == null) {
                    designate.setFactoryPid(component.getName());
                } else {
                    iLog.addWarning("Component factory " + component.getName() + " should not set metatype factory pid.", tag.getSourceLocation(), tag.getLineNumber());
                }
            }
            MTObject mtobject = new MTObject();
            designate.setObject(mtobject);
            mtobject.setOcdref(component.getName());
            return ocd;
        }
        return null;
    }

    protected void doServices(JavaTag[] services, Component component, JavaClassDescription description) throws SCRDescriptorException {
        if (services == null || services.length == 0) {
            return;
        }
        Service service = new Service();
        component.setService(service);
        boolean serviceFactory = false;
        for (int i = 0; i < services.length; ++i) {
            String name = services[i].getNamedParameter("interface");
            if (StringUtils.isEmpty(name)) {
                this.addInterfaces(service, services[i], description);
            } else {
                String interfaceName = name;
                if (description instanceof QDoxJavaClassDescription) {
                    JavaClassDescription serviceClass = description.getReferencedClass(name);
                    if (serviceClass == null) {
                        throw new SCRDescriptorException("Interface '" + name + "' in class " + description.getName() + " does not point to a valid class/interface.", services[i]);
                    }
                    interfaceName = serviceClass.getName();
                }
                Interface interf = new Interface(services[i]);
                interf.setInterfacename(interfaceName);
                service.addInterface(interf);
            }
            serviceFactory |= SCRDescriptorGenerator.getBoolean(services[i], "servicefactory", false);
        }
        service.setServicefactory(serviceFactory);
    }

    protected void addInterfaces(Service service, JavaTag serviceTag, JavaClassDescription description) throws SCRDescriptorException {
        if (description != null) {
            JavaClassDescription[] interfaces = description.getImplementedInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                Interface interf = new Interface(serviceTag);
                interf.setInterfacename(interfaces[j].getName());
                service.addInterface(interf);
                this.addInterfaces(service, serviceTag, interfaces[j]);
            }
            this.addInterfaces(service, serviceTag, description.getSuperClass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void testReference(Map<String, Object[]> references, JavaTag reference, String defaultName, boolean isInspectedClass) throws SCRDescriptorException {
        String refName = this.getReferenceName(reference, defaultName);
        if (refName == null) return;
        if (references.containsKey(refName)) {
            if (!isInspectedClass) return;
            throw new SCRDescriptorException("Duplicate definition for reference " + refName + " in class " + reference.getJavaClassDescription().getName(), reference);
        }
        String type = reference.getNamedParameter("interface");
        if (StringUtils.isEmpty(type)) {
            if (reference.getField() == null) throw new SCRDescriptorException("Interface missing for reference " + refName + " in class " + reference.getJavaClassDescription().getName(), reference);
            type = reference.getField().getType();
        } else if (isInspectedClass) {
            JavaClassDescription serviceClass = reference.getJavaClassDescription().getReferencedClass(type);
            if (serviceClass == null) {
                throw new SCRDescriptorException("Interface '" + type + "' in class " + reference.getJavaClassDescription().getName() + " does not point to a valid class/interface.", reference);
            }
            type = serviceClass.getName();
        }
        references.put(refName, new Object[]{reference, type});
    }

    protected String getReferenceName(JavaTag reference, String defaultName) throws SCRDescriptorException {
        String name = reference.getNamedParameter("name");
        if (!StringUtils.isEmpty(name)) {
            return name;
        }
        name = reference.getNamedParameter("nameRef");
        if (!StringUtils.isEmpty(name)) {
            JavaField refField = this.getReferencedField(reference, name);
            String[] values = refField.getInitializationExpression();
            if (values == null || values.length == 0) {
                throw new SCRDescriptorException("Referenced field for " + name + " has no values for a reference name.", reference);
            }
            if (values.length > 1) {
                throw new SCRDescriptorException("Referenced field " + name + " has more than one value for a reference name.", reference);
            }
            name = values[0];
        }
        return defaultName;
    }

    protected JavaField getReferencedField(JavaTag tag, String ref) throws SCRDescriptorException {
        int classSep = ref.lastIndexOf(46);
        JavaField field = null;
        if (classSep == -1) {
            field = tag.getJavaClassDescription().getFieldByName(ref);
        }
        if (field == null) {
            field = tag.getJavaClassDescription().getExternalFieldByName(ref);
        }
        if (field == null) {
            throw new SCRDescriptorException("Reference references unknown field " + ref + " in class " + tag.getJavaClassDescription().getName(), tag);
        }
        return field;
    }

    protected void doReference(JavaTag reference, String name, Component component, String type) throws SCRDescriptorException {
        String strategy;
        String isChecked;
        String updatedValue;
        String unbindValue;
        Reference ref = new Reference(reference, component.getJavaClassDescription());
        ref.setName(name);
        ref.setInterfacename(type);
        ref.setCardinality(reference.getNamedParameter("cardinality"));
        if (ref.getCardinality() == null) {
            ref.setCardinality("1..1");
        }
        ref.setPolicy(reference.getNamedParameter("policy"));
        if (ref.getPolicy() == null) {
            ref.setPolicy("static");
        }
        ref.setTarget(reference.getNamedParameter("target"));
        String bindValue = reference.getNamedParameter("bind");
        if (bindValue != null) {
            ref.setBind(bindValue);
        }
        if ((unbindValue = reference.getNamedParameter("unbind")) != null) {
            ref.setUnbind(unbindValue);
        }
        if ((updatedValue = reference.getNamedParameter("updated")) != null) {
            ref.setUpdated(updatedValue);
        }
        if ((isChecked = reference.getNamedParameter("checked")) != null) {
            ref.setChecked(Boolean.valueOf(isChecked));
        }
        if ((strategy = reference.getNamedParameter("strategy")) != null) {
            ref.setStrategy(strategy);
        }
        component.addReference(ref);
    }

    public static boolean getBoolean(JavaTag tag, String name, boolean defaultValue) {
        String value = tag.getNamedParameter(name);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }

    private int toSpecVersionCode(String specVersion, JavaTag tag) throws SCRDescriptorException {
        if (specVersion == null || specVersion.equals("1.0")) {
            return 0;
        }
        if (specVersion.equals("1.1")) {
            return 1;
        }
        if (specVersion.equals("1.1-felix")) {
            return 2;
        }
        throw new SCRDescriptorException("Unsupported or unknown DS spec version: " + specVersion, tag);
    }
}

