/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;

public class IssueLog {
    private final boolean strictMode;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public IssueLog(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public int getNumberOfErrors() {
        return this.errors.size();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0 || this.strictMode && this.warnings.size() > 0;
    }

    public void addError(String e) {
        this.errors.add(e);
    }

    public void addWarning(String e) {
        this.warnings.add(e);
    }

    public void log(Log log) {
        for (String warn : this.warnings) {
            if (this.strictMode) {
                log.error((CharSequence)warn);
                continue;
            }
            log.warn((CharSequence)warn);
        }
        for (String err : this.errors) {
            log.error((CharSequence)err);
        }
    }
}

