/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.felix.scrplugin.Constants;
import org.apache.felix.scrplugin.PropertyHandler;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Components;
import org.apache.felix.scrplugin.om.Implementation;
import org.apache.felix.scrplugin.om.Interface;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.Reference;
import org.apache.felix.scrplugin.om.Service;
import org.apache.felix.scrplugin.om.metatype.Designate;
import org.apache.felix.scrplugin.om.metatype.MTObject;
import org.apache.felix.scrplugin.om.metatype.MetaData;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.tags.JavaClassDescription;
import org.apache.felix.scrplugin.tags.JavaClassDescriptionInheritanceComparator;
import org.apache.felix.scrplugin.tags.JavaClassDescriptorManager;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.ModifiableJavaClassDescription;
import org.apache.felix.scrplugin.tags.qdox.QDoxJavaClassDescription;
import org.apache.felix.scrplugin.xml.ComponentDescriptorIO;
import org.apache.felix.scrplugin.xml.MetaTypeIO;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class SCRDescriptorMojo
extends AbstractMojo {
    private File outputDirectory;
    private MavenProject project;
    private String finalName;
    private String metaTypeName;
    private boolean generateAccessors;
    private String sourceExcludes;
    private Map properties = new HashMap();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File descriptorFile;
        this.getLog().debug((CharSequence)"Starting SCRDescriptorMojo....");
        this.getLog().debug((CharSequence)("..generating accessors: " + this.generateAccessors));
        boolean hasFailures = false;
        JavaClassDescriptorManager jManager = new JavaClassDescriptorManager(this.getLog(), this.project, this.sourceExcludes);
        JavaClassDescription[] javaSources = jManager.getSourceDescriptions();
        Arrays.sort(javaSources, new JavaClassDescriptionInheritanceComparator());
        Components components = new Components();
        Components abstractComponents = new Components();
        MetaData metaData = new MetaData();
        metaData.setLocalization("OSGI-INF/metatype/metatype");
        for (int i = 0; i < javaSources.length; ++i) {
            this.getLog().debug((CharSequence)("Testing source " + javaSources[i].getName()));
            JavaTag tag = javaSources[i].getTagByName("scr.component");
            if (tag == null) continue;
            this.getLog().debug((CharSequence)("Processing service class " + javaSources[i].getName()));
            if (javaSources[i].getTagsByName("scr.component", false).length > 1) {
                hasFailures = true;
                this.getLog().error((CharSequence)("Class " + javaSources[i].getName() + " has more than one " + "scr.component" + " tag." + " Merge the tags to a single tag."));
                continue;
            }
            Component comp = this.createComponent(javaSources[i], tag, metaData);
            if (comp != null) {
                if (!comp.isDs()) {
                    this.getLog().debug((CharSequence)("Not adding descriptor " + comp));
                    continue;
                }
                if (comp.isAbstract()) {
                    this.getLog().debug((CharSequence)("Adding abstract descriptor " + comp));
                    abstractComponents.addComponent(comp);
                    continue;
                }
                this.getLog().debug((CharSequence)("Adding descriptor " + comp));
                components.addComponent(comp);
                abstractComponents.addComponent(comp);
                continue;
            }
            hasFailures = true;
        }
        if (hasFailures) {
            throw new MojoFailureException("SCR Descriptor parsing had failures (see log)");
        }
        boolean addResources = false;
        if (!StringUtils.isEmpty((String)this.metaTypeName)) {
            File mtFile = new File(this.outputDirectory, "OSGI-INF" + File.separator + "metatype" + File.separator + this.metaTypeName);
            if (metaData.getDescriptors().size() > 0) {
                this.getLog().info((CharSequence)("Generating " + metaData.getDescriptors().size() + " MetaType Descriptors to " + mtFile));
                mtFile.getParentFile().mkdirs();
                MetaTypeIO.write(metaData, mtFile);
                addResources = true;
            } else if (mtFile.exists()) {
                mtFile.delete();
            }
        } else {
            this.getLog().info((CharSequence)"Meta type file name is not set: meta type info is not written.");
        }
        File adFile = new File(this.outputDirectory, Constants.ABSTRACT_DESCRIPTOR_RELATIVE_PATH);
        if (!abstractComponents.getComponents().isEmpty()) {
            this.getLog().info((CharSequence)("Writing abstract service descriptor " + adFile + " with " + abstractComponents.getComponents().size() + " entries."));
            adFile.getParentFile().mkdirs();
            ComponentDescriptorIO.write(abstractComponents, adFile, true);
            addResources = true;
        } else {
            this.getLog().debug((CharSequence)"No abstract SCR Descriptors found in project.");
            if (adFile.exists()) {
                this.getLog().debug((CharSequence)("Removing obsolete abstract service descriptor " + adFile));
                adFile.delete();
            }
        }
        File file = descriptorFile = StringUtils.isEmpty((String)this.finalName) ? null : new File(new File(this.outputDirectory, "OSGI-INF"), this.finalName);
        if (components.getComponents().isEmpty()) {
            this.getLog().debug((CharSequence)"No SCR Descriptors found in project.");
            if (descriptorFile != null && descriptorFile.exists()) {
                this.getLog().debug((CharSequence)("Removing obsolete service descriptor " + descriptorFile));
                descriptorFile.delete();
            }
        } else {
            if (descriptorFile == null) {
                throw new MojoFailureException("Descriptor file name must not be empty.");
            }
            descriptorFile.getParentFile().mkdirs();
            this.getLog().info((CharSequence)("Generating " + components.getComponents().size() + " Service Component Descriptors to " + descriptorFile));
            ComponentDescriptorIO.write(components, descriptorFile, false);
            addResources = true;
            String svcComp = this.project.getProperties().getProperty("Service-Component");
            svcComp = svcComp == null ? "OSGI-INF/" + this.finalName : svcComp + ", " + "OSGI-INF/" + this.finalName;
            this.project.getProperties().setProperty("Service-Component", svcComp);
        }
        if (addResources) {
            String ourRsrcPath = this.outputDirectory.getAbsolutePath();
            boolean found = false;
            Iterator rsrcIterator = this.project.getResources().iterator();
            while (!found && rsrcIterator.hasNext()) {
                Resource rsrc = (Resource)rsrcIterator.next();
                found = rsrc.getDirectory().equals(ourRsrcPath);
            }
            if (!found) {
                Resource resource = new Resource();
                resource.setDirectory(this.outputDirectory.getAbsolutePath());
                this.project.addResource(resource);
            }
        }
    }

    protected Component createComponent(JavaClassDescription description, JavaTag componentTag, MetaData metaData) throws MojoExecutionException {
        JavaTag tag;
        Component component = new Component(componentTag);
        component.setImplementation(new Implementation(description.getName()));
        OCD ocd = this.doComponent(componentTag, component, metaData);
        boolean inherited = SCRDescriptorMojo.getBoolean(componentTag, "inherit", true);
        this.doServices(description.getTagsByName("scr.service", inherited), component, description);
        HashMap references = new HashMap();
        PropertyHandler propertyHandler = new PropertyHandler(component, ocd);
        JavaClassDescription currentDescription = description;
        do {
            JavaTag[] props = currentDescription.getTagsByName("scr.property", false);
            for (int i = 0; i < props.length; ++i) {
                propertyHandler.testProperty(props[i], null, description == currentDescription);
            }
            JavaTag[] refs = currentDescription.getTagsByName("scr.reference", false);
            for (int i = 0; i < refs.length; ++i) {
                this.testReference(references, refs[i], null, description == currentDescription);
            }
            JavaField[] fields = currentDescription.getFields();
            for (int i = 0; i < fields.length; ++i) {
                tag = fields[i].getTagByName("scr.reference");
                if (tag != null) {
                    this.testReference(references, tag, fields[i].getName(), description == currentDescription);
                }
                propertyHandler.handleField(fields[i], description == currentDescription);
            }
            currentDescription = currentDescription.getSuperClass();
        } while (inherited && currentDescription != null);
        propertyHandler.processProperties(this.properties);
        Iterator refIter = references.entrySet().iterator();
        while (refIter.hasNext()) {
            Map.Entry entry = refIter.next();
            String refName = entry.getKey().toString();
            Object[] values = (Object[])entry.getValue();
            tag = (JavaTag)values[0];
            this.doReference(tag, refName, component, values[1].toString());
        }
        boolean createPid = SCRDescriptorMojo.getBoolean(componentTag, "create-pid", true);
        if (createPid) {
            boolean found = false;
            Iterator iter = component.getProperties().iterator();
            while (!found && iter.hasNext()) {
                Property prop = (Property)iter.next();
                found = "service.pid".equals(prop.getName());
            }
            if (!found) {
                Property pid = new Property();
                component.addProperty(pid);
                pid.setName("service.pid");
                pid.setValue(component.getName());
            }
        }
        ArrayList issues = new ArrayList();
        ArrayList warnings = new ArrayList();
        component.validate(issues, warnings);
        Iterator i = warnings.iterator();
        while (i.hasNext()) {
            this.getLog().warn((CharSequence)((String)i.next()));
        }
        i = issues.iterator();
        while (i.hasNext()) {
            this.getLog().error((CharSequence)((String)i.next()));
        }
        return issues.size() == 0 ? component : null;
    }

    protected OCD doComponent(JavaTag tag, Component component, MetaData metaData) {
        String metaType;
        boolean hasMetaType;
        String abstractType = tag.getNamedParameter("abstract");
        if (abstractType != null) {
            component.setAbstract("yes".equalsIgnoreCase(abstractType) || "true".equalsIgnoreCase(abstractType));
        } else {
            component.setAbstract(tag.getJavaClassDescription().isAbstract());
        }
        String ds = tag.getNamedParameter("ds");
        component.setDs(ds == null ? true : "yes".equalsIgnoreCase(ds) || "true".equalsIgnoreCase(ds));
        String name = tag.getNamedParameter("name");
        component.setName(StringUtils.isEmpty((String)name) ? component.getImplementation().getClassame() : name);
        component.setEnabled(SCRDescriptorMojo.getBoolean(tag, "enabled", true));
        component.setFactory(tag.getNamedParameter("factory"));
        if (tag.getNamedParameter("immediate") != null) {
            component.setImmediate(SCRDescriptorMojo.getBoolean(tag, "immediate", true));
        }
        boolean bl = hasMetaType = (metaType = tag.getNamedParameter("metatype")) == null || "yes".equalsIgnoreCase(metaType) || "true".equalsIgnoreCase(metaType);
        if (hasMetaType) {
            OCD ocd = new OCD();
            metaData.addOCD(ocd);
            ocd.setId(component.getName());
            String ocdName = tag.getNamedParameter("label");
            if (ocdName == null) {
                ocdName = "%" + component.getName() + ".name";
            }
            ocd.setName(ocdName);
            String ocdDescription = tag.getNamedParameter("description");
            if (ocdDescription == null) {
                ocdDescription = "%" + component.getName() + ".description";
            }
            ocd.setDescription(ocdDescription);
            Designate designate = new Designate();
            metaData.addDesignate(designate);
            designate.setPid(component.getName());
            MTObject mtobject = new MTObject();
            designate.setObject(mtobject);
            mtobject.setOcdref(component.getName());
            return ocd;
        }
        return null;
    }

    protected void doServices(JavaTag[] services, Component component, JavaClassDescription description) throws MojoExecutionException {
        if (services == null || services.length == 0) {
            return;
        }
        Service service = new Service();
        component.setService(service);
        boolean serviceFactory = false;
        for (int i = 0; i < services.length; ++i) {
            String name = services[i].getNamedParameter("interface");
            if (StringUtils.isEmpty((String)name)) {
                this.addInterfaces(service, services[i], description);
            } else {
                String interfaceName = name;
                if (description instanceof QDoxJavaClassDescription) {
                    JavaClassDescription serviceClass = description.getReferencedClass(name);
                    if (serviceClass == null) {
                        throw new MojoExecutionException("Interface '" + name + "' in class " + description.getName() + " does not point to a valid class/interface.");
                    }
                    interfaceName = serviceClass.getName();
                }
                Interface interf = new Interface(services[i]);
                interf.setInterfacename(interfaceName);
                service.addInterface(interf);
            }
            serviceFactory |= SCRDescriptorMojo.getBoolean(services[i], "servicefactory", false);
        }
        service.setServicefactory(serviceFactory);
    }

    protected void addInterfaces(Service service, JavaTag serviceTag, JavaClassDescription description) throws MojoExecutionException {
        if (description != null) {
            JavaClassDescription[] interfaces = description.getImplementedInterfaces();
            for (int j = 0; j < interfaces.length; ++j) {
                Interface interf = new Interface(serviceTag);
                interf.setInterfacename(interfaces[j].getName());
                service.addInterface(interf);
                this.addInterfaces(service, serviceTag, interfaces[j]);
            }
            this.addInterfaces(service, serviceTag, description.getSuperClass());
        }
    }

    protected void testReference(Map references, JavaTag reference, String defaultName, boolean isInspectedClass) throws MojoExecutionException {
        String refName = this.getReferenceName(reference, defaultName);
        if (refName != null) {
            if (references.containsKey(refName)) {
                if (isInspectedClass) {
                    throw new MojoExecutionException("Duplicate definition for reference " + refName + " in class " + reference.getJavaClassDescription().getName());
                }
            } else {
                String type = reference.getNamedParameter("interface");
                if (StringUtils.isEmpty((String)type)) {
                    if (reference.getField() != null) {
                        type = reference.getField().getType();
                    }
                } else if (isInspectedClass) {
                    JavaClassDescription serviceClass = reference.getJavaClassDescription().getReferencedClass(type);
                    if (serviceClass == null) {
                        throw new MojoExecutionException("Interface '" + type + "' in class " + reference.getJavaClassDescription().getName() + " does not point to a valid class/interface.");
                    }
                    type = serviceClass.getName();
                }
                references.put(refName, new Object[]{reference, type});
            }
        }
    }

    protected String getReferenceName(JavaTag reference, String defaultName) throws MojoExecutionException {
        String name = reference.getNamedParameter("name");
        if (!StringUtils.isEmpty((String)name)) {
            return name;
        }
        name = reference.getNamedParameter("nameRef");
        if (!StringUtils.isEmpty((String)name)) {
            JavaField refField = this.getReferencedField(reference, name);
            String[] values = refField.getInitializationExpression();
            if (values == null || values.length == 0) {
                throw new MojoExecutionException("Referenced field for " + name + " has no values for a reference name.");
            }
            if (values.length > 1) {
                throw new MojoExecutionException("Referenced field " + name + " has more than one value for a reference name.");
            }
            name = values[0];
        }
        return defaultName;
    }

    protected JavaField getReferencedField(JavaTag tag, String ref) throws MojoExecutionException {
        int classSep = ref.lastIndexOf(46);
        JavaField field = null;
        if (classSep == -1) {
            field = tag.getJavaClassDescription().getFieldByName(ref);
        }
        if (field == null) {
            field = tag.getJavaClassDescription().getExternalFieldByName(ref);
        }
        if (field == null) {
            throw new MojoExecutionException("Reference references unknown field " + ref + " in class " + tag.getJavaClassDescription().getName());
        }
        return field;
    }

    protected void doReference(JavaTag reference, String name, Component component, String type) throws MojoExecutionException {
        String strategy;
        String isChecked;
        String unbindValue;
        Reference ref = new Reference(reference, component.getJavaClassDescription());
        ref.setName(name);
        ref.setInterfacename(type);
        ref.setCardinality(reference.getNamedParameter("cardinality"));
        if (ref.getCardinality() == null) {
            ref.setCardinality("1..1");
        }
        ref.setPolicy(reference.getNamedParameter("policy"));
        if (ref.getPolicy() == null) {
            ref.setPolicy("static");
        }
        ref.setTarget(reference.getNamedParameter("target"));
        String bindValue = reference.getNamedParameter("bind");
        if (bindValue != null) {
            ref.setBind(bindValue);
        }
        if ((unbindValue = reference.getNamedParameter("unbind")) != null) {
            ref.setUnbind(unbindValue);
        }
        if ((isChecked = reference.getNamedParameter("checked")) != null) {
            ref.setChecked(Boolean.valueOf(isChecked));
        }
        if ((strategy = reference.getNamedParameter("strategy")) != null) {
            ref.setStrategy(strategy);
        }
        if (this.generateAccessors && !ref.isLookupStrategy() && reference.getField() != null && component.getJavaClassDescription() instanceof ModifiableJavaClassDescription && (ref.getCardinality().equals("0..1") || ref.getCardinality().equals("1..1"))) {
            boolean createBind = false;
            boolean createUnbind = false;
            if (bindValue == null && ref.findMethod(ref.getBind()) == null) {
                createBind = true;
            }
            if (unbindValue == null && ref.findMethod(ref.getUnbind()) == null) {
                createUnbind = true;
            }
            if (createBind || createUnbind) {
                ((ModifiableJavaClassDescription)((Object)component.getJavaClassDescription())).addMethods(name, type, createBind, createUnbind);
            }
        }
        component.addReference(ref);
    }

    public static boolean getBoolean(JavaTag tag, String name, boolean defaultValue) {
        String value = tag.getNamedParameter(name);
        return value == null ? defaultValue : Boolean.valueOf(value);
    }
}

