/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.scrplugin.SCRDescriptorMojo;
import org.apache.felix.scrplugin.om.Component;
import org.apache.felix.scrplugin.om.Property;
import org.apache.felix.scrplugin.om.metatype.AttributeDefinition;
import org.apache.felix.scrplugin.om.metatype.OCD;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class PropertyHandler {
    private final Map properties = new LinkedHashMap();
    private final Component component;
    private final OCD ocd;

    public PropertyHandler(Component c, OCD o) {
        this.component = c;
        this.ocd = o;
    }

    protected void processProperty(JavaTag tag, String name, JavaField javaField) throws MojoExecutionException {
        boolean isPrivate;
        Property prop = new Property(tag);
        prop.setName(name);
        prop.setType(tag.getNamedParameter("type"));
        String value = tag.getNamedParameter("value");
        if (value != null) {
            prop.setValue(value);
        } else {
            String valueRef = tag.getNamedParameter("valueRef");
            if (valueRef != null) {
                this.setPropertyValueRef(tag, prop, valueRef);
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                Map valueMap = tag.getNamedParameterMap();
                Iterator vi = valueMap.entrySet().iterator();
                while (vi.hasNext()) {
                    String[] stringValues;
                    Map.Entry entry = vi.next();
                    String key = (String)entry.getKey();
                    if (key.startsWith("values")) {
                        values.add(entry.getValue());
                        continue;
                    }
                    if (!key.startsWith("refValues") || (stringValues = this.getPropertyValueRef(tag, prop, (String)entry.getValue())) == null) continue;
                    for (int i = 0; i < stringValues.length; ++i) {
                        values.add(stringValues[i]);
                    }
                }
                if (values.size() > 0) {
                    prop.setMultiValue(values.toArray(new String[values.size()]));
                } else {
                    boolean isNamedParameter;
                    boolean bl = isNamedParameter = tag.getNamedParameter("name") != null || tag.getNamedParameter("nameRef") != null;
                    if (isNamedParameter && javaField != null) {
                        this.setPropertyValueRef(tag, prop, javaField.getName());
                    }
                }
            }
        }
        boolean bl = isPrivate = SCRDescriptorMojo.getBoolean(tag, "private", false) || name.equals("service.pid") || name.equals("service.description") || name.equals("service.id") || name.equals("service.ranking") || name.equals("service.vendor") || name.equals("service.bundleLocation") || name.equals("service.factoryPid");
        if (this.component.isAbstract()) {
            prop.setPrivate(isPrivate);
            prop.setLabel(tag.getNamedParameter("label"));
            prop.setDescription(tag.getNamedParameter("description"));
            prop.setCardinality(tag.getNamedParameter("cardinality"));
        }
        if (!isPrivate && this.ocd != null) {
            AttributeDefinition ad = new AttributeDefinition();
            this.ocd.getProperties().add(ad);
            ad.setId(prop.getName());
            ad.setType(prop.getType());
            String adName = tag.getNamedParameter("label");
            if (adName == null) {
                adName = "%" + prop.getName() + ".name";
            }
            ad.setName(adName);
            String adDesc = tag.getNamedParameter("description");
            if (adDesc == null) {
                adDesc = "%" + prop.getName() + ".description";
            }
            ad.setDescription(adDesc);
            String cValue = tag.getNamedParameter("cardinality");
            if (cValue != null) {
                if ("-".equals(cValue)) {
                    ad.setCardinality(new Integer(Integer.MIN_VALUE));
                } else if ("+".equals(cValue)) {
                    ad.setCardinality(new Integer(Integer.MAX_VALUE));
                } else {
                    try {
                        ad.setCardinality(Integer.valueOf(cValue));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
            ad.setDefaultValue(prop.getValue());
            ad.setDefaultMultiValue(prop.getMultiValue());
            String[] parameters = tag.getParameters();
            LinkedHashMap<String, String> options = null;
            for (int j = 0; j < parameters.length; ++j) {
                String optionValue;
                if ("options".equals(parameters[j])) {
                    options = new LinkedHashMap<String, String>();
                    continue;
                }
                if (options == null) continue;
                String optionLabel = parameters[j];
                String string = optionValue = j < parameters.length - 2 ? parameters[j + 2] : null;
                if (optionValue != null) {
                    options.put(optionLabel, optionValue);
                }
                j += 2;
            }
            ad.setOptions(options);
        }
        this.component.addProperty(prop);
    }

    protected String getPropertyName(JavaTag tag, JavaField field) throws MojoExecutionException {
        String name = tag.getNamedParameter("name");
        if (StringUtils.isEmpty((String)name)) {
            name = tag.getNamedParameter("nameRef");
            if (!StringUtils.isEmpty((String)name)) {
                JavaField refField = this.getReferencedField(tag, name);
                String[] values = refField.getInitializationExpression();
                if (values == null || values.length == 0) {
                    throw new MojoExecutionException("Referenced field for " + name + " has no values for a property name.");
                }
                if (values.length > 1) {
                    throw new MojoExecutionException("Referenced field " + name + " has more than one value for a property name.");
                }
                name = values[0];
            }
            if (StringUtils.isEmpty((String)name)) {
                String[] initValues;
                name = null;
                if (field != null && "java.lang.String".equals(field.getType()) && (initValues = field.getInitializationExpression()) != null && initValues.length == 1) {
                    name = initValues[0];
                }
            }
        }
        if (StringUtils.isEmpty((String)name)) {
            name = null;
        }
        return name;
    }

    protected void setPropertyValueRef(JavaTag tag, Property property, String valueRef) throws MojoExecutionException {
        String[] values = this.getPropertyValueRef(tag, property, valueRef);
        if (values != null && values.length == 1) {
            property.setValue(values[0]);
        } else if (values != null && values.length > 1) {
            property.setMultiValue(values);
        }
    }

    protected JavaField getReferencedField(JavaTag tag, String ref) throws MojoExecutionException {
        int classSep = ref.lastIndexOf(46);
        JavaField field = null;
        if (classSep == -1) {
            field = tag.getJavaClassDescription().getFieldByName(ref);
        }
        if (field == null) {
            field = tag.getJavaClassDescription().getExternalFieldByName(ref);
        }
        if (field == null) {
            throw new MojoExecutionException("Property references unknown field " + ref + " in class " + tag.getJavaClassDescription().getName());
        }
        return field;
    }

    protected String[] getPropertyValueRef(JavaTag tag, Property prop, String valueRef) throws MojoExecutionException {
        JavaField field = this.getReferencedField(tag, valueRef);
        if (prop.getType() == null) {
            String type = field.getType();
            if ("java.lang.String".equals(type)) {
                prop.setType("String");
            } else if ("java.lang.Long".equals(type) || "long".equals(type)) {
                prop.setType("Long");
            } else if ("java.lang.Double".equals(type) || "double".equals(type)) {
                prop.setType("Double");
            } else if ("java.lang.Float".equals(type) || "float".equals(type)) {
                prop.setType("Float");
            } else if ("java.lang.Integer".equals(type) || "int".equals(type)) {
                prop.setType("Integer");
            } else if ("java.lang.Byte".equals(type) || "byte".equals(type)) {
                prop.setType("Byte");
            } else if ("java.lang.Character".equals(type) || "char".equals(type)) {
                prop.setType("Char");
            } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
                prop.setType("Boolean");
            } else if ("java.lang.Short".equals(type) || "short".equals(type)) {
                prop.setType("Short");
            }
        }
        return field.getInitializationExpression();
    }

    public void testProperty(JavaTag property, JavaField field, boolean isInspectedClass) throws MojoExecutionException {
        String propName = this.getPropertyName(property, field);
        if (propName != null) {
            if (this.properties.containsKey(propName)) {
                if (isInspectedClass) {
                    throw new MojoExecutionException("Duplicate definition for property " + propName + " in class " + property.getJavaClassDescription().getName());
                }
            } else {
                this.properties.put(propName, new PropertyDescription(property, field));
            }
        } else {
            throw new MojoExecutionException("Property has no name " + property.getSourceLocation());
        }
    }

    public void handleField(JavaField javaField, boolean isInspectedClass) throws MojoExecutionException {
        JavaTag tag = javaField.getTagByName("scr.property");
        if (tag != null) {
            this.testProperty(tag, javaField, isInspectedClass);
        }
    }

    public void processProperties(Map globalProperties) throws MojoExecutionException {
        Iterator propIter = this.properties.entrySet().iterator();
        while (propIter.hasNext()) {
            Map.Entry entry = propIter.next();
            String propName = entry.getKey().toString();
            PropertyDescription desc = (PropertyDescription)entry.getValue();
            this.processProperty(desc.propertyTag, propName, desc.field);
        }
        if (globalProperties != null) {
            Iterator globalPropIter = globalProperties.entrySet().iterator();
            while (globalPropIter.hasNext()) {
                Map.Entry entry = globalPropIter.next();
                String name = entry.getKey().toString();
                if (this.properties.containsKey(name) || entry.getValue() == null) continue;
                String value = entry.getValue().toString();
                Property p = new Property();
                p.setName(name);
                p.setValue(value);
                p.setType("String");
                p.setPrivate(true);
                this.component.addProperty(p);
            }
        }
    }

    protected static final class PropertyDescription {
        public final JavaTag propertyTag;
        public final JavaField field;

        public PropertyDescription(JavaTag p, JavaField f) {
            this.propertyTag = p;
            this.field = f;
        }
    }
}

