/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.obrplugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.felix.obrplugin.Config;
import org.apache.felix.obrplugin.ObrUtils;
import org.apache.felix.obrplugin.RemoteFileManager;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ObrRemoteClean
extends AbstractMojo {
    private boolean ignoreLock;
    private String prefixUrl;
    private String remoteOBR;
    private String obrRepository;
    private List supportedProjectTypes = Arrays.asList("jar", "bundle");
    private ArtifactRepository deploymentRepository;
    private String altDeploymentRepository;
    private String obrDeploymentRepository;
    private MavenProject project;
    private Settings settings;
    private WagonManager m_wagonManager;
    private static final Pattern ALT_REPO_SYNTAX_PATTERN = Pattern.compile("(.+)::(.+)::(.+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException {
        String projectType = this.project.getPackaging();
        if (!this.supportedProjectTypes.contains(projectType)) {
            this.getLog().warn((CharSequence)("Ignoring project type " + projectType + " - supportedProjectTypes = " + this.supportedProjectTypes));
            return;
        }
        if ("NONE".equalsIgnoreCase(this.remoteOBR) || "false".equalsIgnoreCase(this.remoteOBR)) {
            this.getLog().info((CharSequence)"Remote OBR update disabled (enable with -DremoteOBR)");
            return;
        }
        if (null == this.remoteOBR || this.remoteOBR.trim().length() == 0 || "true".equalsIgnoreCase(this.remoteOBR)) {
            this.remoteOBR = this.obrRepository;
        }
        URI tempURI = ObrUtils.findRepositoryXml("", this.remoteOBR);
        String repositoryName = new File(tempURI.getSchemeSpecificPart()).getName();
        Log log = this.getLog();
        RemoteFileManager remoteFile = new RemoteFileManager(this.m_wagonManager, this.settings, log);
        this.openRepositoryConnection(remoteFile);
        if (null == this.prefixUrl) {
            this.prefixUrl = remoteFile.toString();
        }
        log.info((CharSequence)("LOCK " + remoteFile + '/' + repositoryName));
        remoteFile.lockFile(repositoryName, this.ignoreLock);
        File downloadedRepositoryXml = null;
        try {
            try {
                log.info((CharSequence)("Downloading " + repositoryName));
                downloadedRepositoryXml = remoteFile.get(repositoryName, ".xml");
                URI repositoryXml = downloadedRepositoryXml.toURI();
                Config userConfig = new Config();
                userConfig.setRemoteFile(true);
                Document doc = this.parseFile(new File(repositoryXml), this.initConstructor());
                Element finalDocument = this.cleanDocument(doc.getDocumentElement());
                if (finalDocument == null) {
                    this.getLog().info((CharSequence)("Nothing to clean in " + repositoryName));
                }
                this.writeToFile(repositoryXml, finalDocument);
                this.getLog().info((CharSequence)("Repository " + repositoryName + " cleaned"));
                log.info((CharSequence)("Uploading " + repositoryName));
                remoteFile.put(downloadedRepositoryXml, repositoryName);
            }
            catch (Exception e) {
                log.warn((CharSequence)("Exception while updating remote OBR: " + e.getLocalizedMessage()), (Throwable)e);
                Object var12_13 = null;
                log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
                remoteFile.unlockFile(repositoryName);
                remoteFile.disconnect();
                if (null == downloadedRepositoryXml) return;
                downloadedRepositoryXml.delete();
                return;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
            remoteFile.unlockFile(repositoryName);
            remoteFile.disconnect();
            if (null == downloadedRepositoryXml) throw throwable;
            downloadedRepositoryXml.delete();
            throw throwable;
        }
        log.info((CharSequence)("UNLOCK " + remoteFile + '/' + repositoryName));
        remoteFile.unlockFile(repositoryName);
        remoteFile.disconnect();
        if (null == downloadedRepositoryXml) return;
        downloadedRepositoryXml.delete();
    }

    private void openRepositoryConnection(RemoteFileManager remoteFile) throws MojoExecutionException {
        if (this.obrDeploymentRepository != null) {
            this.altDeploymentRepository = this.obrDeploymentRepository;
        }
        if (this.deploymentRepository == null && this.altDeploymentRepository == null) {
            String msg = "Deployment failed: repository element was not specified in the pom inside distributionManagement element or in -DaltDeploymentRepository=id::layout::url parameter";
            throw new MojoExecutionException(msg);
        }
        if (this.altDeploymentRepository != null) {
            this.getLog().info((CharSequence)("Using alternate deployment repository " + this.altDeploymentRepository));
            Matcher matcher = ALT_REPO_SYNTAX_PATTERN.matcher(this.altDeploymentRepository);
            if (!matcher.matches()) {
                throw new MojoExecutionException("Invalid syntax for alternative repository \"" + this.altDeploymentRepository + "\". Use \"id::layout::url\".");
            }
            remoteFile.connect(matcher.group(1).trim(), matcher.group(3).trim());
        } else {
            remoteFile.connect(this.deploymentRepository.getId(), this.deploymentRepository.getUrl());
        }
    }

    private Element cleanDocument(Element elem) {
        NodeList nodes = elem.getElementsByTagName("resource");
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            URL url;
            Element n = (Element)nodes.item(i);
            String value = n.getAttribute("uri");
            try {
                url = new URL(new URL(this.prefixUrl + '/'), value);
            }
            catch (MalformedURLException e) {
                this.getLog().error((CharSequence)("Malformed URL when creating the resource absolute URI : " + e.getMessage()));
                return null;
            }
            try {
                url.openConnection().getContent();
                continue;
            }
            catch (IOException e) {
                this.getLog().info((CharSequence)("The bundle " + n.getAttribute("presentationname") + " - " + n.getAttribute("version") + " will be removed : " + e.getMessage()));
                toRemove.add(n);
            }
        }
        Date d = new Date();
        if (toRemove.size() > 0) {
            System.out.println("Do you want to remove these bundles from the repository file [y/N]:");
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String answer = null;
            try {
                answer = br.readLine();
            }
            catch (IOException ioe) {
                this.getLog().error((CharSequence)"IO error trying to read the user confirmation");
                return null;
            }
            if (answer != null && answer.trim().equalsIgnoreCase("y")) {
                for (int i = 0; i < toRemove.size(); ++i) {
                    elem.removeChild((Node)toRemove.get(i));
                }
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
                d.setTime(System.currentTimeMillis());
                elem.setAttribute("lastmodified", format.format(d));
                return elem;
            }
            return null;
        }
        return null;
    }

    private DocumentBuilder initConstructor() throws MojoExecutionException {
        DocumentBuilder constructor = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            constructor = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.getLog().error((CharSequence)"Unable to create a new xml document");
            throw new MojoExecutionException("Cannot create the Document Builder : " + e.getMessage());
        }
        return constructor;
    }

    private Document parseFile(File file, DocumentBuilder constructor) throws MojoExecutionException {
        if (constructor == null) {
            return null;
        }
        File targetFile = file.getAbsoluteFile();
        this.getLog().info((CharSequence)("Parsing " + targetFile));
        Document doc = null;
        try {
            doc = constructor.parse(targetFile);
        }
        catch (SAXException e) {
            this.getLog().error((CharSequence)("Cannot parse " + targetFile + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot parse " + targetFile + " : " + e.getMessage());
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Cannot open " + targetFile + " : " + e.getMessage()));
            throw new MojoExecutionException("Cannot open " + targetFile + " : " + e.getMessage());
        }
        return doc;
    }

    private void writeToFile(URI outputFilename, Node treeToBeWrite) throws MojoExecutionException {
        Transformer transformer = null;
        TransformerFactory tfabrique = TransformerFactory.newInstance();
        try {
            transformer = tfabrique.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + outputFilename.toString()));
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        Properties proprietes = new Properties();
        proprietes.put("method", "xml");
        proprietes.put("version", "1.0");
        proprietes.put("encoding", "ISO-8859-1");
        proprietes.put("standalone", "yes");
        proprietes.put("indent", "yes");
        proprietes.put("omit-xml-declaration", "no");
        transformer.setOutputProperties(proprietes);
        DOMSource input = new DOMSource(treeToBeWrite);
        File fichier = new File(outputFilename);
        FileOutputStream flux = null;
        try {
            flux = new FileOutputStream(fichier);
        }
        catch (FileNotFoundException e) {
            this.getLog().error((CharSequence)("Unable to write to file: " + fichier.getName()));
            throw new MojoExecutionException("Unable to write to file: " + fichier.getName() + " : " + e.getMessage());
        }
        StreamResult output = new StreamResult(flux);
        try {
            transformer.transform(input, output);
        }
        catch (TransformerException e) {
            throw new MojoExecutionException("Unable to write to file: " + outputFilename.toString() + " : " + e.getMessage());
        }
        try {
            flux.flush();
            flux.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException when closing file : " + e.getMessage());
        }
    }
}

