/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.security.model;

import java.util.Set;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodec;
import org.apache.dubbo.spring.security.jackson.ObjectMapperCodecCustomer;

@Activate(onClass={"org.springframework.security.core.context.SecurityContextHolder", "org.springframework.security.jackson2.CoreJackson2Module", "com.fasterxml.jackson.databind.ObjectMapper", "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.databind.module.SimpleModule"})
public class SecurityScopeModelInitializer
implements ScopeModelInitializer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void initializeFrameworkModel(FrameworkModel frameworkModel) {
        ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
        try {
            ObjectMapperCodec objectMapperCodec = new ObjectMapperCodec();
            Set objectMapperCodecCustomerList = frameworkModel.getExtensionLoader(ObjectMapperCodecCustomer.class).getSupportedExtensionInstances();
            for (ObjectMapperCodecCustomer objectMapperCodecCustomer : objectMapperCodecCustomerList) {
                objectMapperCodecCustomer.customize(objectMapperCodec);
            }
            beanFactory.registerBean((Object)objectMapperCodec);
        }
        catch (Throwable t) {
            this.logger.info("Failed to initialize ObjectMapperCodecCustomer and spring security related features are disabled.", t);
        }
    }

    public void initializeApplicationModel(ApplicationModel applicationModel) {
    }

    public void initializeModuleModel(ModuleModel moduleModel) {
    }
}

