/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.actuate.endpoint.metadata;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.spring.ReferenceBean;
import org.apache.dubbo.config.spring.beans.factory.annotation.ReferenceAnnotationBeanPostProcessor;
import org.apache.dubbo.spring.boot.actuate.endpoint.metadata.AbstractDubboMetadata;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.stereotype.Component;

@Component
public class DubboReferencesMetadata
extends AbstractDubboMetadata {
    public Map<String, Map<String, Object>> references() {
        LinkedHashMap<String, Map<String, Object>> referencesMetadata = new LinkedHashMap<String, Map<String, Object>>();
        ReferenceAnnotationBeanPostProcessor beanPostProcessor = this.getReferenceAnnotationBeanPostProcessor();
        referencesMetadata.putAll(this.buildReferencesMetadata(beanPostProcessor.getInjectedFieldReferenceBeanMap()));
        referencesMetadata.putAll(this.buildReferencesMetadata(beanPostProcessor.getInjectedMethodReferenceBeanMap()));
        return referencesMetadata;
    }

    private Map<String, Map<String, Object>> buildReferencesMetadata(Map<InjectionMetadata.InjectedElement, ReferenceBean<?>> injectedElementReferenceBeanMap) {
        LinkedHashMap<String, Map<String, Object>> referencesMetadata = new LinkedHashMap<String, Map<String, Object>>();
        for (Map.Entry<InjectionMetadata.InjectedElement, ReferenceBean<?>> entry : injectedElementReferenceBeanMap.entrySet()) {
            InjectionMetadata.InjectedElement injectedElement = entry.getKey();
            ReferenceBean<?> referenceBean = entry.getValue();
            ReferenceConfig referenceConfig = referenceBean.getReferenceConfig();
            Map<String, Object> beanMetadata = null;
            beanMetadata = referenceConfig != null ? this.resolveBeanMetadata(referenceConfig) : new LinkedHashMap<String, Object>();
            referencesMetadata.put(String.valueOf(injectedElement.getMember()), beanMetadata);
        }
        return referencesMetadata;
    }
}

