/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import java.util.Arrays;
import org.apache.dubbo.common.beans.factory.ScopeBeanFactory;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2SecurityManager;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;

public class Fastjson2ScopeModelInitializer
implements ScopeModelInitializer {
    public void initializeFrameworkModel(FrameworkModel frameworkModel) {
        boolean classExist = false;
        try {
            for (String className : Arrays.asList("com.alibaba.fastjson2.JSONB", "com.alibaba.fastjson2.reader.ObjectReaderCreatorASM", "com.alibaba.fastjson2.writer.ObjectWriterCreatorASM", "com.alibaba.fastjson2.JSONValidator", "com.alibaba.fastjson2.JSONFactory", "com.alibaba.fastjson2.JSONWriter", "com.alibaba.fastjson2.util.TypeUtils", "com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler")) {
                Class aClass = ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
                if (aClass != null) continue;
                throw new ClassNotFoundException(className);
            }
            classExist = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (classExist) {
            ScopeBeanFactory beanFactory = frameworkModel.getBeanFactory();
            beanFactory.registerBean(Fastjson2CreatorManager.class);
            beanFactory.registerBean(Fastjson2SecurityManager.class);
        }
    }

    public void initializeApplicationModel(ApplicationModel applicationModel) {
    }

    public void initializeModuleModel(ModuleModel moduleModel) {
    }
}

