/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.serialize.fastjson2;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.filter.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.apache.dubbo.common.serialize.ObjectInput;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2CreatorManager;
import org.apache.dubbo.common.serialize.fastjson2.Fastjson2SecurityManager;
import org.apache.dubbo.common.utils.ClassUtils;

public class FastJson2ObjectInput
implements ObjectInput {
    private final Fastjson2CreatorManager fastjson2CreatorManager;
    private final Fastjson2SecurityManager fastjson2SecurityManager;
    private volatile ClassLoader classLoader;
    private final InputStream is;

    public FastJson2ObjectInput(Fastjson2CreatorManager fastjson2CreatorManager, Fastjson2SecurityManager fastjson2SecurityManager, InputStream in) {
        this.fastjson2CreatorManager = fastjson2CreatorManager;
        this.fastjson2SecurityManager = fastjson2SecurityManager;
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.is = in;
        fastjson2CreatorManager.setCreator(this.classLoader);
    }

    public boolean readBool() throws IOException {
        return this.readObject(Boolean.TYPE);
    }

    public byte readByte() throws IOException {
        return this.readObject(Byte.TYPE);
    }

    public short readShort() throws IOException {
        return this.readObject(Short.TYPE);
    }

    public int readInt() throws IOException {
        return this.readObject(Integer.TYPE);
    }

    public long readLong() throws IOException {
        return this.readObject(Long.TYPE);
    }

    public float readFloat() throws IOException {
        return this.readObject(Float.TYPE).floatValue();
    }

    public double readDouble() throws IOException {
        return this.readObject(Double.TYPE);
    }

    public String readUTF() throws IOException {
        return this.readObject(String.class);
    }

    public byte[] readBytes() throws IOException {
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        return bytes;
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        return this.readObject(Object.class);
    }

    public <T> T readObject(Class<T> cls) throws IOException {
        this.updateClassLoaderIfNeed();
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        Fastjson2SecurityManager.Handler securityFilter = this.fastjson2SecurityManager.getSecurityFilter();
        Object result = securityFilter.isCheckSerializable() ? JSONB.parseObject((byte[])bytes, cls, (Filter)securityFilter, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.ErrorOnNoneSerializable, JSONReader.Feature.IgnoreAutoTypeNotMatch, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased}) : JSONB.parseObject((byte[])bytes, cls, (Filter)securityFilter, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.IgnoreAutoTypeNotMatch, JSONReader.Feature.FieldBased});
        if (result != null && cls != null && !ClassUtils.isMatch(result.getClass(), cls)) {
            throw new IllegalArgumentException("deserialize failed. expected class: " + cls + " but actual class: " + result.getClass());
        }
        return (T)result;
    }

    public <T> T readObject(Class<T> cls, Type type) throws IOException, ClassNotFoundException {
        this.updateClassLoaderIfNeed();
        int length = this.readLength();
        byte[] bytes = new byte[length];
        int read = this.is.read(bytes, 0, length);
        if (read != length) {
            throw new IllegalArgumentException("deserialize failed. expected read length: " + length + " but actual read: " + read);
        }
        Fastjson2SecurityManager.Handler securityFilter = this.fastjson2SecurityManager.getSecurityFilter();
        Object result = securityFilter.isCheckSerializable() ? JSONB.parseObject((byte[])bytes, cls, (Filter)securityFilter, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.ErrorOnNoneSerializable, JSONReader.Feature.IgnoreAutoTypeNotMatch, JSONReader.Feature.UseNativeObject, JSONReader.Feature.FieldBased}) : JSONB.parseObject((byte[])bytes, cls, (Filter)securityFilter, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.UseDefaultConstructorAsPossible, JSONReader.Feature.UseNativeObject, JSONReader.Feature.IgnoreAutoTypeNotMatch, JSONReader.Feature.FieldBased});
        if (result != null && cls != null && !ClassUtils.isMatch(result.getClass(), cls)) {
            throw new IllegalArgumentException("deserialize failed. expected class: " + cls + " but actual class: " + result.getClass());
        }
        return (T)result;
    }

    private void updateClassLoaderIfNeed() {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        if (currentClassLoader != this.classLoader) {
            this.fastjson2CreatorManager.setCreator(currentClassLoader);
            this.classLoader = currentClassLoader;
        }
    }

    private int readLength() throws IOException {
        byte[] bytes = new byte[4];
        int read = this.is.read(bytes, 0, 4);
        if (read != 4) {
            throw new IllegalArgumentException("deserialize failed. expected read length: 4 but actual read: " + read);
        }
        int value = 0;
        for (byte b : bytes) {
            value = (value << 8) + (b & 0xFF);
        }
        return value;
    }
}

