/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.util;

import java.util.function.Function;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.lang.Prioritized;
import org.apache.dubbo.rpc.protocol.tri.rest.filter.RestExtension;

public final class RestUtils {
    private RestUtils() {
    }

    public static boolean hasPlaceholder(String text) {
        if (text == null) {
            return false;
        }
        int len = text.length();
        if (len < 4) {
            return false;
        }
        int state = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '$') {
                state = 1;
                continue;
            }
            if (c == '{') {
                if (state != true) continue;
                if (text.charAt(i - 1) != '$') {
                    return false;
                }
                state = 2;
                continue;
            }
            if (c != '}' || state != 2) continue;
            return true;
        }
        return false;
    }

    public static String replacePlaceholder(String text, Function<String, String> resolver) {
        String value;
        if (text == null) {
            return null;
        }
        int len = text.length();
        if (len < 2) {
            return text;
        }
        int p = 0;
        int nameStart = 0;
        int nameEnd = 0;
        int valueStart = 0;
        int valueEnd = 0;
        StringBuilder buf = null;
        int state = 0;
        block19: for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '$': {
                    if (state == 0) {
                        if (buf == null) {
                            buf = new StringBuilder(len);
                        }
                        buf.append(text, p, i);
                        p = i;
                        state = 1;
                        continue block19;
                    }
                    if (state != 1) continue block19;
                    if (buf == null) {
                        buf = new StringBuilder(len);
                    }
                    buf.append(text, p, i - 1);
                    p = i;
                    state = 0;
                    continue block19;
                }
                case '{': {
                    state = state == 1 ? 2 : 0;
                    continue block19;
                }
                case ':': {
                    state = state == 5 ? 3 : 0;
                    continue block19;
                }
                case '}': {
                    switch (state) {
                        case 1: 
                        case 2: {
                            state = 0;
                            continue block19;
                        }
                        case 3: {
                            state = 0;
                            valueStart = i;
                            continue block19;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            value = resolver.apply(text.substring(nameStart, nameEnd));
                            if (buf == null) {
                                buf = new StringBuilder(len);
                            }
                            if (value == null) {
                                if (state == 6) {
                                    buf.append(text, valueStart, valueEnd);
                                } else {
                                    buf.append(text, p, i + 1);
                                }
                            } else {
                                buf.append(value);
                            }
                            p = i + 1;
                            state = 0;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (state != 4) continue block19;
                    state = 0;
                    value = resolver.apply(text.substring(nameStart, nameEnd));
                    if (buf == null) {
                        buf = new StringBuilder(len);
                    }
                    if (value == null) {
                        buf.append(text, p, i);
                    } else {
                        buf.append(value);
                    }
                    p = i;
                    continue block19;
                }
                default: {
                    switch (state) {
                        case 1: {
                            state = 4;
                            nameStart = i;
                            continue block19;
                        }
                        case 2: {
                            state = 5;
                            nameStart = i;
                            continue block19;
                        }
                        case 3: {
                            state = 6;
                            valueStart = i;
                            continue block19;
                        }
                        case 4: 
                        case 5: {
                            nameEnd = i + 1;
                            continue block19;
                        }
                        case 6: {
                            valueEnd = i + 1;
                            continue block19;
                        }
                    }
                }
            }
        }
        if (state == 4) {
            value = resolver.apply(text.substring(nameStart, nameEnd));
            if (buf == null) {
                buf = new StringBuilder(len);
            }
            if (value == null) {
                buf.append(text, p, len);
            } else {
                buf.append(value);
            }
        } else {
            if (buf == null) {
                return text;
            }
            buf.append(text, p, len);
        }
        return buf.toString();
    }

    public static boolean isMaybeJSONObject(String str) {
        int i;
        if (str == null) {
            return false;
        }
        int n = str.length();
        if (n < 3) {
            return false;
        }
        char expected = '\u0000';
        for (i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (c == '{') {
                expected = '}';
                break;
            }
            return false;
        }
        for (int j = n - 1; j > i; --j) {
            char c = str.charAt(j);
            if (Character.isWhitespace(c)) continue;
            return c == expected;
        }
        return false;
    }

    public static int getPriority(Object obj) {
        int priority;
        if (obj instanceof Prioritized && (priority = ((Prioritized)obj).getPriority()) != 0) {
            return priority;
        }
        Activate activate = obj.getClass().getAnnotation(Activate.class);
        return activate == null ? 0 : activate.order();
    }

    public static String[] getPattens(Object obj) {
        return obj instanceof RestExtension ? ((RestExtension)obj).getPatterns() : null;
    }

    private static interface State {
        public static final int START = 0;
        public static final int DOLLAR = 1;
        public static final int BRACE_OPEN = 2;
        public static final int COLON = 3;
        public static final int DOLLAR_NAME_START = 4;
        public static final int NAME_START = 5;
        public static final int VALUE_START = 6;
    }
}

